/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.progress;

import android.os.Message;
import com.okhttplib.bean.ProgressMessage;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody
extends RequestBody {
    private final RequestBody originalRequestBody;
    private final ProgressCallback progressCallback;
    private BufferedSink bufferedSink;
    private String timeStamp;
    private String requestTag;

    public ProgressRequestBody(RequestBody originalRequestBody, ProgressCallback progressCallback, String timeStamp, String requestTag) {
        this.progressCallback = progressCallback;
        this.originalRequestBody = originalRequestBody;
        this.timeStamp = timeStamp;
        this.requestTag = requestTag;
    }

    public MediaType contentType() {
        return this.originalRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.originalRequestBody.contentLength();
    }

    public void writeTo(BufferedSink originalSink) throws IOException {
        if (this.bufferedSink == null) {
            this.bufferedSink = Okio.buffer((Sink)this.sink((Sink)originalSink));
        }
        this.originalRequestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }

    private Sink sink(Sink originalSink) {
        return new ForwardingSink(originalSink){
            long bytesWritten;
            long contentLength;
            int lastPercent;
            {
                this.bytesWritten = 0L;
                this.contentLength = 0L;
                this.lastPercent = 0;
            }

            public void write(Buffer source, long byteCount) throws IOException {
                int percent;
                super.write(source, byteCount);
                if (this.contentLength == 0L) {
                    this.contentLength = ProgressRequestBody.this.contentLength();
                }
                this.bytesWritten += byteCount;
                if (null != ProgressRequestBody.this.progressCallback && (percent = (int)(100L * this.bytesWritten / this.contentLength)) != this.lastPercent) {
                    this.lastPercent = percent;
                    ProgressRequestBody.this.progressCallback.onProgressAsync(percent, this.bytesWritten, this.contentLength, this.bytesWritten == this.contentLength);
                    Message msg = new ProgressMessage(2, ProgressRequestBody.this.progressCallback, percent, this.bytesWritten, this.contentLength, this.bytesWritten == this.contentLength, ProgressRequestBody.this.requestTag).build();
                    OkMainHandler.getInstance().sendMessage(msg);
                }
            }
        };
    }
}

