/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.app.Application;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.OkHttpUtilInterface;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.BaseCallback;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.OkHttpHelper;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpUtil
implements OkHttpUtilInterface {
    private final String TAG = this.getClass().getSimpleName();
    private static Application application;
    private static Builder builderGlobal;
    private static OkHttpClient httpClient;
    private static ExecutorService executorService;
    private Builder builder;
    private int cacheSurvivalTime = 0;
    private int cacheType = 1;

    public static Builder init(Application context) {
        application = context;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new BaseActivityLifecycleCallbacks());
        return OkHttpUtil.BuilderGlobal();
    }

    public static OkHttpUtilInterface getDefault() {
        return new Builder(false).isDefault(true).build();
    }

    public static OkHttpUtilInterface getDefault(Object requestTag) {
        return new Builder(false).isDefault(true).build(requestTag);
    }

    @Override
    public HttpInfo doSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(info.getRequestType()).helperInfo(this.packageHelperInfo()).build().doRequestSync();
    }

    @Override
    public void doAsync(HttpInfo info, BaseCallback callback) {
        OkHttpHelper.Builder().httpInfo(info).requestType(info.getRequestType()).callback(callback).helperInfo(this.packageHelperInfo()).build().doRequestAsync();
    }

    @Override
    public HttpInfo doPostSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(1).helperInfo(this.packageHelperInfo()).build().doRequestSync();
    }

    @Override
    public HttpInfo doPostSync(HttpInfo info, ProgressCallback callback) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(1).progressCallback(callback).helperInfo(this.packageHelperInfo()).build().doRequestSync();
    }

    @Override
    public void doPostAsync(HttpInfo info, BaseCallback callback) {
        OkHttpHelper.Builder().httpInfo(info).requestType(1).callback(callback).helperInfo(this.packageHelperInfo()).build().doRequestAsync();
    }

    @Override
    public void doPostAsync(HttpInfo info, ProgressCallback callback) {
        OkHttpHelper.Builder().httpInfo(info).requestType(1).progressCallback(callback).helperInfo(this.packageHelperInfo()).build().doRequestAsync();
    }

    @Override
    public HttpInfo doGetSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(2).helperInfo(this.packageHelperInfo()).build().doRequestSync();
    }

    @Override
    public void doGetAsync(HttpInfo info, BaseCallback callback) {
        OkHttpHelper.Builder().httpInfo(info).requestType(2).callback(callback).helperInfo(this.packageHelperInfo()).build().doRequestAsync();
    }

    @Override
    public void doUploadFileAsync(final HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (final UploadFileInfo fileInfo : uploadFiles) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpHelper.Builder().httpInfo(info).uploadFileInfo(fileInfo).requestType(1).helperInfo(OkHttpUtil.this.packageHelperInfo()).build().uploadFile();
                }
            });
        }
    }

    @Override
    public void doUploadFileAsync(final HttpInfo info, final ProgressCallback callback) {
        final List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).uploadFileInfoList(uploadFiles).requestType(1).progressCallback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo()).build().uploadFile();
            }
        });
    }

    @Override
    public void doUploadFileSync(HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (UploadFileInfo fileInfo : uploadFiles) {
            OkHttpHelper.Builder().httpInfo(info).uploadFileInfo(fileInfo).requestType(1).helperInfo(this.packageHelperInfo()).build().uploadFile();
        }
    }

    @Override
    public void doUploadFileSync(HttpInfo info, ProgressCallback callback) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        OkHttpHelper.Builder().httpInfo(info).uploadFileInfoList(uploadFiles).requestType(1).progressCallback(callback).helperInfo(this.packageHelperInfo()).build().uploadFile();
    }

    @Override
    public void doDownloadFileAsync(final HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (final DownloadFileInfo fileInfo : downloadFiles) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpHelper.Builder().httpInfo(info).downloadFileInfo(fileInfo).requestType(2).clientBuilder(OkHttpUtil.this.newBuilderFromCopy()).helperInfo(OkHttpUtil.this.packageHelperInfo()).build().downloadFile();
                }
            });
        }
    }

    @Override
    public void doDownloadFileSync(HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (DownloadFileInfo fileInfo : downloadFiles) {
            OkHttpHelper.Builder().httpInfo(info).downloadFileInfo(fileInfo).requestType(2).clientBuilder(this.newBuilderFromCopy()).helperInfo(this.packageHelperInfo()).build().downloadFile();
        }
    }

    @Override
    public HttpInfo doDeleteSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(4).helperInfo(this.packageHelperInfo()).build().doRequestSync();
    }

    @Override
    public void doDeleteAsync(HttpInfo info, BaseCallback callback) {
        OkHttpHelper.Builder().httpInfo(info).requestType(4).callback(callback).helperInfo(this.packageHelperInfo()).build().doRequestAsync();
    }

    @Override
    public HttpInfo doPutSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(3).helperInfo(this.packageHelperInfo()).build().doRequestSync();
    }

    @Override
    public void doPutAsync(HttpInfo info, BaseCallback callback) {
        OkHttpHelper.Builder().httpInfo(info).requestType(3).callback(callback).helperInfo(this.packageHelperInfo()).build().doRequestAsync();
    }

    @Override
    public void cancelRequest(Object requestTag) {
        BaseActivityLifecycleCallbacks.cancel(OkHttpUtil.parseRequestTag(requestTag));
    }

    @Override
    public OkHttpClient getDefaultClient() {
        return httpClient;
    }

    public void setDefaultClient(OkHttpClient client) {
        httpClient = client;
    }

    public boolean isNetworkAvailable() {
        if (application == null) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)application.getSystemService("connectivity");
        NetworkInfo net = cm.getActiveNetworkInfo();
        return net != null && net.getState() == NetworkInfo.State.CONNECTED;
    }

    private OkHttpUtil(Builder builder) {
        this.builder = builder;
        this.cacheType = builder.cacheType;
        this.cacheSurvivalTime = builder.cacheSurvivalTime;
        if (null == application) {
            this.cacheType = 1;
        }
        if (null == executorService) {
            executorService = Executors.newCachedThreadPool();
        }
        BaseActivityLifecycleCallbacks.setShowLifecycleLog(builder.showLifecycleLog);
        if (builder.isGlobalConfig) {
            OkHttpHelper.Builder().helperInfo(this.packageHelperInfo()).build();
        }
    }

    private HelperInfo packageHelperInfo() {
        HelperInfo helperInfo = new HelperInfo();
        helperInfo.setShowHttpLog(this.builder.showHttpLog);
        helperInfo.setRequestTag(this.builder.requestTag);
        int random = 1000 + (int)(Math.random() * 999.0);
        String timeStamp = System.currentTimeMillis() + "_" + random;
        helperInfo.setTimeStamp(timeStamp);
        helperInfo.setExceptionInterceptors(this.builder.exceptionInterceptors);
        helperInfo.setResultInterceptors(this.builder.resultInterceptors);
        helperInfo.setDownloadFileDir(this.builder.downloadFileDir);
        helperInfo.setClientBuilder(this.newBuilderFromCopy());
        helperInfo.setOkHttpUtil(this);
        helperInfo.setDefault(this.builder.isDefault);
        helperInfo.setLogTAG(this.builder.httpLogTAG == null ? this.TAG : this.builder.httpLogTAG);
        helperInfo.setResponseEncoding(this.builder.responseEncoding);
        helperInfo.setCacheSurvivalTime(this.cacheSurvivalTime);
        helperInfo.setCacheType(this.cacheType);
        helperInfo.setGzip(this.builder.isGzip);
        return helperInfo;
    }

    private OkHttpClient.Builder newBuilderFromCopy() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)this.builder.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.builder.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.builder.writeTimeout, TimeUnit.SECONDS).cache(new Cache(this.builder.cachedDir, (long)this.builder.maxCacheSize)).retryOnConnectionFailure(this.builder.retryOnConnectionFailure);
        if (null != this.builder.networkInterceptors && !this.builder.networkInterceptors.isEmpty()) {
            clientBuilder.networkInterceptors().addAll(this.builder.networkInterceptors);
        }
        if (null != this.builder.interceptors && !this.builder.interceptors.isEmpty()) {
            clientBuilder.interceptors().addAll(this.builder.interceptors);
        }
        if (null != this.builder.cookieJar) {
            clientBuilder.cookieJar(this.builder.cookieJar);
        }
        return clientBuilder;
    }

    public static Builder Builder() {
        return new Builder(false);
    }

    private static Builder BuilderGlobal() {
        return new Builder(true).isDefault(true);
    }

    private static String parseRequestTag(Object object) {
        String requestTag = null;
        if (null != object) {
            requestTag = object.getClass().getName();
            if (requestTag.contains("$")) {
                requestTag = requestTag.substring(0, requestTag.indexOf("$"));
            }
            if (object instanceof String || object instanceof Float || object instanceof Double || object instanceof Integer) {
                requestTag = String.valueOf(object);
            }
        }
        return requestTag;
    }

    @Override
    public boolean deleteCache() {
        try {
            if (httpClient != null && httpClient.cache() != null) {
                httpClient.cache().delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static final class Builder {
        private int maxCacheSize;
        private File cachedDir;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private boolean retryOnConnectionFailure;
        private List<Interceptor> networkInterceptors;
        private List<Interceptor> interceptors;
        private List<ResultInterceptor> resultInterceptors;
        private List<ExceptionInterceptor> exceptionInterceptors;
        private int cacheSurvivalTime;
        private int cacheType;
        private boolean isGlobalConfig;
        private boolean showHttpLog;
        private String httpLogTAG;
        private boolean showLifecycleLog;
        private String downloadFileDir;
        private String requestTag;
        private CookieJar cookieJar;
        private boolean isDefault;
        private String responseEncoding = "UTF-8";
        private boolean isGzip = false;

        public Builder() {
        }

        public Builder(boolean isGlobal) {
            this.isGlobalConfig = isGlobal;
            this.initDefaultConfig();
            if (!isGlobal && null != builderGlobal) {
                this.initGlobalConfig(builderGlobal);
            }
        }

        public OkHttpUtilInterface build() {
            return this.build(null);
        }

        public OkHttpUtilInterface build(Object requestTag) {
            if (this.isGlobalConfig && null == builderGlobal) {
                builderGlobal = this;
            }
            if (null != requestTag) {
                this.setRequestTag(requestTag);
            }
            return new OkHttpUtil(this);
        }

        private void initDefaultConfig() {
            this.setMaxCacheSize(0xA00000);
            if (null != application) {
                this.setCachedDir(application.getExternalCacheDir());
            } else {
                this.setCachedDir(Environment.getExternalStorageDirectory());
            }
            this.setConnectTimeout(30);
            this.setReadTimeout(30);
            this.setWriteTimeout(30);
            this.setRetryOnConnectionFailure(true);
            this.setCacheSurvivalTime(0);
            this.setCacheType(1);
            this.setNetworkInterceptors(null);
            this.setInterceptors(null);
            this.setResultInterceptors(null);
            this.setExceptionInterceptors(null);
            this.setShowHttpLog(true);
            this.setShowLifecycleLog(false);
            this.setDownloadFileDir(Environment.getExternalStorageDirectory().getPath() + "/okHttp_download/");
            this.setIsGzip(false);
        }

        private void initGlobalConfig(Builder builder) {
            this.setMaxCacheSize(builder.maxCacheSize);
            this.setCachedDir(builder.cachedDir);
            this.setConnectTimeout(builder.connectTimeout);
            this.setReadTimeout(builder.readTimeout);
            this.setWriteTimeout(builder.writeTimeout);
            this.setRetryOnConnectionFailure(builder.retryOnConnectionFailure);
            this.setCacheSurvivalTime(builder.cacheSurvivalTime);
            this.setCacheType(builder.cacheType);
            this.setNetworkInterceptors(builder.networkInterceptors);
            this.setInterceptors(builder.interceptors);
            this.setResultInterceptors(builder.resultInterceptors);
            this.setExceptionInterceptors(builder.exceptionInterceptors);
            this.setShowHttpLog(builder.showHttpLog);
            this.setHttpLogTAG(builder.httpLogTAG);
            this.setShowLifecycleLog(builder.showLifecycleLog);
            if (!TextUtils.isEmpty((CharSequence)builder.downloadFileDir)) {
                this.setDownloadFileDir(builder.downloadFileDir);
            }
            this.setCookieJar(builder.cookieJar);
            this.setResponseEncoding(builder.responseEncoding);
            this.setIsGzip(builder.isGzip);
        }

        private Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setCachedDir(File cachedDir) {
            if (null != cachedDir) {
                this.cachedDir = cachedDir;
            }
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("connectTimeout must be > 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(int writeTimeout) {
            if (writeTimeout <= 0) {
                throw new IllegalArgumentException("writeTimeout must be > 0");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder setNetworkInterceptors(List<Interceptor> networkInterceptors) {
            if (null != networkInterceptors) {
                this.networkInterceptors = networkInterceptors;
            }
            return this;
        }

        public Builder setInterceptors(List<Interceptor> interceptors) {
            if (null != interceptors) {
                this.interceptors = interceptors;
            }
            return this;
        }

        public Builder setResultInterceptors(List<ResultInterceptor> resultInterceptors) {
            if (null != resultInterceptors) {
                this.resultInterceptors = resultInterceptors;
            }
            return this;
        }

        public Builder addResultInterceptor(ResultInterceptor resultInterceptor) {
            if (null != resultInterceptor) {
                if (null == this.resultInterceptors) {
                    this.resultInterceptors = new ArrayList<ResultInterceptor>();
                }
                this.resultInterceptors.add(resultInterceptor);
            }
            return this;
        }

        public Builder setExceptionInterceptors(List<ExceptionInterceptor> exceptionInterceptors) {
            if (null != exceptionInterceptors) {
                this.exceptionInterceptors = exceptionInterceptors;
            }
            return this;
        }

        public Builder addExceptionInterceptor(ExceptionInterceptor exceptionInterceptor) {
            if (null != exceptionInterceptor) {
                if (null == this.exceptionInterceptors) {
                    this.exceptionInterceptors = new ArrayList<ExceptionInterceptor>();
                }
                this.exceptionInterceptors.add(exceptionInterceptor);
            }
            return this;
        }

        public Builder setCacheSurvivalTime(int cacheSurvivalTime) {
            if (cacheSurvivalTime < 0) {
                throw new IllegalArgumentException("cacheSurvivalTime must be >= 0");
            }
            this.cacheSurvivalTime = cacheSurvivalTime;
            return this;
        }

        public Builder setCacheType(int cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setShowHttpLog(boolean showHttpLog) {
            this.showHttpLog = showHttpLog;
            return this;
        }

        public Builder setHttpLogTAG(String logTAG) {
            this.httpLogTAG = logTAG;
            return this;
        }

        public Builder setShowLifecycleLog(boolean showLifecycleLog) {
            this.showLifecycleLog = showLifecycleLog;
            return this;
        }

        public Builder setRequestTag(Object requestTag) {
            this.requestTag = OkHttpUtil.parseRequestTag(requestTag);
            return this;
        }

        public Builder setDownloadFileDir(String downloadFileDir) {
            this.downloadFileDir = downloadFileDir;
            return this;
        }

        public Builder setCookieJar(CookieJar cookieJar) {
            if (null != cookieJar) {
                this.cookieJar = cookieJar;
            }
            return this;
        }

        public Builder setResponseEncoding(String responseEncoding) {
            this.responseEncoding = responseEncoding;
            return this;
        }

        public Builder setIsGzip(boolean isGzip) {
            this.isGzip = isGzip;
            return this;
        }
    }
}

