/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.bean.UploadMessage;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.BaseCallback;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.helper.BaseHelper;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.OkHttpHelper;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import com.okhttplib.progress.ProgressRequestBody;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class HttpHelper
extends BaseHelper {
    private List<ResultInterceptor> resultInterceptors;
    private List<ExceptionInterceptor> exceptionInterceptors;
    private long startTime;

    HttpHelper(HelperInfo helperInfo) {
        super(helperInfo);
        this.resultInterceptors = helperInfo.getResultInterceptors();
        this.exceptionInterceptors = helperInfo.getExceptionInterceptors();
    }

    /*
     * Exception decompiling
     */
    HttpInfo doRequestSync(OkHttpHelper helper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void doRequestAsync(final OkHttpHelper helper) {
        final HttpInfo info = this.httpInfo;
        final BaseCallback callback = helper.getCallback();
        Request request = helper.getRequest();
        String url = info.getUrl();
        if (!this.checkUrl(url)) {
            Message msg = new CallbackMessage(1, callback, this.retInfo(info, 5), this.requestTag, null).build();
            OkMainHandler.getInstance().sendMessage(msg);
            return;
        }
        request = request == null ? this.buildRequest(info, helper.getRequestMethod(), helper.getProgressCallback()) : request;
        this.showUrlLog(request);
        Call call = this.httpClient.newCall(request);
        BaseActivityLifecycleCallbacks.putCall(this.requestTag, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                int code = 6;
                if (e instanceof UnknownHostException) {
                    code = !HttpHelper.this.helperInfo.getOkHttpUtil().isNetworkAvailable() ? 6 : 5;
                } else if (e instanceof SocketTimeoutException && null != e.getMessage()) {
                    if (e.getMessage().contains("failed to connect to")) {
                        code = 7;
                    }
                    if (e.getMessage().equals("timeout")) {
                        code = 8;
                    }
                }
                Message msg = new CallbackMessage(1, callback, HttpHelper.this.retInfo(info, code, "[" + e.getMessage() + "]"), HttpHelper.this.requestTag, call).build();
                OkMainHandler.getInstance().sendMessage(msg);
            }

            public void onResponse(Call call, Response res) throws IOException {
                Message msg = new CallbackMessage(1, callback, HttpHelper.this.dealResponse(helper, res, call), HttpHelper.this.requestTag, call).build();
                OkMainHandler.getInstance().sendMessage(msg);
            }
        });
    }

    private boolean checkUrl(String url) {
        HttpUrl parsed = HttpUrl.parse((String)url);
        return parsed != null && !TextUtils.isEmpty((CharSequence)url);
    }

    private Request buildRequest(HttpInfo info, int method, ProgressCallback progressCallback) {
        Request.Builder requestBuilder = new Request.Builder();
        String url = info.getUrl();
        if (method == 1) {
            if (info.getParamBytes() != null) {
                RequestBody byteBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])info.getParamBytes());
                requestBuilder.url(url).post((RequestBody)new ProgressRequestBody(byteBody, progressCallback, this.timeStamp, this.requestTag));
            } else if (info.getParamFile() != null) {
                RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"text/x-markdown; charset=utf-8"), (File)info.getParamFile());
                requestBuilder.url(url).post((RequestBody)new ProgressRequestBody(fileBody, progressCallback, this.timeStamp, this.requestTag));
            } else if (info.getParamJson() != null) {
                RequestBody jsonBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)info.getParamJson());
                requestBuilder.url(url).post((RequestBody)new ProgressRequestBody(jsonBody, progressCallback, this.timeStamp, this.requestTag));
            } else {
                requestBuilder.url(url).post((RequestBody)this.packageFormBody(info, url, requestBuilder).build());
            }
        } else if (method == 2) {
            StringBuilder params = new StringBuilder();
            params.append(url);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                if (!url.contains("?") && !url.endsWith("?")) {
                    params.append("?");
                }
                boolean isFirst = params.toString().endsWith("?");
                for (String name : info.getParams().keySet()) {
                    String logInfo;
                    String value = info.getParams().get(name);
                    String string = value = value == null ? "" : value;
                    if (isFirst) {
                        logInfo = name + "=" + value;
                        isFirst = false;
                    } else {
                        logInfo = "&" + name + "=" + value;
                    }
                    params.append(logInfo);
                }
            }
            requestBuilder.url(params.toString()).get();
        } else if (method == 3) {
            requestBuilder.url(url).put((RequestBody)this.packageFormBody(info, url, requestBuilder).build());
        } else if (method == 4) {
            requestBuilder.url(url).delete((RequestBody)this.packageFormBody(info, url, requestBuilder).build());
        } else {
            requestBuilder.url(url).get();
        }
        if (Build.VERSION.SDK_INT > 13) {
            requestBuilder.addHeader("Connection", "close");
        }
        this.addHeadsToRequest(info, requestBuilder);
        Request request = requestBuilder.build();
        return request;
    }

    private FormBody.Builder packageFormBody(HttpInfo info, String url, Request.Builder requestBuilder) {
        FormBody.Builder builder = new FormBody.Builder();
        if (null != info.getParams() && !info.getParams().isEmpty()) {
            StringBuilder log = new StringBuilder("PostParams: ");
            for (String key : info.getParams().keySet()) {
                String value = info.getParams().get(key);
                value = value == null ? "" : value;
                builder.add(key, value);
                String logInfo = key + "=" + value + ", ";
                log.append(logInfo);
            }
            this.showLog(log.toString());
        }
        return builder;
    }

    private void showUrlLog(Request request) {
        this.startTime = System.nanoTime();
        this.showLog(String.format("%s-URL: %s %n", request.method(), request.url()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpInfo dealResponse(OkHttpHelper helper, Response res, Call call) {
        this.showLog(String.format(Locale.getDefault(), "CostTime: %.3fs", (double)(System.nanoTime() - this.startTime) / 1.0E9));
        HttpInfo info = this.httpInfo;
        BufferedReader bufferedReader = null;
        String result = "";
        try {
            if (null != res) {
                int netCode = res.code();
                if (res.isSuccessful()) {
                    if (helper.getBusinessType() == 1 || helper.getBusinessType() == 2) {
                        String encoding = info.getResponseEncoding();
                        if (TextUtils.isEmpty((CharSequence)encoding)) {
                            encoding = helper.getResponseEncoding();
                        }
                        bufferedReader = new BufferedReader(new InputStreamReader(res.body().byteStream(), encoding));
                        String line = "";
                        while ((line = bufferedReader.readLine()) != null) {
                            result = result + line;
                        }
                        HttpInfo httpInfo = this.retInfo(info, netCode, 1, result);
                        return httpInfo;
                    }
                    if (helper.getBusinessType() == 3) {
                        HttpInfo encoding = helper.getDownUpLoadHelper().downloadingFile(helper, res, call);
                        return encoding;
                    }
                } else {
                    this.showLog("HttpStatus: " + netCode);
                    if (netCode == 400) {
                        HttpInfo encoding = this.retInfo(info, netCode, 15);
                        return encoding;
                    }
                    if (netCode == 404) {
                        HttpInfo encoding = this.retInfo(info, netCode, 14);
                        return encoding;
                    }
                    if (netCode == 416) {
                        HttpInfo encoding = this.retInfo(info, netCode, 11, "\u8bf7\u6c42Http\u6570\u636e\u6d41\u8303\u56f4\u9519\u8bef\n" + result);
                        return encoding;
                    }
                    if (netCode == 500) {
                        HttpInfo encoding = this.retInfo(info, netCode, 4);
                        return encoding;
                    }
                    if (netCode == 502) {
                        HttpInfo encoding = this.retInfo(info, netCode, 13);
                        return encoding;
                    }
                    if (netCode == 504) {
                        HttpInfo encoding = this.retInfo(info, netCode, 12);
                        return encoding;
                    }
                    HttpInfo encoding = this.retInfo(info, netCode, 6);
                    return encoding;
                }
            }
            HttpInfo netCode = this.retInfo(info, 5);
            return netCode;
        }
        catch (Exception e) {
            HttpInfo httpInfo = this.retInfo(info, 4, "[" + e.getMessage() + "]");
            return httpInfo;
        }
        finally {
            if (null != res) {
                res.close();
            }
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    HttpInfo retInfo(HttpInfo info, int code) {
        return this.retInfo(info, code, code, null);
    }

    HttpInfo retInfo(HttpInfo info, int netCode, int code) {
        return this.retInfo(info, netCode, code, null);
    }

    HttpInfo retInfo(HttpInfo info, int code, String resDetail) {
        return this.retInfo(info, code, code, resDetail);
    }

    HttpInfo retInfo(HttpInfo info, int netCode, int code, String resDetail) {
        info.packInfo(netCode, code, this.unicodeToString(resDetail));
        this.dealInterceptor(info);
        this.showLog("Response: " + info.getRetDetail());
        return info;
    }

    private String unicodeToString(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    private void dealInterceptor(HttpInfo info) {
        try {
            if (info.isSuccessful() && null != this.resultInterceptors) {
                for (ResultInterceptor interceptor : this.resultInterceptors) {
                    interceptor.intercept(info);
                }
            } else if (null != this.exceptionInterceptors) {
                for (ExceptionInterceptor interceptor : this.exceptionInterceptors) {
                    interceptor.intercept(info);
                }
            }
        }
        catch (Exception e) {
            this.showLog("\u62e6\u622a\u5668\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    void responseCallback(HttpInfo info, ProgressCallback progressCallback, int code, String requestTag) {
        if (null != progressCallback) {
            progressCallback.onResponseSync(info.getUrl(), info);
        }
        if (4 == code) {
            Message msg = new DownloadMessage(code, info.getUrl(), info, progressCallback, requestTag).build();
            OkMainHandler.getInstance().sendMessage(msg);
        } else if (3 == code) {
            Message msg = new UploadMessage(code, info.getUrl(), info, progressCallback, requestTag).build();
            OkMainHandler.getInstance().sendMessage(msg);
        }
    }

    Request.Builder addHeadsToRequest(HttpInfo info, Request.Builder requestBuilder) {
        if (null != info.getHeads() && !info.getHeads().isEmpty()) {
            for (String key : info.getHeads().keySet()) {
                requestBuilder.addHeader(key, info.getHeads().get(key));
            }
        }
        return requestBuilder;
    }
}

