/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.text.TextUtils;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.ProgressCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpInfo {
    private String url;
    private Map<String, String> params;
    private List<UploadFileInfo> uploadFiles;
    private List<DownloadFileInfo> downloadFiles;
    private Map<String, String> heads;
    private int retCode;
    private String retDetail;
    private int netCode;
    public static final int SUCCESS = 1;
    public static final int NonNetwork = 2;
    public static final int ProtocolException = 3;
    public static final int NoResult = 4;
    public static final int CheckURL = 5;
    public static final int CheckNet = 6;
    public static final int ConnectionTimeOut = 7;
    public static final int WriteAndReadTimeOut = 8;
    public static final int ConnectionInterruption = 9;
    public static final int NetworkOnMainThreadException = 10;
    public static final int Message = 11;

    public HttpInfo(Builder builder) {
        this.url = builder.url;
        this.params = builder.params;
        this.uploadFiles = builder.uploadFiles;
        this.downloadFiles = builder.downloadFiles;
        this.heads = builder.heads;
    }

    public static Builder Builder() {
        return new Builder();
    }

    public HttpInfo packInfo(int netCode, int retCode, String retDetail) {
        this.netCode = netCode;
        this.retCode = retCode;
        switch (retCode) {
            case 2: {
                this.retDetail = "\u7f51\u7edc\u4e2d\u65ad";
                break;
            }
            case 1: {
                this.retDetail = "\u53d1\u9001\u8bf7\u6c42\u6210\u529f";
                break;
            }
            case 3: {
                this.retDetail = "\u8bf7\u68c0\u67e5\u534f\u8bae\u7c7b\u578b\u662f\u5426\u6b63\u786e";
                break;
            }
            case 4: {
                this.retDetail = "\u65e0\u6cd5\u83b7\u53d6\u8fd4\u56de\u4fe1\u606f(\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef)";
                break;
            }
            case 5: {
                this.retDetail = "\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e";
                break;
            }
            case 6: {
                this.retDetail = "\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38";
                break;
            }
            case 7: {
                this.retDetail = "\u8fde\u63a5\u8d85\u65f6";
                break;
            }
            case 8: {
                this.retDetail = "\u8bfb\u5199\u8d85\u65f6";
                break;
            }
            case 9: {
                this.retDetail = "\u8fde\u63a5\u4e2d\u65ad";
                break;
            }
            case 10: {
                this.retDetail = "\u4e0d\u5141\u8bb8\u5728UI\u7ebf\u7a0b\u4e2d\u8fdb\u884c\u7f51\u7edc\u64cd\u4f5c";
                break;
            }
            case 11: {
                this.retDetail = "";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)retDetail)) {
            this.retDetail = retDetail;
        }
        return this;
    }

    public int getRetCode() {
        return this.retCode;
    }

    public boolean isSuccessful() {
        return this.retCode == 1;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRetDetail() {
        return this.retDetail;
    }

    public void setRetDetail(String retDetail) {
        this.retDetail = retDetail;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public List<UploadFileInfo> getUploadFiles() {
        return this.uploadFiles;
    }

    public List<DownloadFileInfo> getDownloadFiles() {
        return this.downloadFiles;
    }

    public Map<String, String> getHeads() {
        return this.heads;
    }

    public int getNetCode() {
        return this.netCode;
    }

    public static final class Builder {
        private String url;
        private Map<String, String> params;
        private List<UploadFileInfo> uploadFiles;
        private List<DownloadFileInfo> downloadFiles;
        private Map<String, String> heads;

        public HttpInfo build() {
            return new HttpInfo(this);
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder addParams(Map<String, String> params) {
            if (null == params) {
                return this;
            }
            if (null == this.params) {
                this.params = params;
            } else {
                this.params.putAll(params);
            }
            return this;
        }

        public Builder addParam(String key, String value) {
            if (null == this.params) {
                this.params = new HashMap<String, String>();
            }
            if (!TextUtils.isEmpty((CharSequence)key)) {
                value = value == null ? "" : value;
                this.params.put(key, value);
            }
            return this;
        }

        public Builder addHeads(Map<String, String> heads) {
            if (null == heads) {
                return this;
            }
            if (null == this.heads) {
                this.heads = heads;
            } else {
                this.heads.putAll(heads);
            }
            return this;
        }

        public Builder addHead(String key, String value) {
            if (null == this.heads) {
                this.heads = new HashMap<String, String>();
            }
            if (!TextUtils.isEmpty((CharSequence)key)) {
                value = value == null ? "" : value;
                this.heads.put(key, value);
            }
            return this;
        }

        public Builder addUploadFile(String interfaceParamName, String filePathWithName) {
            this.addUploadFile(interfaceParamName, filePathWithName, null);
            return this;
        }

        public Builder addUploadFile(String interfaceParamName, String filePathWithName, ProgressCallback progressCallback) {
            if (null == this.uploadFiles) {
                this.uploadFiles = new ArrayList<UploadFileInfo>();
            }
            if (!TextUtils.isEmpty((CharSequence)filePathWithName)) {
                this.uploadFiles.add(new UploadFileInfo(filePathWithName, interfaceParamName, progressCallback));
            }
            return this;
        }

        public Builder addUploadFile(String url, String interfaceParamName, String filePathWithName, ProgressCallback progressCallback) {
            if (null == this.uploadFiles) {
                this.uploadFiles = new ArrayList<UploadFileInfo>();
            }
            if (!TextUtils.isEmpty((CharSequence)filePathWithName)) {
                this.uploadFiles.add(new UploadFileInfo(url, filePathWithName, interfaceParamName, progressCallback));
            }
            return this;
        }

        public Builder addUploadFiles(List<UploadFileInfo> uploadFiles) {
            if (null == uploadFiles) {
                return this;
            }
            if (null == this.uploadFiles) {
                this.uploadFiles = uploadFiles;
            } else {
                this.uploadFiles.addAll(uploadFiles);
            }
            return this;
        }

        public Builder addDownloadFile(String url, String saveFileName) {
            this.addDownloadFile(url, null, saveFileName, null);
            return this;
        }

        public Builder addDownloadFile(String url, String saveFileName, ProgressCallback progressCallback) {
            this.addDownloadFile(url, null, saveFileName, progressCallback);
            return this;
        }

        public Builder addDownloadFile(String url, String saveFileDir, String saveFileName, ProgressCallback progressCallback) {
            if (null == this.downloadFiles) {
                this.downloadFiles = new ArrayList<DownloadFileInfo>();
            }
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.downloadFiles.add(new DownloadFileInfo(url, saveFileDir, saveFileName, progressCallback));
            }
            return this;
        }

        public Builder addDownloadFile(DownloadFileInfo downloadFile) {
            if (null == downloadFile) {
                return this;
            }
            if (null == this.downloadFiles) {
                this.downloadFiles = new ArrayList<DownloadFileInfo>();
            }
            this.downloadFiles.add(downloadFile);
            return this;
        }

        public Builder addDownloadFiles(List<DownloadFileInfo> downloadFiles) {
            if (null == downloadFiles) {
                return this;
            }
            if (null == this.downloadFiles) {
                this.downloadFiles = downloadFiles;
            } else {
                this.downloadFiles.addAll(downloadFiles);
            }
            return this;
        }
    }
}

