/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.helper.BaseHelper;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.OkHttpHelper;
import com.okhttplib.progress.ProgressRequestBody;
import com.okhttplib.progress.ProgressResponseBody;
import com.okhttplib.util.EncryptUtil;
import com.okhttplib.util.MediaTypeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

class DownUpLoadHelper
extends BaseHelper {
    private String downloadFileDir;
    private static Map<String, String> downloadTaskMap;

    DownUpLoadHelper(HelperInfo helperInfo) {
        super(helperInfo);
        this.downloadFileDir = helperInfo.getDownloadFileDir();
    }

    void uploadFile(OkHttpHelper helper) {
        try {
            HttpInfo info = helper.getHttpInfo();
            UploadFileInfo fileInfo = helper.getUploadFileInfo();
            String filePath = fileInfo.getFilePathWithName();
            String interfaceParamName = fileInfo.getInterfaceParamName();
            String url = fileInfo.getUrl();
            String string = url = TextUtils.isEmpty((CharSequence)url) ? info.getUrl() : url;
            if (TextUtils.isEmpty((CharSequence)url)) {
                this.showLog("\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a[" + filePath + "]");
                return;
            }
            ProgressCallback progressCallback = fileInfo.getProgressCallback();
            File file = new File(filePath);
            MultipartBody.Builder mBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            StringBuilder log = new StringBuilder("PostParams: ");
            log.append(interfaceParamName);
            log.append("=");
            log.append(filePath);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                for (String key : info.getParams().keySet()) {
                    mBuilder.addFormDataPart(key, info.getParams().get(key));
                    String logInfo = key + " =" + info.getParams().get(key) + ", ";
                    log.append(logInfo);
                }
            }
            this.showLog(log.toString());
            mBuilder.addFormDataPart(interfaceParamName, file.getName(), RequestBody.create((MediaType)MediaTypeUtil.fetchFileMediaType(filePath), (File)file));
            MultipartBody requestBody = mBuilder.build();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url).post((RequestBody)new ProgressRequestBody((RequestBody)requestBody, progressCallback));
            helper.getHttpHelper().addHeadsToRequest(info, requestBuilder);
            Request request = requestBuilder.build();
            helper.setRequest(request);
            helper.doRequestSync();
            helper.getHttpHelper().responseCallback(info, progressCallback, 3, false);
        }
        catch (Exception e) {
            this.showLog("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    void downloadFile(final OkHttpHelper helper) {
        try {
            HttpInfo httpInfo = helper.getHttpInfo();
            final DownloadFileInfo fileInfo = helper.getDownloadFileInfo();
            String url = fileInfo.getUrl();
            if (TextUtils.isEmpty((CharSequence)url)) {
                this.showLog("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return;
            }
            httpInfo.setUrl(url);
            ProgressCallback progressCallback = fileInfo.getProgressCallback();
            long completedSize = this.fetchCompletedSize(fileInfo);
            fileInfo.setCompletedSize(completedSize);
            if (null == downloadTaskMap) {
                downloadTaskMap = new ConcurrentHashMap<String, String>();
            }
            if (downloadTaskMap.containsKey(fileInfo.getSaveFileNameEncrypt())) {
                this.showLog(fileInfo.getSaveFileName() + " \u5df2\u5728\u4e0b\u8f7d\u4efb\u52a1\u4e2d");
                return;
            }
            downloadTaskMap.put(fileInfo.getSaveFileNameEncrypt(), fileInfo.getSaveFileNameEncrypt());
            Interceptor interceptor = new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), fileInfo, helper.getHttpHelper().timeStamp)).build();
                }
            };
            OkHttpClient httpClient = helper.getClientBuilder().addInterceptor(interceptor).build();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url).header("RANGE", "bytes=" + completedSize + "-");
            helper.getHttpHelper().addHeadsToRequest(httpInfo, requestBuilder);
            Request request = requestBuilder.build();
            helper.setRequest(request);
            helper.setHttpClient(httpClient);
            helper.doRequestSync();
            if (null != downloadTaskMap) {
                downloadTaskMap.remove(fileInfo.getSaveFileNameEncrypt());
            }
            helper.getHttpHelper().responseCallback(httpInfo, progressCallback, 4, true);
        }
        catch (Exception e) {
            this.showLog("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpInfo downloadingFile(OkHttpHelper okHttpInfo, Response res, Call call) {
        HttpInfo info = okHttpInfo.getHttpInfo();
        DownloadFileInfo fileInfo = okHttpInfo.getDownloadFileInfo();
        RandomAccessFile accessFile = null;
        InputStream inputStream = null;
        BufferedInputStream bis = null;
        String filePath = fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameWithExtension();
        try {
            int length;
            ResponseBody responseBody = res.body();
            long completedSize = fileInfo.getCompletedSize();
            accessFile = new RandomAccessFile(fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameEncrypt(), "rwd");
            if (TextUtils.isEmpty((CharSequence)res.header("Content-Range"))) {
                completedSize = 0L;
                fileInfo.setCompletedSize(completedSize);
            }
            accessFile.seek(completedSize);
            inputStream = responseBody.byteStream();
            byte[] buffer = new byte[2048];
            bis = new BufferedInputStream(inputStream);
            fileInfo.setDownloadStatus("DOWNLOADING");
            while ((length = bis.read(buffer)) > 0 && "DOWNLOADING".equals(fileInfo.getDownloadStatus())) {
                accessFile.write(buffer, 0, length);
                completedSize += (long)length;
            }
            if ("PAUSE".equals(fileInfo.getDownloadStatus())) {
                HttpInfo httpInfo = okHttpInfo.getHttpHelper().retInfo(info, 11, "\u6682\u505c\u4e0b\u8f7d");
                return httpInfo;
            }
            if ("DOWNLOADING".equals(fileInfo.getDownloadStatus())) {
                File oldFile;
                fileInfo.setDownloadStatus("COMPLETED");
                File newFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameWithExtension());
                if (newFile.exists() && newFile.isFile()) {
                    filePath = fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameCopy();
                    newFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameCopy());
                }
                if ((oldFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameEncrypt())).exists() && oldFile.isFile()) {
                    boolean rename = oldFile.renameTo(newFile);
                    this.showLog("\u91cd\u547d\u540d[" + rename + "]:" + newFile.getAbsolutePath());
                }
                HttpInfo httpInfo = okHttpInfo.getHttpHelper().retInfo(info, 1, filePath);
                return httpInfo;
            }
        }
        catch (SocketTimeoutException e) {
            HttpInfo httpInfo = okHttpInfo.getHttpHelper().retInfo(info, 8);
            return httpInfo;
        }
        catch (Exception e) {
            this.showLog("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
            HttpInfo httpInfo = okHttpInfo.getHttpHelper().retInfo(info, 9);
            return httpInfo;
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != accessFile) {
                    accessFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BaseActivityLifecycleCallbacks.cancel(this.requestTag, call);
            if (null != downloadTaskMap) {
                downloadTaskMap.remove(fileInfo.getSaveFileNameEncrypt());
            }
        }
        return okHttpInfo.getHttpHelper().retInfo(info, 1, filePath);
    }

    private long fetchCompletedSize(DownloadFileInfo fileInfo) {
        String saveFileDir = fileInfo.getSaveFileDir();
        String saveFileName = fileInfo.getSaveFileName();
        String url = fileInfo.getUrl();
        String extension = url.substring(url.lastIndexOf(".") + 1);
        String saveFileNameCopy = saveFileName + "[" + this.timeStamp + "]" + "." + extension;
        saveFileName = saveFileName + "." + extension;
        saveFileDir = TextUtils.isEmpty((CharSequence)saveFileDir) ? this.downloadFileDir : saveFileDir;
        this.mkDirNotExists(saveFileDir);
        fileInfo.setSaveFileDir(saveFileDir);
        fileInfo.setSaveFileNameCopy(saveFileNameCopy);
        fileInfo.setSaveFileNameWithExtension(saveFileName);
        String saveFileNameEncrypt = url;
        try {
            saveFileNameEncrypt = EncryptUtil.MD5StringTo32Bit(url, true);
            fileInfo.setSaveFileNameEncrypt(saveFileNameEncrypt);
        }
        catch (Exception e) {
            this.showLog("\u65ad\u70b9\u6587\u4ef6\u4e0b\u8f7d: \u6587\u4ef6\u540dMD5\u52a0\u5bc6\u5931\u8d25 " + e.getMessage());
        }
        File file = new File(saveFileDir, saveFileNameEncrypt);
        if (file.exists() && file.isFile()) {
            long size = file.length();
            this.showLog("\u65ad\u70b9\u6587\u4ef6\u4e0b\u8f7d\uff0c\u8282\u70b9[" + size + "]");
            return size;
        }
        return 0L;
    }

    private boolean mkDirNotExists(String dir) {
        File file = new File(dir);
        return file.exists() || file.mkdirs();
    }
}

