/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import com.okhttplib.HttpInfo;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.CallbackOk;
import com.okhttplib.helper.DownUpLoadHelper;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.HttpHelper;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class OkHttpHelper {
    private HttpInfo httpInfo;
    private HttpHelper httpHelper;
    private DownUpLoadHelper downUpLoadHelper;
    private DownloadFileInfo downloadFileInfo;
    private UploadFileInfo uploadFileInfo;
    private OkHttpClient.Builder clientBuilder;
    private int requestMethod;
    private CallbackOk callback;
    private Request request;
    private OkHttpClient httpClient;

    private OkHttpHelper(Builder builder) {
        this.httpInfo = builder.httpInfo;
        this.downloadFileInfo = builder.downloadFileInfo;
        this.uploadFileInfo = builder.uploadFileInfo;
        this.clientBuilder = builder.clientBuilder;
        this.requestMethod = builder.requestMethod;
        this.callback = builder.callback;
        this.httpHelper = new HttpHelper(builder.helperInfo);
        if (null != this.downloadFileInfo || null != this.uploadFileInfo) {
            this.downUpLoadHelper = new DownUpLoadHelper(builder.helperInfo);
        }
    }

    public HttpInfo doRequestSync() {
        return this.httpHelper.doRequestSync(this);
    }

    public void doRequestAsync() {
        this.httpHelper.doRequestAsync(this);
    }

    public void downloadFile() {
        this.downUpLoadHelper.downloadFile(this);
    }

    public void uploadFile() {
        this.downUpLoadHelper.uploadFile(this);
    }

    public static Builder Builder() {
        return new Builder();
    }

    HttpInfo getHttpInfo() {
        return this.httpInfo;
    }

    HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    DownUpLoadHelper getDownUpLoadHelper() {
        return this.downUpLoadHelper;
    }

    DownloadFileInfo getDownloadFileInfo() {
        return this.downloadFileInfo;
    }

    UploadFileInfo getUploadFileInfo() {
        return this.uploadFileInfo;
    }

    OkHttpClient.Builder getClientBuilder() {
        return this.clientBuilder;
    }

    int getRequestMethod() {
        return this.requestMethod;
    }

    CallbackOk getCallback() {
        return this.callback;
    }

    Request getRequest() {
        return this.request;
    }

    void setRequest(Request request) {
        this.request = request;
    }

    OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static final class Builder {
        private HttpInfo httpInfo;
        private HelperInfo helperInfo;
        private DownloadFileInfo downloadFileInfo;
        private UploadFileInfo uploadFileInfo;
        private OkHttpClient.Builder clientBuilder;
        private int requestMethod;
        private CallbackOk callback;

        public OkHttpHelper build() {
            return new OkHttpHelper(this);
        }

        public Builder httpInfo(HttpInfo httpInfo) {
            this.httpInfo = httpInfo;
            return this;
        }

        public Builder helperInfo(HelperInfo helperInfo) {
            this.helperInfo = helperInfo;
            return this;
        }

        public Builder downloadFileInfo(DownloadFileInfo downloadFileInfo) {
            this.downloadFileInfo = downloadFileInfo;
            return this;
        }

        public Builder uploadFileInfo(UploadFileInfo uploadFileInfo) {
            this.uploadFileInfo = uploadFileInfo;
            return this;
        }

        public Builder clientBuilder(OkHttpClient.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
            return this;
        }

        public Builder requestMethod(int requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder callbackOk(CallbackOk callback) {
            this.callback = callback;
            return this;
        }
    }
}

