/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.os.Build;
import android.os.Message;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.CallbackOk;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.helper.BaseHelper;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.OkHttpHelper;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import java.io.IOException;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class HttpHelper
extends BaseHelper {
    private Class<?> requestTag;
    private List<ResultInterceptor> resultInterceptors;
    private List<ExceptionInterceptor> exceptionInterceptors;

    HttpHelper(HelperInfo helperInfo) {
        super(helperInfo);
        this.requestTag = helperInfo.getRequestTag();
        this.resultInterceptors = helperInfo.getResultInterceptors();
        this.exceptionInterceptors = helperInfo.getExceptionInterceptors();
    }

    /*
     * Exception decompiling
     */
    HttpInfo doRequestSync(OkHttpHelper helper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void doRequestAsync(final OkHttpHelper helper) {
        final HttpInfo info = helper.getHttpInfo();
        final CallbackOk callback = helper.getCallback();
        Request request = helper.getRequest();
        if (null == callback) {
            throw new NullPointerException("CallbackOk is null!");
        }
        Call call = this.httpClient.newCall(request == null ? this.buildRequest(info, helper.getRequestMethod()) : request);
        BaseActivityLifecycleCallbacks.putCall(this.requestTag, info, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HttpHelper.this.showLog(e.getMessage());
            }

            public void onResponse(Call call, Response res) throws IOException {
                Message msg = new CallbackMessage(1, callback, HttpHelper.this.dealResponse(helper, res, call)).build();
                OkMainHandler.getInstance().sendMessage(msg);
                BaseActivityLifecycleCallbacks.cancelCall(HttpHelper.this.requestTag, info, call);
            }
        });
    }

    private Request buildRequest(HttpInfo info, int method) {
        Request.Builder requestBuilder = new Request.Builder();
        String url = info.getUrl();
        if (method == 1) {
            FormBody.Builder builder = new FormBody.Builder();
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                StringBuilder log = new StringBuilder("PostParams: ");
                for (String key : info.getParams().keySet()) {
                    String value = info.getParams().get(key);
                    value = value == null ? "" : value;
                    builder.add(key, value);
                    String logInfo = key + "=" + value + ", ";
                    log.append(logInfo);
                }
                this.showLog(log.toString());
            }
            requestBuilder.url(url).post((RequestBody)builder.build());
        } else if (method == 2) {
            StringBuilder params = new StringBuilder();
            params.append(url);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                if (!url.contains("?") && !url.endsWith("?")) {
                    params.append("?");
                }
                boolean isFirst = params.toString().endsWith("?");
                for (String name : info.getParams().keySet()) {
                    String logInfo;
                    String value = info.getParams().get(name);
                    String string = value = value == null ? "" : value;
                    if (isFirst) {
                        logInfo = name + "=" + value;
                        isFirst = false;
                    } else {
                        logInfo = "&" + name + "=" + value;
                    }
                    params.append(logInfo);
                }
            }
            requestBuilder.url(params.toString()).get();
        } else {
            requestBuilder.url(url).get();
        }
        if (Build.VERSION.SDK_INT > 13) {
            requestBuilder.addHeader("Connection", "close");
        }
        this.addHeadsToRequest(info, requestBuilder);
        Request request = requestBuilder.build();
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpInfo dealResponse(OkHttpHelper helper, Response res, Call call) {
        HttpInfo info = helper.getHttpInfo();
        try {
            if (null != res) {
                if (res.isSuccessful() && null != res.body()) {
                    if (null == helper.getDownloadFileInfo()) {
                        HttpInfo httpInfo = this.retInfo(info, 1, res.body().string());
                        return httpInfo;
                    }
                    HttpInfo httpInfo = helper.getDownUpLoadHelper().downloadingFile(helper, res, call);
                    return httpInfo;
                }
                this.showLog("HttpStatus: " + res.code());
                if (res.code() == 404) {
                    HttpInfo httpInfo = this.retInfo(info, 5);
                    return httpInfo;
                }
                if (res.code() == 416) {
                    HttpInfo httpInfo = this.retInfo(info, 11, "\u8bf7\u6c42Http\u6570\u636e\u6d41\u8303\u56f4\u9519\u8bef\n" + res.body().string());
                    return httpInfo;
                }
                if (res.code() == 500) {
                    HttpInfo httpInfo = this.retInfo(info, 4);
                    return httpInfo;
                }
                if (res.code() == 502) {
                    HttpInfo httpInfo = this.retInfo(info, 6);
                    return httpInfo;
                }
                if (res.code() == 504) {
                    HttpInfo httpInfo = this.retInfo(info, 6);
                    return httpInfo;
                }
            }
            HttpInfo httpInfo = this.retInfo(info, 5);
            return httpInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpInfo httpInfo = this.retInfo(info, 4);
            return httpInfo;
        }
        finally {
            if (null != res) {
                res.close();
            }
        }
    }

    HttpInfo retInfo(HttpInfo info, int code) {
        this.retInfo(info, code, null);
        return info;
    }

    HttpInfo retInfo(HttpInfo info, int code, String resDetail) {
        info.packInfo(code, resDetail);
        this.dealInterceptor(info);
        this.showLog("Response: " + info.getRetDetail());
        return info;
    }

    private void dealInterceptor(HttpInfo info) {
        try {
            if (info.isSuccessful() && null != this.resultInterceptors) {
                for (ResultInterceptor interceptor : this.resultInterceptors) {
                    interceptor.intercept(info);
                }
            } else if (null != this.exceptionInterceptors) {
                for (ExceptionInterceptor interceptor : this.exceptionInterceptors) {
                    interceptor.intercept(info);
                }
            }
        }
        catch (Exception e) {
            this.showLog("\u62e6\u622a\u5668\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    void responseCallback(HttpInfo info, ProgressCallback progressCallback, int code) {
        if (null != progressCallback) {
            progressCallback.onResponseSync(info.getUrl(), info);
        }
        Message msg = new DownloadMessage(code, info.getUrl(), info, progressCallback).build();
        OkMainHandler.getInstance().sendMessage(msg);
    }

    Request.Builder addHeadsToRequest(HttpInfo info, Request.Builder requestBuilder) {
        if (null != info.getHeads() && !info.getHeads().isEmpty()) {
            for (String key : info.getHeads().keySet()) {
                requestBuilder.addHeader(key, info.getHeads().get(key));
            }
        }
        return requestBuilder;
    }
}

