/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.util.Log;
import com.okhttplib.helper.HelperInfo;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

abstract class BaseHelper {
    OkHttpClient httpClient;
    private String TAG;
    private long timeStamp;
    private boolean showHttpLog;
    private Interceptor LOG_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            long startTime = System.currentTimeMillis();
            BaseHelper.this.showLog(String.format("%s-URL: %s %n", chain.request().method(), chain.request().url()));
            Response res = chain.proceed(chain.request());
            long endTime = System.currentTimeMillis();
            BaseHelper.this.showLog(String.format("CostTime: %.1fs", Float.valueOf((float)(endTime - startTime) / 1000.0f)));
            return res;
        }
    };
    private final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    BaseHelper(HelperInfo helperInfo) {
        OkHttpClient.Builder clientBuilder = helperInfo.getClientBuilder();
        clientBuilder.addInterceptor(this.LOG_INTERCEPTOR);
        this.setSslSocketFactory(clientBuilder);
        this.httpClient = clientBuilder.build();
        this.TAG = helperInfo.getLogTAG();
        this.timeStamp = helperInfo.getTimeStamp();
        this.showHttpLog = helperInfo.isShowHttpLog();
    }

    private void setSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        clientBuilder.hostnameVerifier(this.DO_NOT_VERIFY);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            clientBuilder.sslSocketFactory(sc.getSocketFactory(), trustManager);
        }
        catch (Exception e) {
            this.showLog("Https\u8ba4\u8bc1\u5f02\u5e38: " + e.getMessage());
        }
    }

    void showLog(String msg) {
        if (this.showHttpLog) {
            Log.d((String)(this.TAG + "[" + this.timeStamp + "]"), (String)msg);
        }
    }
}

