/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.os.Build;
import android.os.Message;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.bean.HelperInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.CallbackOk;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.helper.DownUpLoadHelper;
import com.okhttplib.helper.LogHelper;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import java.io.IOException;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpHelper {
    private static OkHttpClient httpClient;
    private static Class<?> requestTag;
    private static List<ResultInterceptor> resultInterceptors;
    private static List<ExceptionInterceptor> exceptionInterceptors;

    private HttpHelper() {
    }

    public static void init(HelperInfo helperInfo) {
        httpClient = helperInfo.getHttpClient();
        requestTag = helperInfo.getRequestTag();
        resultInterceptors = helperInfo.getResultInterceptors();
        exceptionInterceptors = helperInfo.getExceptionInterceptors();
    }

    private static Request buildRequest(HttpInfo info, int method) {
        Request.Builder requestBuilder = new Request.Builder();
        String url = info.getUrl();
        if (method == 1) {
            FormBody.Builder builder = new FormBody.Builder();
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                StringBuilder log = new StringBuilder("PostParams: ");
                for (String key : info.getParams().keySet()) {
                    String value = info.getParams().get(key);
                    value = value == null ? "" : value;
                    builder.add(key, value);
                    String logInfo = key + "=" + value + ", ";
                    log.append(logInfo);
                }
                LogHelper.get().showLog(log.toString());
            }
            requestBuilder.url(url).post((RequestBody)builder.build());
        } else if (method == 2) {
            StringBuilder params = new StringBuilder();
            params.append(url);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                if (!url.contains("?") && !url.endsWith("?")) {
                    params.append("?");
                }
                boolean isFirst = params.toString().endsWith("?");
                for (String name : info.getParams().keySet()) {
                    String logInfo;
                    String value = info.getParams().get(name);
                    String string = value = value == null ? "" : value;
                    if (isFirst) {
                        logInfo = name + "=" + value;
                        isFirst = false;
                    } else {
                        logInfo = "&" + name + "=" + value;
                    }
                    params.append(logInfo);
                }
            }
            requestBuilder.url(params.toString()).get();
        } else {
            requestBuilder.url(url).get();
        }
        if (Build.VERSION.SDK_INT > 13) {
            requestBuilder.addHeader("Connection", "close");
        }
        HttpHelper.addHeadsToRequest(info, requestBuilder);
        Request request = requestBuilder.build();
        return request;
    }

    /*
     * Exception decompiling
     */
    static HttpInfo doRequestSync(OkHttpClient httpClient, HttpInfo info, int method, Request request, DownloadFileInfo downloadFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HttpInfo doRequestSync(HttpInfo info, int method) {
        return HttpHelper.doRequestSync(null, info, method, null, null);
    }

    public static void doRequestAsync(final HttpInfo info, int method, final CallbackOk callback, Request request) {
        if (null == callback) {
            throw new NullPointerException("CallbackOk is null that not allowed");
        }
        Call call = httpClient.newCall(request == null ? HttpHelper.buildRequest(info, method) : request);
        BaseActivityLifecycleCallbacks.putCall(requestTag, info, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                LogHelper.get().showLog(e.getMessage());
            }

            public void onResponse(Call call, Response res) throws IOException {
                Message msg = new CallbackMessage(1, callback, HttpHelper.dealResponse(info, res, call, null)).build();
                OkMainHandler.getInstance().sendMessage(msg);
                BaseActivityLifecycleCallbacks.cancelCall(requestTag, info, call);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpInfo dealResponse(HttpInfo info, Response res, Call call, DownloadFileInfo downloadFile) {
        try {
            if (null != res) {
                if (res.isSuccessful() && null != res.body()) {
                    if (null == downloadFile) {
                        HttpInfo httpInfo = HttpHelper.retInfo(info, 1, res.body().string());
                        return httpInfo;
                    }
                    HttpInfo httpInfo = DownUpLoadHelper.downloadingFile(info, downloadFile, res, call);
                    return httpInfo;
                }
                LogHelper.get().showLog("HttpStatus: " + res.code());
                if (res.code() == 404) {
                    HttpInfo httpInfo = HttpHelper.retInfo(info, 5);
                    return httpInfo;
                }
                if (res.code() == 416) {
                    HttpInfo httpInfo = HttpHelper.retInfo(info, 11, "\u8bf7\u6c42Http\u6570\u636e\u6d41\u8303\u56f4\u9519\u8bef\n" + res.body().string());
                    return httpInfo;
                }
                if (res.code() == 500) {
                    HttpInfo httpInfo = HttpHelper.retInfo(info, 4);
                    return httpInfo;
                }
                if (res.code() == 502) {
                    HttpInfo httpInfo = HttpHelper.retInfo(info, 6);
                    return httpInfo;
                }
                if (res.code() == 504) {
                    HttpInfo httpInfo = HttpHelper.retInfo(info, 6);
                    return httpInfo;
                }
            }
            HttpInfo httpInfo = HttpHelper.retInfo(info, 5);
            return httpInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpInfo httpInfo = HttpHelper.retInfo(info, 4);
            return httpInfo;
        }
        finally {
            if (null != res) {
                res.close();
            }
        }
    }

    static HttpInfo retInfo(HttpInfo info, int code) {
        HttpHelper.retInfo(info, code, null);
        return info;
    }

    static HttpInfo retInfo(HttpInfo info, int code, String resDetail) {
        info.packInfo(code, resDetail);
        HttpHelper.dealInterceptor(info);
        LogHelper.get().showLog("Response: " + info.getRetDetail());
        return info;
    }

    private static void dealInterceptor(HttpInfo info) {
        try {
            if (info.isSuccessful() && null != resultInterceptors) {
                for (ResultInterceptor interceptor : resultInterceptors) {
                    interceptor.intercept(info);
                }
            } else if (null != exceptionInterceptors) {
                for (ExceptionInterceptor interceptor : exceptionInterceptors) {
                    interceptor.intercept(info);
                }
            }
        }
        catch (Exception e) {
            LogHelper.get().showLog("\u62e6\u622a\u5668\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    static void responseCallback(HttpInfo info, ProgressCallback progressCallback, int code) {
        if (null != progressCallback) {
            progressCallback.onResponseSync(info.getUrl(), info);
        }
        Message msg = new DownloadMessage(code, info.getUrl(), info, progressCallback).build();
        OkMainHandler.getInstance().sendMessage(msg);
    }

    static Request.Builder addHeadsToRequest(HttpInfo info, Request.Builder requestBuilder) {
        if (null != info.getHeads() && !info.getHeads().isEmpty()) {
            for (String key : info.getHeads().keySet()) {
                requestBuilder.addHeader(key, info.getHeads().get(key));
            }
        }
        return requestBuilder;
    }
}

