/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.OkHttpUtilInterface;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.HelperInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.CallbackOk;
import com.okhttplib.helper.DownUpLoadHelper;
import com.okhttplib.helper.HttpHelper;
import com.okhttplib.helper.LogHelper;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpUtil
implements OkHttpUtilInterface {
    private final String TAG = this.getClass().getSimpleName();
    private static Application application;
    private static Builder builderGlobal;
    private static ExecutorService executorService;
    private int maxCacheSize;
    private File cachedDir;
    private int connectTimeout;
    private int readTimeout;
    private int writeTimeout;
    private int cacheSurvivalTime;
    private int cacheType;
    private boolean retryOnConnectionFailure;
    private List<Interceptor> networkInterceptors;
    private List<Interceptor> interceptors;
    private List<ResultInterceptor> resultInterceptors;
    private List<ExceptionInterceptor> exceptionInterceptors;
    private int cacheLevel;
    private boolean showHttpLog;
    private boolean showLifecycleLog;
    private String downloadFileDir;
    private Class<?> requestTag;
    private CookieJar cookieJar;
    private Interceptor CACHE_CONTROL_NETWORK_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response.Builder resBuilder = chain.proceed(chain.request()).newBuilder();
            resBuilder.removeHeader("Pragma").header("Cache-Control", String.format("max-age=%d", OkHttpUtil.this.cacheSurvivalTime));
            return resBuilder.build();
        }
    };
    private Interceptor CACHE_CONTROL_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            switch (OkHttpUtil.this.cacheType) {
                case 2: {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                    break;
                }
                case 1: {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    break;
                }
                case 3: {
                    if (!OkHttpUtil.this.isNetworkAvailable((Context)application)) {
                        request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        break;
                    }
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    break;
                }
                case 4: {
                    if (OkHttpUtil.this.isNetworkAvailable((Context)application)) break;
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                }
            }
            return chain.proceed(request);
        }
    };
    private Interceptor LOG_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            long startTime = System.currentTimeMillis();
            LogHelper.get().showLog(String.format("%s-URL: %s %n", chain.request().method(), chain.request().url()));
            Response res = chain.proceed(chain.request());
            long endTime = System.currentTimeMillis();
            LogHelper.get().showLog(String.format("CostTime: %.1fs", Float.valueOf((float)(endTime - startTime) / 1000.0f)));
            return res;
        }
    };
    private final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static Builder init(Application context) {
        application = context;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new BaseActivityLifecycleCallbacks());
        return OkHttpUtil.BuilderGlobal();
    }

    public static OkHttpUtilInterface getDefault() {
        return new Builder(false).build();
    }

    public static OkHttpUtilInterface getDefault(Object object) {
        return new Builder(false).build(object);
    }

    @Override
    public HttpInfo doPostSync(HttpInfo info) {
        return HttpHelper.doRequestSync(info, 1);
    }

    @Override
    public void doPostAsync(HttpInfo info, CallbackOk callback) {
        HttpHelper.doRequestAsync(info, 1, callback, null);
    }

    @Override
    public HttpInfo doGetSync(HttpInfo info) {
        return HttpHelper.doRequestSync(info, 2);
    }

    @Override
    public void doGetAsync(HttpInfo info, CallbackOk callback) {
        HttpHelper.doRequestAsync(info, 2, callback, null);
    }

    @Override
    public void doUploadFileAsync(final HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (final UploadFileInfo fileInfo : uploadFiles) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    DownUpLoadHelper.uploadFile(info, fileInfo);
                }
            });
        }
    }

    @Override
    public void doUploadFileSync(HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (UploadFileInfo fileInfo : uploadFiles) {
            DownUpLoadHelper.uploadFile(info, fileInfo);
        }
    }

    @Override
    public void doDownloadFileAsync(final HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (final DownloadFileInfo fileInfo : downloadFiles) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    DownUpLoadHelper.downloadFile(info, fileInfo, OkHttpUtil.this.newBuilderFromCopy());
                }
            });
        }
    }

    @Override
    public void doDownloadFileSync(HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (DownloadFileInfo fileInfo : downloadFiles) {
            DownUpLoadHelper.downloadFile(info, fileInfo, this.newBuilderFromCopy());
        }
    }

    private boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo net = cm.getActiveNetworkInfo();
        return net != null && net.getState() == NetworkInfo.State.CONNECTED;
    }

    private OkHttpUtil(Builder builder) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)builder.connectTimeout, TimeUnit.SECONDS).readTimeout((long)builder.readTimeout, TimeUnit.SECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.SECONDS).cache(new Cache(builder.cachedDir, (long)builder.maxCacheSize)).retryOnConnectionFailure(builder.retryOnConnectionFailure).addInterceptor(this.CACHE_CONTROL_INTERCEPTOR).addNetworkInterceptor(this.CACHE_CONTROL_NETWORK_INTERCEPTOR);
        if (null != builder.networkInterceptors && !builder.networkInterceptors.isEmpty()) {
            clientBuilder.networkInterceptors().addAll(builder.networkInterceptors);
        }
        if (null != builder.interceptors && !builder.interceptors.isEmpty()) {
            clientBuilder.interceptors().addAll(builder.interceptors);
        }
        clientBuilder.addInterceptor(this.LOG_INTERCEPTOR);
        this.setSslSocketFactory(clientBuilder);
        this.maxCacheSize = builder.maxCacheSize;
        this.cachedDir = builder.cachedDir;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.networkInterceptors = builder.networkInterceptors;
        this.interceptors = builder.interceptors;
        this.resultInterceptors = builder.resultInterceptors;
        this.exceptionInterceptors = builder.exceptionInterceptors;
        this.cacheSurvivalTime = builder.cacheSurvivalTime;
        this.cacheType = builder.cacheType;
        this.cacheLevel = builder.cacheLevel;
        this.showHttpLog = builder.showHttpLog;
        this.showLifecycleLog = builder.showLifecycleLog;
        this.downloadFileDir = builder.downloadFileDir;
        this.requestTag = builder.requestTag;
        this.cookieJar = builder.cookieJar;
        if (null != this.cookieJar) {
            clientBuilder.cookieJar(this.cookieJar);
        }
        if (this.cacheSurvivalTime == 0) {
            int deviation = 5;
            switch (this.cacheLevel) {
                case 1: {
                    this.cacheSurvivalTime = 0;
                    break;
                }
                case 2: {
                    this.cacheSurvivalTime = 20;
                    break;
                }
                case 3: {
                    this.cacheSurvivalTime = 35;
                    break;
                }
                case 4: {
                    this.cacheSurvivalTime = 65;
                }
            }
        }
        if (this.cacheSurvivalTime > 0) {
            this.cacheType = 4;
        }
        if (null == application) {
            this.cacheType = 1;
        }
        if (null == executorService) {
            executorService = Executors.newCachedThreadPool();
        }
        BaseActivityLifecycleCallbacks.setShowLifecycleLog(this.showLifecycleLog);
        HelperInfo helperInfo = new HelperInfo();
        helperInfo.setShowHttpLog(this.showHttpLog);
        helperInfo.setRequestTag(this.requestTag);
        helperInfo.setTimeStamp(System.currentTimeMillis());
        helperInfo.setExceptionInterceptors(this.exceptionInterceptors);
        helperInfo.setResultInterceptors(this.resultInterceptors);
        helperInfo.setDownloadFileDir(this.downloadFileDir);
        helperInfo.setHttpClient(clientBuilder.build());
        helperInfo.setLogTAG(this.TAG);
        this.initHelper(helperInfo);
    }

    private void initHelper(HelperInfo helperInfo) {
        HttpHelper.init(helperInfo);
        DownUpLoadHelper.init(helperInfo);
        LogHelper.get().init(helperInfo);
    }

    private OkHttpClient.Builder newBuilderFromCopy() {
        OkHttpClient.Builder newBuilder = new OkHttpClient.Builder().connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).cache(new Cache(this.cachedDir, (long)this.maxCacheSize)).retryOnConnectionFailure(this.retryOnConnectionFailure).addInterceptor(this.CACHE_CONTROL_INTERCEPTOR).addNetworkInterceptor(this.CACHE_CONTROL_NETWORK_INTERCEPTOR);
        if (null != this.networkInterceptors && !this.networkInterceptors.isEmpty()) {
            newBuilder.networkInterceptors().addAll(this.networkInterceptors);
        }
        if (null != this.interceptors && !this.interceptors.isEmpty()) {
            newBuilder.interceptors().addAll(this.interceptors);
        }
        newBuilder.addInterceptor(this.LOG_INTERCEPTOR);
        this.setSslSocketFactory(newBuilder);
        return newBuilder;
    }

    private void setSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        clientBuilder.hostnameVerifier(this.DO_NOT_VERIFY);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            clientBuilder.sslSocketFactory(sc.getSocketFactory(), trustManager);
        }
        catch (Exception e) {
            LogHelper.get().showLog("Https\u8ba4\u8bc1\u5f02\u5e38: " + e.getMessage());
        }
    }

    public static Builder Builder() {
        return new Builder(false);
    }

    private static Builder BuilderGlobal() {
        return new Builder(true);
    }

    public static final class Builder {
        private int maxCacheSize;
        private File cachedDir;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private boolean retryOnConnectionFailure;
        private List<Interceptor> networkInterceptors;
        private List<Interceptor> interceptors;
        private List<ResultInterceptor> resultInterceptors;
        private List<ExceptionInterceptor> exceptionInterceptors;
        private int cacheSurvivalTime;
        private int cacheType;
        private int cacheLevel;
        private boolean isGlobalConfig;
        private boolean showHttpLog;
        private boolean showLifecycleLog;
        private String downloadFileDir;
        private Class<?> requestTag;
        private CookieJar cookieJar;

        public Builder() {
        }

        public Builder(boolean isGlobal) {
            this.isGlobalConfig = isGlobal;
            this.initDefaultConfig();
            if (!isGlobal && null != builderGlobal) {
                this.initGlobalConfig(builderGlobal);
            }
        }

        public OkHttpUtilInterface build() {
            return this.build(null);
        }

        public OkHttpUtilInterface build(Object object) {
            if (this.isGlobalConfig && null == builderGlobal) {
                builderGlobal = this;
            }
            if (null != object) {
                this.setRequestTag(object);
            }
            return new OkHttpUtil(this);
        }

        private void initDefaultConfig() {
            this.setMaxCacheSize(0xA00000);
            if (null != application) {
                this.setCachedDir(application.getExternalCacheDir());
            } else {
                this.setCachedDir(Environment.getExternalStorageDirectory());
            }
            this.setConnectTimeout(30);
            this.setReadTimeout(30);
            this.setWriteTimeout(30);
            this.setRetryOnConnectionFailure(true);
            this.setCacheSurvivalTime(0);
            this.setCacheType(4);
            this.setCacheLevel(1);
            this.setNetworkInterceptors(null);
            this.setInterceptors(null);
            this.setResultInterceptors(null);
            this.setExceptionInterceptors(null);
            this.setShowHttpLog(true);
            this.setShowLifecycleLog(false);
            this.setDownloadFileDir(Environment.getExternalStorageDirectory().getPath() + "/okHttp_download/");
        }

        private void initGlobalConfig(Builder builder) {
            this.setMaxCacheSize(builder.maxCacheSize);
            this.setCachedDir(builder.cachedDir);
            this.setConnectTimeout(builder.connectTimeout);
            this.setReadTimeout(builder.readTimeout);
            this.setWriteTimeout(builder.writeTimeout);
            this.setRetryOnConnectionFailure(builder.retryOnConnectionFailure);
            this.setCacheSurvivalTime(builder.cacheSurvivalTime);
            this.setCacheType(builder.cacheType);
            this.setCacheLevel(builder.cacheLevel);
            this.setNetworkInterceptors(builder.networkInterceptors);
            this.setInterceptors(builder.interceptors);
            this.setResultInterceptors(builder.resultInterceptors);
            this.setExceptionInterceptors(builder.exceptionInterceptors);
            this.setShowHttpLog(builder.showHttpLog);
            this.setShowLifecycleLog(builder.showLifecycleLog);
            if (!TextUtils.isEmpty((CharSequence)builder.downloadFileDir)) {
                this.setDownloadFileDir(builder.downloadFileDir);
            }
            this.setCookieJar(builder.cookieJar);
        }

        public Builder setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setCachedDir(File cachedDir) {
            if (null != cachedDir) {
                this.cachedDir = cachedDir;
            }
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("connectTimeout must be > 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(int writeTimeout) {
            if (writeTimeout <= 0) {
                throw new IllegalArgumentException("writeTimeout must be > 0");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder setNetworkInterceptors(List<Interceptor> networkInterceptors) {
            if (null != networkInterceptors) {
                this.networkInterceptors = networkInterceptors;
            }
            return this;
        }

        public Builder setInterceptors(List<Interceptor> interceptors) {
            if (null != interceptors) {
                this.interceptors = interceptors;
            }
            return this;
        }

        public Builder setResultInterceptors(List<ResultInterceptor> resultInterceptors) {
            if (null != resultInterceptors) {
                this.resultInterceptors = resultInterceptors;
            }
            return this;
        }

        public Builder addResultInterceptor(ResultInterceptor resultInterceptor) {
            if (null != resultInterceptor) {
                if (null == this.resultInterceptors) {
                    this.resultInterceptors = new ArrayList<ResultInterceptor>();
                }
                this.resultInterceptors.add(resultInterceptor);
            }
            return this;
        }

        public Builder setExceptionInterceptors(List<ExceptionInterceptor> exceptionInterceptors) {
            if (null != exceptionInterceptors) {
                this.exceptionInterceptors = exceptionInterceptors;
            }
            return this;
        }

        public Builder addExceptionInterceptor(ExceptionInterceptor exceptionInterceptor) {
            if (null != exceptionInterceptor) {
                if (null == this.exceptionInterceptors) {
                    this.exceptionInterceptors = new ArrayList<ExceptionInterceptor>();
                }
                this.exceptionInterceptors.add(exceptionInterceptor);
            }
            return this;
        }

        public Builder setCacheSurvivalTime(int cacheSurvivalTime) {
            if (cacheSurvivalTime < 0) {
                throw new IllegalArgumentException("cacheSurvivalTime must be >= 0");
            }
            this.cacheSurvivalTime = cacheSurvivalTime;
            return this;
        }

        public Builder setCacheType(int cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setCacheLevel(int cacheLevel) {
            this.cacheLevel = cacheLevel;
            return this;
        }

        public Builder setShowHttpLog(boolean showHttpLog) {
            this.showHttpLog = showHttpLog;
            return this;
        }

        public Builder setShowLifecycleLog(boolean showLifecycleLog) {
            this.showLifecycleLog = showLifecycleLog;
            return this;
        }

        public Builder setRequestTag(Object object) {
            this.requestTag = object.getClass();
            return this;
        }

        public Builder setDownloadFileDir(String downloadFileDir) {
            this.downloadFileDir = downloadFileDir;
            return this;
        }

        public Builder setCookieJar(CookieJar cookieJar) {
            if (null != cookieJar) {
                this.cookieJar = cookieJar;
            }
            return this;
        }
    }
}

