/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.HelperInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.helper.HttpHelper;
import com.okhttplib.helper.LogHelper;
import com.okhttplib.progress.ProgressRequestBody;
import com.okhttplib.progress.ProgressResponseBody;
import com.okhttplib.util.EncryptUtil;
import com.okhttplib.util.MediaTypeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DownUpLoadHelper {
    private static long timeStamp;
    private static String downloadFileDir;
    private static Class<?> tag;
    private static Map<String, String> downloadTaskMap;

    private DownUpLoadHelper() {
    }

    public static DownUpLoadHelper get() {
        return new DownUpLoadHelper();
    }

    public static void init(HelperInfo helperInfo) {
        timeStamp = helperInfo.getTimeStamp();
        downloadFileDir = helperInfo.getDownloadFileDir();
        tag = helperInfo.getTag();
    }

    public void uploadFile(HttpInfo info, UploadFileInfo fileInfo) {
        try {
            String filePath = fileInfo.getFilePathWithName();
            String interfaceParamName = fileInfo.getInterfaceParamName();
            String url = fileInfo.getUrl();
            String string = url = TextUtils.isEmpty((CharSequence)url) ? info.getUrl() : url;
            if (TextUtils.isEmpty((CharSequence)url)) {
                LogHelper.get().showLog("\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a[" + filePath + "]");
                return;
            }
            ProgressCallback progressCallback = fileInfo.getProgressCallback();
            File file = new File(filePath);
            MultipartBody.Builder mBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            StringBuilder log = new StringBuilder("PostParams: ");
            log.append(interfaceParamName);
            log.append("=");
            log.append(filePath);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                for (String key : info.getParams().keySet()) {
                    mBuilder.addFormDataPart(key, info.getParams().get(key));
                    String logInfo = key + " =" + info.getParams().get(key) + ", ";
                    log.append(logInfo);
                }
            }
            LogHelper.get().showLog(log.toString());
            mBuilder.addFormDataPart(interfaceParamName, file.getName(), RequestBody.create((MediaType)MediaTypeUtil.fetchFileMediaType(filePath), (File)file));
            MultipartBody requestBody = mBuilder.build();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url).post((RequestBody)new ProgressRequestBody((RequestBody)requestBody, progressCallback));
            HttpHelper.get().addHeadsToRequest(info, requestBuilder);
            Request request = requestBuilder.build();
            HttpHelper.get().doRequestSync(null, info, 1, request, null);
            HttpHelper.get().responseCallback(info, progressCallback, 3);
        }
        catch (Exception e) {
            LogHelper.get().showLog("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void downloadFile(HttpInfo info, final DownloadFileInfo fileInfo, OkHttpClient.Builder builder) {
        try {
            String url = fileInfo.getUrl();
            if (TextUtils.isEmpty((CharSequence)url)) {
                LogHelper.get().showLog("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return;
            }
            info.setUrl(url);
            ProgressCallback progressCallback = fileInfo.getProgressCallback();
            long completedSize = this.fetchCompletedSize(fileInfo);
            fileInfo.setCompletedSize(completedSize);
            if (null == downloadTaskMap) {
                downloadTaskMap = new ConcurrentHashMap<String, String>();
            }
            if (downloadTaskMap.containsKey(fileInfo.getSaveFileNameEncrypt())) {
                LogHelper.get().showLog(fileInfo.getSaveFileName() + " \u5df2\u5728\u4e0b\u8f7d\u4efb\u52a1\u4e2d");
                return;
            }
            downloadTaskMap.put(fileInfo.getSaveFileNameEncrypt(), fileInfo.getSaveFileNameEncrypt());
            Interceptor interceptor = new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), fileInfo)).build();
                }
            };
            OkHttpClient httpClient = builder.addInterceptor(interceptor).build();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url).header("RANGE", "bytes=" + completedSize + "-");
            HttpHelper.get().addHeadsToRequest(info, requestBuilder);
            Request request = requestBuilder.build();
            HttpHelper.get().doRequestSync(httpClient, info, 2, request, fileInfo);
            if (null != downloadTaskMap) {
                downloadTaskMap.remove(fileInfo.getSaveFileNameEncrypt());
            }
            HttpHelper.get().responseCallback(info, progressCallback, 4);
        }
        catch (Exception e) {
            LogHelper.get().showLog("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpInfo downloadingFile(HttpInfo info, DownloadFileInfo fileInfo, Response res, Call call) {
        RandomAccessFile accessFile = null;
        InputStream inputStream = null;
        BufferedInputStream bis = null;
        String filePath = fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameWithExtension();
        try {
            int length;
            ResponseBody responseBody = res.body();
            long completedSize = fileInfo.getCompletedSize();
            accessFile = new RandomAccessFile(fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameEncrypt(), "rwd");
            if (TextUtils.isEmpty((CharSequence)res.header("Content-Range"))) {
                completedSize = 0L;
                fileInfo.setCompletedSize(completedSize);
            }
            accessFile.seek(completedSize);
            inputStream = responseBody.byteStream();
            byte[] buffer = new byte[2048];
            bis = new BufferedInputStream(inputStream);
            fileInfo.setDownloadStatus("DOWNLOADING");
            while ((length = bis.read(buffer)) > 0 && "DOWNLOADING".equals(fileInfo.getDownloadStatus())) {
                accessFile.write(buffer, 0, length);
                completedSize += (long)length;
            }
            if ("PAUSE".equals(fileInfo.getDownloadStatus())) {
                HttpInfo httpInfo = HttpHelper.get().retInfo(info, 11, "\u6682\u505c\u4e0b\u8f7d");
                return httpInfo;
            }
            if ("DOWNLOADING".equals(fileInfo.getDownloadStatus())) {
                File oldFile;
                fileInfo.setDownloadStatus("COMPLETED");
                File newFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameWithExtension());
                if (newFile.exists() && newFile.isFile()) {
                    filePath = fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameCopy();
                    newFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameCopy());
                }
                if ((oldFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameEncrypt())).exists() && oldFile.isFile()) {
                    boolean rename = oldFile.renameTo(newFile);
                    LogHelper.get().showLog("\u91cd\u547d\u540d[" + rename + "]:" + newFile.getAbsolutePath());
                }
                HttpInfo httpInfo = HttpHelper.get().retInfo(info, 1, filePath);
                return httpInfo;
            }
        }
        catch (SocketTimeoutException e) {
            HttpInfo httpInfo = HttpHelper.get().retInfo(info, 8);
            return httpInfo;
        }
        catch (Exception e) {
            HttpInfo httpInfo = HttpHelper.get().retInfo(info, 9);
            return httpInfo;
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != accessFile) {
                    accessFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BaseActivityLifecycleCallbacks.cancelCall(tag, info, call);
            if (null != downloadTaskMap) {
                downloadTaskMap.remove(fileInfo.getSaveFileNameEncrypt());
            }
        }
        return HttpHelper.get().retInfo(info, 1, filePath);
    }

    private long fetchCompletedSize(DownloadFileInfo fileInfo) {
        String saveFileDir = fileInfo.getSaveFileDir();
        String saveFileName = fileInfo.getSaveFileName();
        String url = fileInfo.getUrl();
        String extension = url.substring(url.lastIndexOf(".") + 1);
        String saveFileNameCopy = saveFileName + "[" + timeStamp + "]" + "." + extension;
        saveFileName = saveFileName + "." + extension;
        saveFileDir = TextUtils.isEmpty((CharSequence)saveFileDir) ? downloadFileDir : saveFileDir;
        this.mkDirNotExists(saveFileDir);
        fileInfo.setSaveFileDir(saveFileDir);
        fileInfo.setSaveFileNameCopy(saveFileNameCopy);
        fileInfo.setSaveFileNameWithExtension(saveFileName);
        String saveFileNameEncrypt = url;
        try {
            saveFileNameEncrypt = EncryptUtil.MD5StringTo32Bit(url, true);
            fileInfo.setSaveFileNameEncrypt(saveFileNameEncrypt);
        }
        catch (Exception e) {
            LogHelper.get().showLog("\u65ad\u70b9\u6587\u4ef6\u4e0b\u8f7d: \u6587\u4ef6\u540dMD5\u52a0\u5bc6\u5931\u8d25 " + e.getMessage());
        }
        File file = new File(saveFileDir, saveFileNameEncrypt);
        if (file.exists() && file.isFile()) {
            long size = file.length();
            LogHelper.get().showLog("\u65ad\u70b9\u6587\u4ef6\u4e0b\u8f7d\uff0c\u8282\u70b9[" + size + "]");
            return size;
        }
        return 0L;
    }

    private boolean mkDirNotExists(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }
}

