/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.callback;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import com.okhttplib.HttpInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;

public class BaseActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityLifecycle";
    private static boolean showLifecycleLog;
    private static Map<Class<?>, SparseArray<Call>> callsMap;

    public static void putCall(Class<?> tag, HttpInfo info, Call call) {
        Class<?> t = BaseActivityLifecycleCallbacks.fetchTag(tag, info);
        if (null != t) {
            SparseArray callList = callsMap.get(t);
            if (null == callList) {
                callList = new SparseArray();
            }
            callList.put(call.hashCode(), (Object)call);
            callsMap.put(t, (SparseArray<Call>)callList);
            BaseActivityLifecycleCallbacks.showLog(false);
        }
    }

    private static void cancelCallByActivityDestroy(Class<?> tag) {
        if (null == tag) {
            return;
        }
        SparseArray<Call> callList = callsMap.get(tag);
        if (null != callList) {
            int len = callList.size();
            for (int i = 0; i < len; ++i) {
                Call call = (Call)callList.valueAt(i);
                if (null == call || call.isCanceled()) continue;
                call.cancel();
            }
            callList.clear();
            callsMap.remove(tag);
            BaseActivityLifecycleCallbacks.showLog(true);
        }
    }

    public static void cancelCall(Class<?> tag, HttpInfo info, Call call) {
        SparseArray<Call> callList;
        Class<?> t = BaseActivityLifecycleCallbacks.fetchTag(tag, info);
        if (null != call && null != t && null != (callList = callsMap.get(t))) {
            Call c = (Call)callList.get(call.hashCode());
            if (null != c && !c.isCanceled()) {
                c.cancel();
            }
            callList.delete(call.hashCode());
            if (callList.size() == 0) {
                callsMap.remove(t);
            }
            BaseActivityLifecycleCallbacks.showLog(true);
        }
    }

    private static Class<?> fetchTag(Class<?> tag, HttpInfo info) {
        Class<?> t = null;
        if (null != tag) {
            t = tag;
        }
        if (null != info.getTag() && null == t) {
            t = info.getTag();
        }
        return t;
    }

    private static void showLog(boolean isCancel) {
        int originalSize;
        if (!showLifecycleLog) {
            return;
        }
        String callDetail = "\u589e\u52a0\u8bf7\u6c42";
        if (isCancel) {
            callDetail = "\u53d6\u6d88\u8bf7\u6c42";
        }
        if ((originalSize = callsMap.size()) > 0) {
            for (Map.Entry<Class<?>, SparseArray<Call>> entry : callsMap.entrySet()) {
                int rest = entry.getValue().size();
                Log.d((String)TAG, (String)(callDetail + ": size = " + rest + " [" + entry.getKey().getName() + "]"));
            }
        } else {
            Log.d((String)TAG, (String)(callDetail + ": size = 0 "));
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        BaseActivityLifecycleCallbacks.cancelCallByActivityDestroy(activity.getClass());
    }

    public static void setShowLifecycleLog(boolean showLifecycle) {
        showLifecycleLog = showLifecycle;
    }

    static {
        callsMap = new ConcurrentHashMap();
    }
}

