/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.okhttplib.HttpInfo;
import com.okhttplib.OkHttpUtilAbs;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.CallbackOk;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import com.okhttplib.progress.ProgressRequestBody;
import com.okhttplib.progress.ProgressResponseBody;
import com.okhttplib.util.EncryptUtil;
import com.okhttplib.util.MediaTypeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpUtil
extends OkHttpUtilAbs {
    private final String TAG = this.getClass().getSimpleName();
    private static Application application;
    private OkHttpClient httpClient;
    private static Builder builderGlobal;
    private ExecutorService executorService;
    private long timeStamp;
    int maxCacheSize;
    File cachedDir;
    int connectTimeout;
    int readTimeout;
    int writeTimeout;
    boolean retryOnConnectionFailure;
    List<Interceptor> networkInterceptors;
    List<Interceptor> interceptors;
    List<ResultInterceptor> resultInterceptors;
    List<ExceptionInterceptor> exceptionInterceptors;
    int cacheSurvivalTime;
    int cacheType;
    int cacheLevel;
    boolean isGlobalConfig;
    boolean showHttpLog;
    boolean showLifecycleLog;
    String downloadFileDir;
    Class<?> tag;
    CookieJar cookieJar;
    private static Map<String, String> downloadTaskMap;
    private Interceptor CACHE_CONTROL_NETWORK_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response.Builder resBuilder = chain.proceed(chain.request()).newBuilder();
            resBuilder.removeHeader("Pragma").header("Cache-Control", String.format("max-age=%d", OkHttpUtil.this.cacheSurvivalTime));
            return resBuilder.build();
        }
    };
    private Interceptor CACHE_CONTROL_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            switch (OkHttpUtil.this.cacheType) {
                case 2: {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                    break;
                }
                case 1: {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    break;
                }
                case 3: {
                    if (!OkHttpUtil.this.isNetworkAvailable((Context)application)) {
                        request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        break;
                    }
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    break;
                }
                case 4: {
                    if (OkHttpUtil.this.isNetworkAvailable((Context)application)) break;
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                }
            }
            return chain.proceed(request);
        }
    };
    private Interceptor LOG_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            long startTime = System.currentTimeMillis();
            OkHttpUtil.this.showLog(String.format("%s-URL: %s %n", chain.request().method(), chain.request().url()));
            Response res = chain.proceed(chain.request());
            long endTime = System.currentTimeMillis();
            OkHttpUtil.this.showLog(String.format("CostTime: %.1fs", (double)(endTime - startTime) / 1000.0));
            return res;
        }
    };
    private final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static Builder init(Application context) {
        application = context;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new BaseActivityLifecycleCallbacks());
        return OkHttpUtil.BuilderGlobal();
    }

    public static OkHttpUtil getDefault() {
        return new Builder(false).build();
    }

    public static OkHttpUtil getDefault(Object object) {
        return new Builder(false).build(object);
    }

    @Override
    public HttpInfo doPostSync(HttpInfo info) {
        return this.doRequestSync(info, 1);
    }

    @Override
    public void doPostAsync(HttpInfo info, CallbackOk callback) {
        this.doRequestAsync(info, 1, callback, null);
    }

    @Override
    public HttpInfo doGetSync(HttpInfo info) {
        return this.doRequestSync(info, 2);
    }

    @Override
    public void doGetAsync(HttpInfo info, CallbackOk callback) {
        this.doRequestAsync(info, 2, callback, null);
    }

    @Override
    public void doUploadFileAsync(final HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (final UploadFileInfo fileInfo : uploadFiles) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpUtil.this.uploadFile(fileInfo, info);
                }
            });
        }
    }

    @Override
    public void doUploadFileSync(HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (UploadFileInfo fileInfo : uploadFiles) {
            this.uploadFile(fileInfo, info);
        }
    }

    @Override
    public void doDownloadFileAsync(final HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (final DownloadFileInfo fileInfo : downloadFiles) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        OkHttpUtil.this.downloadFile(fileInfo, info);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void doDownloadFileSync(HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (DownloadFileInfo fileInfo : downloadFiles) {
            try {
                this.downloadFile(fileInfo, info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void uploadFile(UploadFileInfo fileInfo, HttpInfo info) {
        try {
            String filePath = fileInfo.getFilePathWithName();
            String interfaceParamName = fileInfo.getInterfaceParamName();
            String url = fileInfo.getUrl();
            String string = url = TextUtils.isEmpty((CharSequence)url) ? info.getUrl() : url;
            if (TextUtils.isEmpty((CharSequence)url)) {
                this.showLog("\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a[" + filePath + "]");
                return;
            }
            ProgressCallback progressCallback = fileInfo.getProgressCallback();
            File file = new File(filePath);
            MultipartBody.Builder mBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            StringBuilder log = new StringBuilder("PostParams: ");
            log.append(interfaceParamName + "=" + filePath);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                for (String key : info.getParams().keySet()) {
                    mBuilder.addFormDataPart(key, info.getParams().get(key));
                    String logInfo = key + " =" + info.getParams().get(key) + ", ";
                    log.append(logInfo);
                }
            }
            this.showLog(log.toString());
            mBuilder.addFormDataPart(interfaceParamName, file.getName(), RequestBody.create((MediaType)MediaTypeUtil.fetchFileMediaType(filePath), (File)file));
            MultipartBody requestBody = mBuilder.build();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url).post((RequestBody)new ProgressRequestBody((RequestBody)requestBody, progressCallback));
            this.addHeadsToRequest(info, requestBuilder);
            Request request = requestBuilder.build();
            this.doRequestSync(null, info, 1, request, null);
            this.responseCallback(info, progressCallback, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void downloadFile(final DownloadFileInfo fileInfo, HttpInfo info) {
        String url = fileInfo.getUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.showLog("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        info.setUrl(url);
        ProgressCallback progressCallback = fileInfo.getProgressCallback();
        long completedSize = this.fetchCompletedSize(fileInfo);
        fileInfo.setCompletedSize(completedSize);
        if (null == downloadTaskMap) {
            downloadTaskMap = new ConcurrentHashMap<String, String>();
        }
        if (downloadTaskMap.containsKey(fileInfo.getSaveFileNameEncrypt())) {
            info = this.retInfo(info, 11, fileInfo.getSaveFileName() + " \u5df2\u5728\u4e0b\u8f7d\u4efb\u52a1\u4e2d");
            this.responseCallback(info, progressCallback, 4);
            return;
        }
        downloadTaskMap.put(fileInfo.getSaveFileNameEncrypt(), fileInfo.getSaveFileNameEncrypt());
        Interceptor interceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), fileInfo)).build();
            }
        };
        OkHttpClient httpClient = this.newBuilderFromCopy().addInterceptor(interceptor).build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url).header("RANGE", "bytes=" + completedSize + "-");
        this.addHeadsToRequest(info, requestBuilder);
        Request request = requestBuilder.build();
        this.doRequestSync(httpClient, info, 2, request, fileInfo);
        if (null != downloadTaskMap) {
            downloadTaskMap.remove(fileInfo.getSaveFileNameEncrypt());
        }
        this.responseCallback(info, progressCallback, 4);
    }

    private void responseCallback(HttpInfo info, ProgressCallback progressCallback, int code) {
        if (null != progressCallback) {
            progressCallback.onResponseSync(info.getUrl(), info);
        }
        Message msg = new DownloadMessage(code, info.getUrl(), info, progressCallback).build();
        OkMainHandler.getInstance().sendMessage(msg);
    }

    private long fetchCompletedSize(DownloadFileInfo fileInfo) {
        String saveFileDir = fileInfo.getSaveFileDir();
        String saveFileName = fileInfo.getSaveFileName();
        String url = fileInfo.getUrl();
        String extension = url.substring(url.lastIndexOf(".") + 1);
        String saveFileNameCopy = saveFileName + "[" + this.timeStamp + "]" + "." + extension;
        saveFileName = saveFileName + "." + extension;
        saveFileDir = TextUtils.isEmpty((CharSequence)saveFileDir) ? this.downloadFileDir : saveFileDir;
        this.mkDirNotExists(saveFileDir);
        fileInfo.setSaveFileDir(saveFileDir);
        fileInfo.setSaveFileNameCopy(saveFileNameCopy);
        fileInfo.setSaveFileNameWithExtension(saveFileName);
        String saveFileNameEncrypt = url;
        try {
            saveFileNameEncrypt = EncryptUtil.MD5StringTo32Bit(url, true);
            fileInfo.setSaveFileNameEncrypt(saveFileNameEncrypt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File file = new File(saveFileDir, saveFileNameEncrypt);
        if (file.exists() && file.isFile()) {
            long size = file.length();
            this.showLog("\u65ad\u70b9\u6587\u4ef6\u4e0b\u8f7d\uff0c\u8282\u70b9[" + size + "]");
            return size;
        }
        return 0L;
    }

    private HttpInfo doRequestSync(HttpInfo info, int method) {
        return this.doRequestSync(null, info, method, null, null);
    }

    /*
     * Exception decompiling
     */
    private HttpInfo doRequestSync(OkHttpClient httpClient, HttpInfo info, int method, Request request, DownloadFileInfo downloadFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doRequestAsync(final HttpInfo info, int method, final CallbackOk callback, Request request) {
        if (null == callback) {
            throw new NullPointerException("CallbackOk is null that not allowed");
        }
        Call call = this.httpClient.newCall(request == null ? this.fetchRequest(info, method) : request);
        BaseActivityLifecycleCallbacks.putCall(this.tag, info, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpUtil.this.showLog(e.getMessage());
            }

            public void onResponse(Call call, Response res) throws IOException {
                Message msg = new CallbackMessage(1, callback, OkHttpUtil.this.dealResponse(info, res, call, null)).build();
                OkMainHandler.getInstance().sendMessage(msg);
                BaseActivityLifecycleCallbacks.cancelCall(OkHttpUtil.this.tag, info, call);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpInfo dealResponse(HttpInfo info, Response res, Call call, DownloadFileInfo downloadFile) {
        try {
            if (null != res) {
                if (res.isSuccessful() && null != res.body()) {
                    if (null == downloadFile) {
                        HttpInfo httpInfo = this.retInfo(info, 1, res.body().string());
                        return httpInfo;
                    }
                    HttpInfo httpInfo = this.dealDownloadFile(info, downloadFile, res, call);
                    return httpInfo;
                }
                this.showLog("HttpStatus: " + res.code());
                if (res.code() == 404) {
                    HttpInfo httpInfo = this.retInfo(info, 5);
                    return httpInfo;
                }
                if (res.code() == 416) {
                    HttpInfo httpInfo = this.retInfo(info, 11, "\u8bf7\u6c42Http\u6570\u636e\u6d41\u8303\u56f4\u9519\u8bef\n" + res.body().string());
                    return httpInfo;
                }
                if (res.code() == 500) {
                    HttpInfo httpInfo = this.retInfo(info, 4);
                    return httpInfo;
                }
                if (res.code() == 502) {
                    HttpInfo httpInfo = this.retInfo(info, 6);
                    return httpInfo;
                }
                if (res.code() == 504) {
                    HttpInfo httpInfo = this.retInfo(info, 6);
                    return httpInfo;
                }
            }
            HttpInfo httpInfo = this.retInfo(info, 5);
            return httpInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpInfo httpInfo = this.retInfo(info, 4);
            return httpInfo;
        }
        finally {
            if (null != res) {
                res.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpInfo dealDownloadFile(HttpInfo info, DownloadFileInfo fileInfo, Response res, Call call) {
        RandomAccessFile accessFile = null;
        InputStream inputStream = null;
        BufferedInputStream bis = null;
        String filePath = fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameWithExtension();
        try {
            int length;
            ResponseBody responseBody = res.body();
            long completedSize = fileInfo.getCompletedSize();
            accessFile = new RandomAccessFile(fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameEncrypt(), "rwd");
            if (TextUtils.isEmpty((CharSequence)res.header("Content-Range"))) {
                completedSize = 0L;
                fileInfo.setCompletedSize(completedSize);
            }
            accessFile.seek(completedSize);
            inputStream = responseBody.byteStream();
            byte[] buffer = new byte[2048];
            bis = new BufferedInputStream(inputStream);
            fileInfo.setDownloadStatus("DOWNLOADING");
            while ((length = bis.read(buffer)) > 0 && "DOWNLOADING".equals(fileInfo.getDownloadStatus())) {
                accessFile.write(buffer, 0, length);
                completedSize += (long)length;
            }
            if ("PAUSE".equals(fileInfo.getDownloadStatus())) {
                HttpInfo httpInfo = this.retInfo(info, 11, "\u6682\u505c\u4e0b\u8f7d");
                return httpInfo;
            }
            if ("DOWNLOADING".equals(fileInfo.getDownloadStatus())) {
                File oldFile;
                fileInfo.setDownloadStatus("COMPLETED");
                File newFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameWithExtension());
                if (newFile.exists() && newFile.isFile()) {
                    filePath = fileInfo.getSaveFileDir() + fileInfo.getSaveFileNameCopy();
                    newFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameCopy());
                }
                if ((oldFile = new File(fileInfo.getSaveFileDir(), fileInfo.getSaveFileNameEncrypt())).exists() && oldFile.isFile()) {
                    oldFile.renameTo(newFile);
                }
                HttpInfo httpInfo = this.retInfo(info, 1, filePath);
                return httpInfo;
            }
        }
        catch (SocketTimeoutException e) {
            HttpInfo httpInfo = this.retInfo(info, 8);
            return httpInfo;
        }
        catch (Exception e) {
            HttpInfo httpInfo = this.retInfo(info, 9);
            return httpInfo;
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != accessFile) {
                    accessFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BaseActivityLifecycleCallbacks.cancelCall(this.tag, info, call);
            if (null != downloadTaskMap) {
                downloadTaskMap.remove(fileInfo.getSaveFileNameEncrypt());
            }
        }
        return this.retInfo(info, 1, filePath);
    }

    private boolean mkDirNotExists(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    private Request fetchRequest(HttpInfo info, int method) {
        Request.Builder requestBuilder = new Request.Builder();
        if (method == 1) {
            FormBody.Builder builder = new FormBody.Builder();
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                StringBuilder log = new StringBuilder("PostParams: ");
                for (String key : info.getParams().keySet()) {
                    String value = info.getParams().get(key);
                    value = value == null ? "" : value;
                    builder.add(key, value);
                    String logInfo = key + "=" + value + ", ";
                    log.append(logInfo);
                }
                this.showLog(log.toString());
            }
            requestBuilder.url(info.getUrl()).post((RequestBody)builder.build());
        } else {
            StringBuilder params = new StringBuilder();
            params.append(info.getUrl());
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                if (!info.getUrl().endsWith("?")) {
                    params.append("?");
                }
                boolean isFirst = true;
                for (String name : info.getParams().keySet()) {
                    String logInfo;
                    String value = info.getParams().get(name);
                    String string = value = value == null ? "" : value;
                    if (isFirst) {
                        logInfo = name + "=" + value;
                        isFirst = false;
                    } else {
                        logInfo = "&" + name + "=" + value;
                    }
                    params.append(logInfo);
                }
            }
            requestBuilder.url(params.toString()).get();
        }
        if (Build.VERSION.SDK_INT > 13) {
            requestBuilder.addHeader("Connection", "close");
        }
        this.addHeadsToRequest(info, requestBuilder);
        Request request = requestBuilder.build();
        return request;
    }

    private Request.Builder addHeadsToRequest(HttpInfo info, Request.Builder requestBuilder) {
        if (null != info.getHeads() && !info.getHeads().isEmpty()) {
            for (String key : info.getHeads().keySet()) {
                requestBuilder.addHeader(key, info.getHeads().get(key));
            }
        }
        return requestBuilder;
    }

    private HttpInfo retInfo(HttpInfo info, int code) {
        this.retInfo(info, code, null);
        return info;
    }

    private HttpInfo retInfo(HttpInfo info, int code, String resDetail) {
        info.packInfo(code, resDetail);
        this.dealInterceptor(info);
        this.showLog("Response: " + info.getRetDetail());
        return info;
    }

    private void dealInterceptor(HttpInfo info) {
        try {
            if (info.isSuccessful()) {
                if (null != this.resultInterceptors) {
                    for (ResultInterceptor interceptor : this.resultInterceptors) {
                        interceptor.intercept(info);
                    }
                }
            } else if (null != this.exceptionInterceptors) {
                for (ExceptionInterceptor interceptor : this.exceptionInterceptors) {
                    interceptor.intercept(info);
                }
            }
        }
        catch (Exception e) {
            this.showLog("\u62e6\u622a\u5668\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo net = cm.getActiveNetworkInfo();
        return net != null && net.getState() == NetworkInfo.State.CONNECTED;
    }

    private OkHttpClient.Builder newBuilderFromCopy() {
        OkHttpClient.Builder newBuilder = new OkHttpClient.Builder().connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).cache(new Cache(this.cachedDir, (long)this.maxCacheSize)).retryOnConnectionFailure(this.retryOnConnectionFailure).addInterceptor(this.CACHE_CONTROL_INTERCEPTOR).addNetworkInterceptor(this.CACHE_CONTROL_NETWORK_INTERCEPTOR);
        if (null != this.networkInterceptors && !this.networkInterceptors.isEmpty()) {
            newBuilder.networkInterceptors().addAll(this.networkInterceptors);
        }
        if (null != this.interceptors && !this.interceptors.isEmpty()) {
            newBuilder.interceptors().addAll(this.interceptors);
        }
        newBuilder.addInterceptor(this.LOG_INTERCEPTOR);
        return newBuilder;
    }

    private OkHttpUtil(Builder builder) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)builder.connectTimeout, TimeUnit.SECONDS).readTimeout((long)builder.readTimeout, TimeUnit.SECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.SECONDS).cache(new Cache(builder.cachedDir, (long)builder.maxCacheSize)).retryOnConnectionFailure(builder.retryOnConnectionFailure).addInterceptor(this.CACHE_CONTROL_INTERCEPTOR).addNetworkInterceptor(this.CACHE_CONTROL_NETWORK_INTERCEPTOR);
        if (null != builder.networkInterceptors && !builder.networkInterceptors.isEmpty()) {
            clientBuilder.networkInterceptors().addAll(builder.networkInterceptors);
        }
        if (null != builder.interceptors && !builder.interceptors.isEmpty()) {
            clientBuilder.interceptors().addAll(builder.interceptors);
        }
        clientBuilder.addInterceptor(this.LOG_INTERCEPTOR);
        this.setSslSocketFactory(clientBuilder);
        this.maxCacheSize = builder.maxCacheSize;
        this.cachedDir = builder.cachedDir;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.networkInterceptors = builder.networkInterceptors;
        this.interceptors = builder.interceptors;
        this.resultInterceptors = builder.resultInterceptors;
        this.exceptionInterceptors = builder.exceptionInterceptors;
        this.cacheSurvivalTime = builder.cacheSurvivalTime;
        this.cacheType = builder.cacheType;
        this.cacheLevel = builder.cacheLevel;
        this.isGlobalConfig = builder.isGlobalConfig;
        this.showHttpLog = builder.showHttpLog;
        this.showLifecycleLog = builder.showLifecycleLog;
        this.downloadFileDir = builder.downloadFileDir;
        this.tag = builder.tag;
        this.cookieJar = builder.cookieJar;
        if (null != this.cookieJar) {
            clientBuilder.cookieJar(this.cookieJar);
        }
        this.httpClient = clientBuilder.build();
        this.timeStamp = System.currentTimeMillis();
        if (this.cacheSurvivalTime == 0) {
            int deviation = 5;
            switch (this.cacheLevel) {
                case 1: {
                    this.cacheSurvivalTime = 0;
                    break;
                }
                case 2: {
                    this.cacheSurvivalTime = 20;
                    break;
                }
                case 3: {
                    this.cacheSurvivalTime = 35;
                    break;
                }
                case 4: {
                    this.cacheSurvivalTime = 65;
                }
            }
        }
        if (this.cacheSurvivalTime > 0) {
            this.cacheType = 4;
        }
        if (null == application) {
            this.cacheType = 1;
        }
        BaseActivityLifecycleCallbacks.setShowLifecycleLog(builder.showLifecycleLog);
        this.executorService = Executors.newCachedThreadPool();
    }

    private void setSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        clientBuilder.hostnameVerifier(this.DO_NOT_VERIFY);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            clientBuilder.sslSocketFactory(sc.getSocketFactory(), trustManager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Builder Builder() {
        return new Builder(false);
    }

    private static Builder BuilderGlobal() {
        return new Builder(true);
    }

    private void showLog(String msg) {
        if (this.showHttpLog) {
            Log.d((String)(this.TAG + "[" + this.timeStamp + "]"), (String)msg);
        }
    }

    public static final class Builder {
        private int maxCacheSize;
        private File cachedDir;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private boolean retryOnConnectionFailure;
        private List<Interceptor> networkInterceptors;
        private List<Interceptor> interceptors;
        private List<ResultInterceptor> resultInterceptors;
        private List<ExceptionInterceptor> exceptionInterceptors;
        private int cacheSurvivalTime;
        private int cacheType;
        private int cacheLevel;
        private boolean isGlobalConfig;
        private boolean showHttpLog;
        private boolean showLifecycleLog;
        private String downloadFileDir;
        private Class<?> tag;
        private CookieJar cookieJar;

        public Builder() {
        }

        public Builder(boolean isGlobal) {
            this.isGlobalConfig = isGlobal;
            this.initDefaultConfig();
            if (!isGlobal && null != builderGlobal) {
                this.initGlobalConfig(builderGlobal);
            }
        }

        public OkHttpUtil build() {
            return this.build(null);
        }

        public OkHttpUtil build(Object object) {
            if (this.isGlobalConfig && null == builderGlobal) {
                builderGlobal = this;
            }
            if (null != object) {
                this.setTag(object);
            }
            return new OkHttpUtil(this);
        }

        private void initDefaultConfig() {
            this.setMaxCacheSize(0xA00000);
            if (null != application) {
                this.setCachedDir(application.getExternalCacheDir());
            } else {
                this.setCachedDir(Environment.getExternalStorageDirectory());
            }
            this.setConnectTimeout(30);
            this.setReadTimeout(30);
            this.setWriteTimeout(30);
            this.setRetryOnConnectionFailure(true);
            this.setCacheSurvivalTime(0);
            this.setCacheType(4);
            this.setCacheLevel(1);
            this.setNetworkInterceptors(null);
            this.setInterceptors(null);
            this.setResultInterceptors(null);
            this.setExceptionInterceptors(null);
            this.setShowHttpLog(true);
            this.setShowLifecycleLog(false);
            this.setDownloadFileDir(Environment.getExternalStorageDirectory().getPath() + "/okHttp_download/");
        }

        private void initGlobalConfig(Builder builder) {
            this.setMaxCacheSize(builder.maxCacheSize);
            this.setCachedDir(builder.cachedDir);
            this.setConnectTimeout(builder.connectTimeout);
            this.setReadTimeout(builder.readTimeout);
            this.setWriteTimeout(builder.writeTimeout);
            this.setRetryOnConnectionFailure(builder.retryOnConnectionFailure);
            this.setCacheSurvivalTime(builder.cacheSurvivalTime);
            this.setCacheType(builder.cacheType);
            this.setCacheLevel(builder.cacheLevel);
            this.setNetworkInterceptors(builder.networkInterceptors);
            this.setInterceptors(builder.interceptors);
            this.setResultInterceptors(builder.resultInterceptors);
            this.setExceptionInterceptors(builder.exceptionInterceptors);
            this.setShowHttpLog(builder.showHttpLog);
            this.setShowLifecycleLog(builder.showLifecycleLog);
            if (!TextUtils.isEmpty((CharSequence)builder.downloadFileDir)) {
                this.setDownloadFileDir(builder.downloadFileDir);
            }
            this.setCookieJar(builder.cookieJar);
        }

        public Builder setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setCachedDir(File cachedDir) {
            if (null != cachedDir) {
                this.cachedDir = cachedDir;
            }
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("connectTimeout must be > 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(int writeTimeout) {
            if (writeTimeout <= 0) {
                throw new IllegalArgumentException("writeTimeout must be > 0");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder setNetworkInterceptors(List<Interceptor> networkInterceptors) {
            if (null != networkInterceptors) {
                this.networkInterceptors = networkInterceptors;
            }
            return this;
        }

        public Builder setInterceptors(List<Interceptor> interceptors) {
            if (null != interceptors) {
                this.interceptors = interceptors;
            }
            return this;
        }

        public Builder setResultInterceptors(List<ResultInterceptor> resultInterceptors) {
            if (null != resultInterceptors) {
                this.resultInterceptors = resultInterceptors;
            }
            return this;
        }

        public Builder addResultInterceptor(ResultInterceptor resultInterceptor) {
            if (null != resultInterceptor) {
                if (null == this.resultInterceptors) {
                    this.resultInterceptors = new ArrayList<ResultInterceptor>();
                }
                this.resultInterceptors.add(resultInterceptor);
            }
            return this;
        }

        public Builder setExceptionInterceptors(List<ExceptionInterceptor> exceptionInterceptors) {
            if (null != exceptionInterceptors) {
                this.exceptionInterceptors = exceptionInterceptors;
            }
            return this;
        }

        public Builder addExceptionInterceptor(ExceptionInterceptor exceptionInterceptor) {
            if (null != exceptionInterceptor) {
                if (null == this.exceptionInterceptors) {
                    this.exceptionInterceptors = new ArrayList<ExceptionInterceptor>();
                }
                this.exceptionInterceptors.add(exceptionInterceptor);
            }
            return this;
        }

        public Builder setCacheSurvivalTime(int cacheSurvivalTime) {
            if (cacheSurvivalTime < 0) {
                throw new IllegalArgumentException("cacheSurvivalTime must be >= 0");
            }
            this.cacheSurvivalTime = cacheSurvivalTime;
            return this;
        }

        public Builder setCacheType(int cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setCacheLevel(int cacheLevel) {
            this.cacheLevel = cacheLevel;
            return this;
        }

        public Builder setShowHttpLog(boolean showHttpLog) {
            this.showHttpLog = showHttpLog;
            return this;
        }

        public Builder setShowLifecycleLog(boolean showLifecycleLog) {
            this.showLifecycleLog = showLifecycleLog;
            return this;
        }

        public Builder setTag(Object object) {
            android.support.v4.app.Fragment fragment;
            if (object instanceof Activity) {
                Activity activity = (Activity)object;
                this.tag = activity.getClass();
            }
            if (object instanceof android.support.v4.app.Fragment) {
                fragment = (android.support.v4.app.Fragment)object;
                this.tag = fragment.getActivity().getClass();
            }
            if (object instanceof Fragment) {
                fragment = (Fragment)object;
                this.tag = fragment.getActivity().getClass();
            }
            return this;
        }

        public Builder setDownloadFileDir(String downloadFileDir) {
            this.downloadFileDir = downloadFileDir;
            return this;
        }

        public Builder setCookieJar(CookieJar cookieJar) {
            if (null != cookieJar) {
                this.cookieJar = cookieJar;
            }
            return this;
        }
    }
}

