/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.progress;

import android.os.Message;
import android.util.Log;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.ProgressMessage;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody originalResponseBody;
    private final ProgressCallback progressCallback;
    private BufferedSource bufferedSink;
    private DownloadFileInfo downloadFileInfo;

    public ProgressResponseBody(ResponseBody originalResponseBody, ProgressCallback progressCallback) {
        this.originalResponseBody = originalResponseBody;
        this.progressCallback = progressCallback;
    }

    public ProgressResponseBody(ResponseBody originalResponseBody, ProgressCallback progressCallback, DownloadFileInfo downloadFileInfo) {
        this.originalResponseBody = originalResponseBody;
        this.progressCallback = progressCallback;
        this.downloadFileInfo = downloadFileInfo;
    }

    public long contentLength() {
        return this.originalResponseBody.contentLength();
    }

    public MediaType contentType() {
        return this.originalResponseBody.contentType();
    }

    public BufferedSource source() {
        if (this.bufferedSink == null) {
            this.bufferedSink = Okio.buffer((Source)this.source((Source)this.originalResponseBody.source()));
        }
        return this.bufferedSink;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            long contentLength;
            {
                this.totalBytesRead = 0L;
                this.contentLength = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                if (this.totalBytesRead == 0L) {
                    this.totalBytesRead = ProgressResponseBody.this.downloadFileInfo.getCompletedSize();
                    Log.d((String)"ProgressResponseBody", (String)("\u4ece\u8282\u70b9[" + this.totalBytesRead + "]\u5f00\u59cb\u4e0b\u8f7d"));
                }
                if (this.contentLength == 0L) {
                    this.contentLength = ProgressResponseBody.this.contentLength() + this.totalBytesRead;
                }
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (null != ProgressResponseBody.this.progressCallback) {
                    int percent = (int)(100L * this.totalBytesRead / this.contentLength);
                    ProgressResponseBody.this.progressCallback.onProgressAsync(percent, this.totalBytesRead, this.contentLength, this.totalBytesRead == -1L);
                    Message msg = new ProgressMessage(2, ProgressResponseBody.this.progressCallback, percent, this.totalBytesRead, this.contentLength, bytesRead == -1L).build();
                    OkMainHandler.getInstance().sendMessage(msg);
                }
                return bytesRead;
            }
        };
    }
}

