/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.app.Activity;
import android.app.Fragment;
import android.text.TextUtils;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.ProgressCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpInfo {
    private String url;
    private Map<String, String> params;
    private List<UploadFileInfo> uploadFile;
    private List<DownloadFileInfo> downloadFile;
    private int retCode;
    private String retDetail;
    private Class<?> tag;
    final int NonNetwork = 1;
    final String NonNetwork_Detail = "\u7f51\u7edc\u4e2d\u65ad";
    final int SUCCESS = 2;
    final String SUCCESS_Detail = "\u53d1\u9001\u8bf7\u6c42\u6210\u529f";
    final int ProtocolException = 3;
    final String ProtocolException_Detail = "\u8bf7\u68c0\u67e5\u534f\u8bae\u7c7b\u578b\u662f\u5426\u6b63\u786e";
    final int NoResult = 4;
    final String NoResult_Detail = "\u65e0\u6cd5\u83b7\u53d6\u8fd4\u56de\u4fe1\u606f(\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef)";
    final int CheckURL = 5;
    final String CheckURL_Detail = "\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e";
    final int CheckNet = 6;
    final String CheckNet_Detail = "\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38";
    final int ConnectionTimeOut = 7;
    final String ConnectionTimeOut_Detail = "\u8fde\u63a5\u8d85\u65f6";
    final int WriteAndReadTimeOut = 8;
    final String WriteAndReadTimeOut_Detail = "\u8bfb\u5199\u8d85\u65f6";
    final int ConnectionInterruption = 9;
    final String ConnectionInterruption_Detail = "\u8fde\u63a5\u4e2d\u65ad";
    final int NetworkOnMainThreadException = 10;
    final String NetworkOnMainThreadException_Detail = "\u4e0d\u5141\u8bb8\u5728UI\u7ebf\u7a0b\u4e2d\u8fdb\u884c\u7f51\u7edc\u64cd\u4f5c";

    public HttpInfo newFromCopy() {
        return HttpInfo.Builder().setUrl(this.url).addParams(this.params).addDownloadFiles(this.downloadFile).addUploadFiles(this.uploadFile).setTag(this.tag).build();
    }

    public HttpInfo(Builder builder) {
        this.url = builder.url;
        this.params = builder.params;
        this.tag = builder.tag;
        this.uploadFile = builder.uploadFile;
        this.downloadFile = builder.downloadFile;
    }

    public static Builder Builder() {
        return new Builder();
    }

    public HttpInfo packInfo(int retCode, String retDetail) {
        this.retCode = retCode;
        switch (retCode) {
            case 1: {
                this.retDetail = "\u7f51\u7edc\u4e2d\u65ad";
                break;
            }
            case 2: {
                this.retDetail = "\u53d1\u9001\u8bf7\u6c42\u6210\u529f";
                break;
            }
            case 3: {
                this.retDetail = "\u8bf7\u68c0\u67e5\u534f\u8bae\u7c7b\u578b\u662f\u5426\u6b63\u786e";
                break;
            }
            case 4: {
                this.retDetail = "\u65e0\u6cd5\u83b7\u53d6\u8fd4\u56de\u4fe1\u606f(\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef)";
                break;
            }
            case 5: {
                this.retDetail = "\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e";
                break;
            }
            case 6: {
                this.retDetail = "\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38";
                break;
            }
            case 7: {
                this.retDetail = "\u8fde\u63a5\u8d85\u65f6";
                break;
            }
            case 8: {
                this.retDetail = "\u8bfb\u5199\u8d85\u65f6";
                break;
            }
            case 9: {
                this.retDetail = "\u8fde\u63a5\u4e2d\u65ad";
                break;
            }
            case 10: {
                this.retDetail = "\u4e0d\u5141\u8bb8\u5728UI\u7ebf\u7a0b\u4e2d\u8fdb\u884c\u7f51\u7edc\u64cd\u4f5c";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)retDetail)) {
            this.retDetail = retDetail;
        }
        return this;
    }

    public boolean isSuccessful() {
        return this.retCode == 2;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRetDetail() {
        return this.retDetail;
    }

    public void setRetDetail(String retDetail) {
        this.retDetail = retDetail;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Class<?> getTag() {
        return this.tag;
    }

    public List<UploadFileInfo> getUploadFile() {
        return this.uploadFile;
    }

    public List<DownloadFileInfo> getDownloadFile() {
        return this.downloadFile;
    }

    public static final class Builder {
        private String url;
        private Map<String, String> params;
        private List<UploadFileInfo> uploadFile;
        private List<DownloadFileInfo> downloadFile;
        private Class<?> tag;

        public HttpInfo build(Object object) {
            this.setTag(object);
            return new HttpInfo(this);
        }

        public HttpInfo build() {
            return new HttpInfo(this);
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder addParams(Map<String, String> params) {
            if (null == params) {
                return this;
            }
            if (null == this.params) {
                this.params = params;
            } else {
                this.params.putAll(params);
            }
            return this;
        }

        public Builder addParam(String key, String value) {
            if (null == this.params) {
                this.params = new HashMap<String, String>();
            }
            if (!TextUtils.isEmpty((CharSequence)key)) {
                this.params.put(key, value);
            }
            return this;
        }

        public Builder addUploadFile(String interfaceParamName, String filePathWithName) {
            this.addUploadFile(filePathWithName, interfaceParamName, null);
            return this;
        }

        public Builder addUploadFile(String interfaceParamName, String filePathWithName, ProgressCallback progressCallback) {
            if (null == this.uploadFile) {
                this.uploadFile = new ArrayList<UploadFileInfo>();
            }
            if (!TextUtils.isEmpty((CharSequence)filePathWithName)) {
                this.uploadFile.add(new UploadFileInfo(filePathWithName, interfaceParamName, progressCallback));
            }
            return this;
        }

        public Builder addUploadFile(String url, String interfaceParamName, String filePathWithName, ProgressCallback progressCallback) {
            if (null == this.uploadFile) {
                this.uploadFile = new ArrayList<UploadFileInfo>();
            }
            if (!TextUtils.isEmpty((CharSequence)filePathWithName)) {
                this.uploadFile.add(new UploadFileInfo(url, filePathWithName, interfaceParamName, progressCallback));
            }
            return this;
        }

        public Builder addUploadFiles(List<UploadFileInfo> uploadFile) {
            if (null == uploadFile) {
                return this;
            }
            if (null == this.uploadFile) {
                this.uploadFile = uploadFile;
            } else {
                this.uploadFile.addAll(uploadFile);
            }
            return this;
        }

        public Builder addDownloadFile(String url, String saveFileName) {
            this.addDownloadFile(url, null, saveFileName, null);
            return this;
        }

        public Builder addDownloadFile(String url, String saveFileName, ProgressCallback progressCallback) {
            this.addDownloadFile(url, null, saveFileName, progressCallback);
            return this;
        }

        public Builder addDownloadFile(String url, String saveFileDir, String saveFileName, ProgressCallback progressCallback) {
            if (null == this.downloadFile) {
                this.downloadFile = new ArrayList<DownloadFileInfo>();
            }
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.downloadFile.add(new DownloadFileInfo(url, saveFileDir, saveFileName, progressCallback));
            }
            return this;
        }

        public Builder addDownloadFiles(List<DownloadFileInfo> downloadFile) {
            if (null == downloadFile) {
                return this;
            }
            if (null == this.downloadFile) {
                this.downloadFile = downloadFile;
            } else {
                this.downloadFile.addAll(downloadFile);
            }
            return this;
        }

        public Builder setTag(Object object) {
            android.support.v4.app.Fragment fragment;
            if (object instanceof Activity) {
                Activity activity = (Activity)object;
                this.tag = activity.getClass();
            }
            if (object instanceof android.support.v4.app.Fragment) {
                fragment = (android.support.v4.app.Fragment)object;
                this.tag = fragment.getActivity().getClass();
            }
            if (object instanceof Fragment) {
                fragment = (Fragment)object;
                this.tag = fragment.getActivity().getClass();
            }
            return this;
        }
    }
}

