/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.bean.ProgressMessage;
import com.okhttplib.bean.UploadMessage;

public class OkMainHandler
extends Handler {
    private static OkMainHandler singleton;
    public static final int RESPONSE_CALLBACK = 1;
    public static final int PROGRESS_CALLBACK = 2;
    public static final int RESPONSE_UPLOAD_CALLBACK = 3;
    public static final int RESPONSE_DOWNLOAD_CALLBACK = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkMainHandler getInstance() {
        if (null != singleton) return singleton;
        Class<OkMainHandler> clazz = OkMainHandler.class;
        synchronized (OkMainHandler.class) {
            if (null != singleton) return singleton;
            singleton = new OkMainHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public OkMainHandler() {
        super(Looper.getMainLooper());
    }

    public void handleMessage(Message msg) {
        int what = msg.what;
        try {
            switch (what) {
                case 1: {
                    CallbackMessage callMsg = (CallbackMessage)msg.obj;
                    if (null != callMsg.callback) {
                        callMsg.callback.onResponse(callMsg.info);
                    }
                    break;
                }
                case 2: {
                    ProgressMessage proMsg = (ProgressMessage)msg.obj;
                    if (null != proMsg.progressCallback) {
                        proMsg.progressCallback.onProgressMain(proMsg.percent, proMsg.bytesWritten, proMsg.contentLength, proMsg.done);
                    }
                    break;
                }
                case 3: {
                    UploadMessage uploadMsg = (UploadMessage)msg.obj;
                    if (null != uploadMsg.progressCallback) {
                        uploadMsg.progressCallback.onResponse(uploadMsg.filePath, uploadMsg.info);
                    }
                    break;
                }
                case 4: {
                    DownloadMessage downloadMsg = (DownloadMessage)msg.obj;
                    if (null != downloadMsg) {
                        downloadMsg.progressCallback.onResponse(downloadMsg.filePath, downloadMsg.info);
                    }
                    break;
                }
                default: {
                    super.handleMessage(msg);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

