/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Message;
import android.support.annotation.IntDef;
import android.text.TextUtils;
import android.util.Log;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.bean.UploadMessage;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.CallbackOk;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.progress.ProgressRequestBody;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    private final String TAG = this.getClass().getSimpleName();
    private static Application application;
    private static OkHttpClient httpClient;
    private static Builder builderGlobal;
    private int cacheLevel;
    private int cacheType;
    private int cacheSurvivalTime;
    private Class<?> tag;
    private boolean showHttpLog;
    private long timeStamp;
    private ExecutorService executorService;
    private Interceptor CACHE_CONTROL_NETWORK_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response.Builder resBuilder = chain.proceed(chain.request()).newBuilder();
            resBuilder.removeHeader("Pragma").header("Cache-Control", String.format("max-age=%d", OkHttpUtil.this.cacheSurvivalTime));
            return resBuilder.build();
        }
    };
    private Interceptor CACHE_CONTROL_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            switch (OkHttpUtil.this.cacheType) {
                case 2: {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                    break;
                }
                case 1: {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    break;
                }
                case 3: {
                    if (!OkHttpUtil.this.isNetworkAvailable((Context)application)) {
                        request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        break;
                    }
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    break;
                }
                case 4: {
                    if (OkHttpUtil.this.isNetworkAvailable((Context)application)) break;
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                }
            }
            return chain.proceed(request);
        }
    };
    private Interceptor LOG_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            long startTime = System.currentTimeMillis();
            OkHttpUtil.this.showLog(String.format("%s-URL: %s %n", chain.request().method(), chain.request().url()));
            Response res = chain.proceed(chain.request());
            long endTime = System.currentTimeMillis();
            OkHttpUtil.this.showLog(String.format("CostTime: %.1fs", (double)(endTime - startTime) / 1000.0));
            return res;
        }
    };
    private final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final int POST = 1;
    private static final int GET = 2;
    public static final int FIRST_LEVEL = 1;
    public static final int SECOND_LEVEL = 2;
    public static final int THIRD_LEVEL = 3;
    public static final int FOURTH_LEVEL = 4;
    public static final int FORCE_NETWORK = 1;
    public static final int FORCE_CACHE = 2;
    public static final int NETWORK_THEN_CACHE = 3;
    public static final int CACHE_THEN_NETWORK = 4;

    public static Builder init(Application context) {
        application = context;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new BaseActivityLifecycleCallbacks());
        return OkHttpUtil.BuilderGlobal();
    }

    public static OkHttpUtil getDefault() {
        return new Builder(false).build();
    }

    public static OkHttpUtil getDefault(Object object) {
        return new Builder(false).build(object);
    }

    public HttpInfo doPostSync(HttpInfo info) {
        return this.doRequestSync(info, 1, null);
    }

    public HttpInfo doGetSync(HttpInfo info) {
        return this.doRequestSync(info, 2, null);
    }

    public void doPostAsync(HttpInfo info, CallbackOk callback) {
        this.doRequestAsync(info, 1, callback, null);
    }

    public void doGetAsync(HttpInfo info, CallbackOk callback) {
        this.doRequestAsync(info, 2, callback, null);
    }

    public void doUploadFile(final HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFile();
        for (final UploadFileInfo fileInfo : uploadFiles) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpUtil.this.uploadFile(fileInfo, info);
                }
            });
        }
    }

    private void uploadFile(UploadFileInfo fileInfo, HttpInfo info) {
        String filePath = fileInfo.getFilePathWithName();
        String interfaceParamName = fileInfo.getInterfaceParamName();
        String url = fileInfo.getUrl();
        String string = url = TextUtils.isEmpty((CharSequence)url) ? info.getUrl() : url;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.showLog("\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a[" + filePath + "]");
            return;
        }
        ProgressCallback progressCallback = fileInfo.getProgressCallback();
        File file = new File(filePath);
        MultipartBody.Builder mBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        StringBuilder log = new StringBuilder("PostParams: ");
        log.append(interfaceParamName + "=" + filePath);
        if (null != info.getParams() && !info.getParams().isEmpty()) {
            for (String key : info.getParams().keySet()) {
                mBuilder.addFormDataPart(key, info.getParams().get(key));
                String logInfo = key + " =" + info.getParams().get(key) + ", ";
                log.append(logInfo);
            }
        }
        this.showLog(log.toString());
        mBuilder.addFormDataPart(interfaceParamName, file.getName(), RequestBody.create(null, (File)file));
        MultipartBody requestBody = mBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)new ProgressRequestBody((RequestBody)requestBody, progressCallback)).build();
        this.doRequestSync(info, 1, request);
        Message msg = new UploadMessage(3, filePath, info, progressCallback).build();
        OkMainHandler.getInstance().sendMessage(msg);
    }

    public void doDownloadFile(HttpInfo info, CallbackOk callback) {
        if (TextUtils.isEmpty((CharSequence)info.getUrl())) {
            this.showLog("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private HttpInfo doRequestSync(HttpInfo info, int method, Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doRequestAsync(final HttpInfo info, int method, final CallbackOk callback, Request request) {
        if (null == callback) {
            throw new NullPointerException("CallbackOk is null that not allowed");
        }
        Call call = httpClient.newCall(request == null ? this.fetchRequest(info, method) : request);
        BaseActivityLifecycleCallbacks.putCall(this.tag, info, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpUtil.this.showLog(e.getMessage());
            }

            public void onResponse(Call call, Response res) throws IOException {
                Message msg = new CallbackMessage(1, callback, OkHttpUtil.this.dealResponse(info, res, call)).build();
                OkMainHandler.getInstance().sendMessage(msg);
                BaseActivityLifecycleCallbacks.cancelCall(OkHttpUtil.this.tag, info, call);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpInfo dealResponse(HttpInfo info, Response res, Call call) {
        try {
            if (null != res) {
                if (res.isSuccessful() && null != res.body()) {
                    HttpInfo httpInfo = this.retInfo(info, info.SUCCESS, res.body().string());
                    return httpInfo;
                }
                this.showLog("HttpStatus: " + res.code());
                if (res.code() == 404) {
                    HttpInfo httpInfo = this.retInfo(info, info.CheckURL);
                    return httpInfo;
                }
                if (res.code() == 500) {
                    HttpInfo httpInfo = this.retInfo(info, info.NoResult);
                    return httpInfo;
                }
                if (res.code() == 502) {
                    HttpInfo httpInfo = this.retInfo(info, info.CheckNet);
                    return httpInfo;
                }
                if (res.code() == 504) {
                    HttpInfo httpInfo = this.retInfo(info, info.CheckNet);
                    return httpInfo;
                }
            }
            HttpInfo httpInfo = this.retInfo(info, info.CheckURL);
            return httpInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpInfo httpInfo = this.retInfo(info, info.NoResult);
            return httpInfo;
        }
        finally {
            if (null != res) {
                res.close();
            }
        }
    }

    private Request fetchRequest(HttpInfo info, int method) {
        Request request;
        if (method == 1) {
            FormBody.Builder builder = new FormBody.Builder();
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                StringBuilder log = new StringBuilder("PostParams: ");
                for (String key : info.getParams().keySet()) {
                    builder.add(key, info.getParams().get(key));
                    String logInfo = key + " =" + info.getParams().get(key) + ", ";
                    log.append(logInfo);
                }
                this.showLog(log.toString());
            }
            if (null == info.getUploadFile() || !info.getUploadFile().isEmpty()) {
                // empty if block
            }
            request = new Request.Builder().url(info.getUrl()).post((RequestBody)builder.build()).build();
        } else {
            StringBuilder params = new StringBuilder();
            params.append(info.getUrl());
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                for (String name : info.getParams().keySet()) {
                    String logInfo = "&" + name + "=" + info.getParams().get(name);
                    params.append(logInfo);
                }
            }
            request = new Request.Builder().url(params.toString()).get().build();
        }
        return request;
    }

    private HttpInfo retInfo(HttpInfo info, int code) {
        this.retInfo(info, code, null);
        return info;
    }

    private HttpInfo retInfo(HttpInfo info, int code, String resDetail) {
        info.packInfo(code, resDetail);
        this.showLog("Response: " + info.getRetDetail());
        return info;
    }

    private boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo net = cm.getActiveNetworkInfo();
        return net != null && net.getState() == NetworkInfo.State.CONNECTED;
    }

    private OkHttpUtil(Builder builder) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)builder.connectTimeout, TimeUnit.SECONDS).readTimeout((long)builder.readTimeout, TimeUnit.SECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.SECONDS).cache(new Cache(builder.cachedDir, (long)builder.maxCacheSize)).retryOnConnectionFailure(builder.retryOnConnectionFailure).addInterceptor(this.CACHE_CONTROL_INTERCEPTOR).addNetworkInterceptor(this.CACHE_CONTROL_NETWORK_INTERCEPTOR);
        if (null != builder.networkInterceptors && !builder.networkInterceptors.isEmpty()) {
            clientBuilder.networkInterceptors().addAll(builder.networkInterceptors);
        }
        if (null != builder.interceptors && !builder.interceptors.isEmpty()) {
            clientBuilder.interceptors().addAll(builder.interceptors);
        }
        clientBuilder.addInterceptor(this.LOG_INTERCEPTOR);
        this.setSslSocketFactory(clientBuilder);
        httpClient = clientBuilder.build();
        this.timeStamp = System.currentTimeMillis();
        int deviation = 5;
        this.cacheLevel = builder.cacheLevel;
        this.cacheType = builder.cacheType;
        this.cacheSurvivalTime = builder.cacheSurvivalTime;
        this.tag = builder.tag;
        this.showHttpLog = builder.showHttpLog;
        if (this.cacheSurvivalTime == 0) {
            switch (this.cacheLevel) {
                case 1: {
                    this.cacheSurvivalTime = 0;
                    break;
                }
                case 2: {
                    this.cacheSurvivalTime = 20;
                    break;
                }
                case 3: {
                    this.cacheSurvivalTime = 35;
                    break;
                }
                case 4: {
                    this.cacheSurvivalTime = 65;
                }
            }
        }
        if (this.cacheSurvivalTime > 0) {
            this.cacheType = 4;
        }
        BaseActivityLifecycleCallbacks.setShowLifecycleLog(builder.showLifecycleLog);
        this.executorService = Executors.newCachedThreadPool();
    }

    private void setSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        clientBuilder.hostnameVerifier(this.DO_NOT_VERIFY);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            clientBuilder.sslSocketFactory(sc.getSocketFactory(), trustManager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Builder Builder() {
        return new Builder(false);
    }

    private static Builder BuilderGlobal() {
        return new Builder(true);
    }

    private void showLog(String msg) {
        if (this.showHttpLog) {
            Log.d((String)(this.TAG + "[" + this.timeStamp + "]"), (String)msg);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L, 4L})
    public static @interface CacheType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L, 4L})
    public static @interface CacheLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L})
    private static @interface Method {
    }

    public static final class Builder {
        private int maxCacheSize;
        private File cachedDir;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private boolean retryOnConnectionFailure;
        private List<Interceptor> networkInterceptors;
        private List<Interceptor> interceptors;
        private int cacheSurvivalTime;
        private int cacheType;
        private int cacheLevel;
        private boolean isGlobalConfig;
        private boolean showHttpLog;
        private boolean showLifecycleLog;
        private Class<?> tag;

        public Builder() {
        }

        public Builder(boolean isGlobal) {
            this.isGlobalConfig = isGlobal;
            this.initDefaultConfig();
            if (!isGlobal && null != builderGlobal) {
                this.initGlobalConfig(builderGlobal);
            }
        }

        public OkHttpUtil build() {
            return this.build(null);
        }

        public OkHttpUtil build(Object object) {
            if (this.isGlobalConfig && null == builderGlobal) {
                builderGlobal = this;
            }
            if (null != object) {
                this.setTag(object);
            }
            return new OkHttpUtil(this);
        }

        private void initDefaultConfig() {
            this.setMaxCacheSize(0xA00000);
            this.setCachedDir(application.getExternalCacheDir());
            this.setConnectTimeout(30);
            this.setReadTimeout(30);
            this.setWriteTimeout(30);
            this.setRetryOnConnectionFailure(true);
            this.setCacheSurvivalTime(0);
            this.setCacheType(3);
            this.setCacheLevel(1);
            this.setNetworkInterceptors(null);
            this.setInterceptors(null);
            this.setShowHttpLog(true);
            this.setShowLifecycleLog(false);
        }

        private void initGlobalConfig(Builder builder) {
            this.setMaxCacheSize(builder.maxCacheSize);
            this.setCachedDir(builder.cachedDir);
            this.setConnectTimeout(builder.connectTimeout);
            this.setReadTimeout(builder.readTimeout);
            this.setWriteTimeout(builder.writeTimeout);
            this.setRetryOnConnectionFailure(builder.retryOnConnectionFailure);
            this.setCacheSurvivalTime(builder.cacheSurvivalTime);
            this.setCacheType(builder.cacheType);
            this.setCacheLevel(builder.cacheLevel);
            this.setNetworkInterceptors(builder.networkInterceptors);
            this.setInterceptors(builder.interceptors);
            this.setShowHttpLog(builder.showHttpLog);
            this.setShowLifecycleLog(builder.showLifecycleLog);
        }

        public Builder setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setCachedDir(File cachedDir) {
            if (null != cachedDir) {
                this.cachedDir = cachedDir;
            }
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("connectTimeout must be > 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(int writeTimeout) {
            if (writeTimeout <= 0) {
                throw new IllegalArgumentException("writeTimeout must be > 0");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder setNetworkInterceptors(List<Interceptor> networkInterceptors) {
            if (null != networkInterceptors) {
                this.networkInterceptors = networkInterceptors;
            }
            return this;
        }

        public Builder setInterceptors(List<Interceptor> interceptors) {
            if (null != interceptors) {
                this.interceptors = interceptors;
            }
            return this;
        }

        public Builder setCacheSurvivalTime(int cacheSurvivalTime) {
            if (cacheSurvivalTime < 0) {
                throw new IllegalArgumentException("cacheSurvivalTime must be >= 0");
            }
            this.cacheSurvivalTime = cacheSurvivalTime;
            return this;
        }

        public Builder setCacheType(int cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setCacheLevel(int cacheLevel) {
            this.cacheLevel = cacheLevel;
            return this;
        }

        public Builder setShowHttpLog(boolean showHttpLog) {
            this.showHttpLog = showHttpLog;
            return this;
        }

        public Builder setShowLifecycleLog(boolean showLifecycleLog) {
            this.showLifecycleLog = showLifecycleLog;
            return this;
        }

        public Builder setTag(Object object) {
            android.support.v4.app.Fragment fragment;
            if (object instanceof Activity) {
                Activity activity = (Activity)object;
                this.tag = activity.getClass();
            }
            if (object instanceof android.support.v4.app.Fragment) {
                fragment = (android.support.v4.app.Fragment)object;
                this.tag = fragment.getActivity().getClass();
            }
            if (object instanceof Fragment) {
                fragment = (Fragment)object;
                this.tag = fragment.getActivity().getClass();
            }
            return this;
        }
    }
}

