/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
public class GraphqlYearMonthCoercing
implements Coercing<YearMonth, String> {
    private static final Pattern YEAR_MONTH_PATTERN = Pattern.compile("(\\d{1,4})-(\\d{1,2})");

    private YearMonth convertImpl(Object input) {
        if (input instanceof String) {
            Matcher m = YEAR_MONTH_PATTERN.matcher(input.toString());
            if (m.find()) {
                try {
                    return YearMonth.of(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                }
                catch (NumberFormatException | DateTimeException runtimeException) {}
            }
        } else if (input instanceof YearMonth) {
            return (YearMonth)input;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof YearMonth) {
            return input.toString();
        }
        YearMonth result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Invalid value '" + input + "' is not a valid YearMonth, please use format yyyy-MM");
        }
        return result.toString();
    }

    public YearMonth parseValue(Object input) {
        YearMonth result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Invalid value '" + input + "' is not a valid YearMonth, please use format yyyy-MM");
        }
        return result;
    }

    public YearMonth parseLiteral(Object input) {
        String value = ((StringValue)input).getValue();
        YearMonth result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException("Invalid value '" + input + "' is not a valid YearMonth, please use format yyyy-MM");
        }
        return result;
    }
}

