/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import com.zhokhov.graphql.datetime.DateTimeHelper;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

@Internal
public class GraphqlDateCoercing
implements Coercing<Date, String> {
    private final List<DateTimeFormatter> formatters = new CopyOnWriteArrayList<DateTimeFormatter>();

    public GraphqlDateCoercing() {
        this(Collections.emptyList());
    }

    public GraphqlDateCoercing(Collection<DateTimeFormatter> formatters) {
        this.formatters.addAll(formatters);
        this.initBasicFormatters();
    }

    private void initBasicFormatters() {
        this.formatters.add(DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC));
        this.formatters.add(DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC));
        this.formatters.add(DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC));
    }

    private Date convertImpl(Object input) {
        if (input instanceof String) {
            LocalDateTime localDateTime = this.parseDate((String)input);
            if (localDateTime != null) {
                return DateTimeHelper.toDate(localDateTime);
            }
        } else if (input instanceof Date) {
            return (Date)input;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof Date) {
            return DateTimeHelper.toISOString((Date)input);
        }
        Date result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Invalid value '" + input + "' for Date");
        }
        return DateTimeHelper.toISOString(result);
    }

    public Date parseValue(Object input) {
        Date result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Invalid value '" + input + "' for Date");
        }
        return result;
    }

    public Date parseLiteral(Object input) {
        String value = ((StringValue)input).getValue();
        Date result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException("Invalid value '" + input + "' for Date");
        }
        return result;
    }

    private LocalDateTime parseDate(String date) {
        Objects.requireNonNull(date, "date");
        for (DateTimeFormatter formatter : this.formatters) {
            try {
                if (formatter.equals(this.formatters.get(2))) {
                    LocalDate localDate = LocalDate.parse(date, formatter);
                    return localDate.atStartOfDay();
                }
                return LocalDateTime.parse(date, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }
}

