/*
 * Decompiled with CFR 0.152.
 */
package com.cosage.zzh.kotlin.PhotoView;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.cosage.zzh.kotlin.PhotoView.MyImageAdapter;
import com.cosage.zzh.kotlin.PhotoView.PhotoViewPager;
import com.cosage.zzh.kotlin.R;
import java.util.List;

public class PhotoViewActivity
extends Activity
implements View.OnClickListener {
    public static final String TAG = PhotoViewActivity.class.getSimpleName();
    private PhotoViewPager mViewPager;
    private int currentPosition;
    private MyImageAdapter adapter;
    private TextView tv_count;
    private List<String> Urls;
    private RelativeLayout rl_all;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activitiy_photo_view);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mViewPager = (PhotoViewPager)this.findViewById(R.id.view_pager_photo);
        this.tv_count = (TextView)this.findViewById(R.id.tv_count);
        this.rl_all = (RelativeLayout)this.findViewById(R.id.rl_all);
        this.rl_all.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoViewActivity.this.finish();
            }
        });
    }

    private void initData() {
        Intent intent = this.getIntent();
        this.currentPosition = intent.getIntExtra("currentPosition", 0);
        this.Urls = (List)((Object)intent.getSerializableExtra("data"));
        this.adapter = new MyImageAdapter(this.Urls, this);
        this.mViewPager.setAdapter(this.adapter);
        this.mViewPager.setCurrentItem(this.currentPosition, false);
        this.tv_count.setText((CharSequence)(this.currentPosition + 1 + "/" + this.Urls.size()));
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                PhotoViewActivity.this.currentPosition = position;
                PhotoViewActivity.this.tv_count.setText((CharSequence)(PhotoViewActivity.this.currentPosition + 1 + "/" + PhotoViewActivity.this.Urls.size()));
            }
        });
    }

    public void onClick(View view) {
        view.getId();
    }
}

