/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.content.FileProvider;
import android.support.v4.os.EnvironmentCompat;
import com.zhihu.matisse.internal.entity.CaptureStrategy;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MediaStoreCompat {
    private final WeakReference<Activity> mContext;
    private final WeakReference<Fragment> mFragment;
    private CaptureStrategy mCaptureStrategy;
    private Uri mCurrentPhotoUri;
    private String mCurrentPhotoPath;

    public MediaStoreCompat(Activity activity) {
        this.mContext = new WeakReference<Activity>(activity);
        this.mFragment = null;
    }

    public MediaStoreCompat(Activity activity, Fragment fragment) {
        this.mContext = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public static boolean hasCameraFeature(Context context) {
        PackageManager pm = context.getApplicationContext().getPackageManager();
        return pm.hasSystemFeature("android.hardware.camera");
    }

    public void setCaptureStrategy(CaptureStrategy strategy) {
        this.mCaptureStrategy = strategy;
    }

    public void dispatchCaptureIntent(Context context, int requestCode) {
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (captureIntent.resolveActivity(context.getPackageManager()) != null) {
            File photoFile = null;
            try {
                photoFile = this.createImageFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (photoFile != null) {
                this.mCurrentPhotoPath = photoFile.getAbsolutePath();
                this.mCurrentPhotoUri = FileProvider.getUriForFile((Context)((Context)this.mContext.get()), (String)this.mCaptureStrategy.authority, (File)photoFile);
                captureIntent.putExtra("output", (Parcelable)this.mCurrentPhotoUri);
                captureIntent.addFlags(2);
                if (Build.VERSION.SDK_INT < 21) {
                    List resInfoList = context.getPackageManager().queryIntentActivities(captureIntent, 65536);
                    for (ResolveInfo resolveInfo : resInfoList) {
                        String packageName = resolveInfo.activityInfo.packageName;
                        context.grantUriPermission(packageName, this.mCurrentPhotoUri, 3);
                    }
                }
                if (this.mFragment != null) {
                    ((Fragment)this.mFragment.get()).startActivityForResult(captureIntent, requestCode);
                } else {
                    ((Activity)this.mContext.get()).startActivityForResult(captureIntent, requestCode);
                }
            }
        }
    }

    private File createImageFile() throws IOException {
        File tempFile;
        File storageDir;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String imageFileName = String.format("JPEG_%s.jpg", timeStamp);
        if (this.mCaptureStrategy.isPublic) {
            storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
        } else {
            storageDir = ((Activity)this.mContext.get()).getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        }
        if (this.mCaptureStrategy.directory != null && !(storageDir = new File(storageDir, this.mCaptureStrategy.directory)).exists()) {
            storageDir.mkdirs();
        }
        if (!"mounted".equals(EnvironmentCompat.getStorageState((File)(tempFile = new File(storageDir, imageFileName))))) {
            return null;
        }
        return tempFile;
    }

    public Uri getCurrentPhotoUri() {
        return this.mCurrentPhotoUri;
    }

    public String getCurrentPhotoPath() {
        return this.mCurrentPhotoPath;
    }
}

