/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.zhihu.matisse.R;

public class CheckRadioView
extends AppCompatImageView {
    private Drawable mDrawable;
    private int mSelectedColor;
    private int mUnSelectUdColor;

    public CheckRadioView(Context context) {
        super(context);
        this.init();
    }

    public CheckRadioView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mSelectedColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.zhihu_item_checkCircle_backgroundColor, (Resources.Theme)this.getContext().getTheme());
        this.mUnSelectUdColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.zhihu_check_original_radio_disable, (Resources.Theme)this.getContext().getTheme());
        this.setChecked(false);
    }

    public void setChecked(boolean enable) {
        if (enable) {
            this.setImageResource(R.drawable.ic_preview_radio_on);
            this.mDrawable = this.getDrawable();
            this.mDrawable.setColorFilter(this.mSelectedColor, PorterDuff.Mode.SRC_IN);
        } else {
            this.setImageResource(R.drawable.ic_preview_radio_off);
            this.mDrawable = this.getDrawable();
            this.mDrawable.setColorFilter(this.mUnSelectUdColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public void setColor(int color2) {
        if (this.mDrawable == null) {
            this.mDrawable = this.getDrawable();
        }
        this.mDrawable.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
    }
}

