/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.entity;

import android.content.ContentUris;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import com.zhihu.matisse.MimeType;

public class Item
implements Parcelable {
    public static final Parcelable.Creator<Item> CREATOR = new Parcelable.Creator<Item>(){

        @Nullable
        public Item createFromParcel(Parcel source) {
            return new Item(source);
        }

        public Item[] newArray(int size) {
            return new Item[size];
        }
    };
    public static final long ITEM_ID_CAPTURE = -1L;
    public static final String ITEM_DISPLAY_NAME_CAPTURE = "Capture";
    public final long id;
    public final String mimeType;
    public final Uri uri;
    public final long size;
    public final long duration;

    private Item(long id, String mimeType, long size, long duration) {
        this.id = id;
        this.mimeType = mimeType;
        Uri contentUri = this.isImage() ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (this.isVideo() ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Files.getContentUri((String)"external"));
        this.uri = ContentUris.withAppendedId((Uri)contentUri, (long)id);
        this.size = size;
        this.duration = duration;
    }

    private Item(Parcel source) {
        this.id = source.readLong();
        this.mimeType = source.readString();
        this.uri = (Uri)source.readParcelable(Uri.class.getClassLoader());
        this.size = source.readLong();
        this.duration = source.readLong();
    }

    public static Item valueOf(Cursor cursor) {
        return new Item(cursor.getLong(cursor.getColumnIndex("_id")), cursor.getString(cursor.getColumnIndex("mime_type")), cursor.getLong(cursor.getColumnIndex("_size")), cursor.getLong(cursor.getColumnIndex("duration")));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.mimeType);
        dest.writeParcelable((Parcelable)this.uri, 0);
        dest.writeLong(this.size);
        dest.writeLong(this.duration);
    }

    public Uri getContentUri() {
        return this.uri;
    }

    public boolean isCapture() {
        return this.id == -1L;
    }

    public boolean isImage() {
        return MimeType.isImage(this.mimeType);
    }

    public boolean isGif() {
        return MimeType.isGif(this.mimeType);
    }

    public boolean isVideo() {
        return MimeType.isVideo(this.mimeType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        return this.id == other.id && (this.mimeType != null && this.mimeType.equals(other.mimeType) || this.mimeType == null && other.mimeType == null) && (this.uri != null && this.uri.equals((Object)other.uri) || this.uri == null && other.uri == null) && this.size == other.size && this.duration == other.duration;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Long.valueOf(this.id).hashCode();
        if (this.mimeType != null) {
            result = 31 * result + this.mimeType.hashCode();
        }
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + Long.valueOf(this.size).hashCode();
        result = 31 * result + Long.valueOf(this.duration).hashCode();
        return result;
    }
}

