/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse;

import android.content.ContentResolver;
import android.net.Uri;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.zhihu.matisse.internal.utils.PhotoMetadataUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public enum MimeType {
    JPEG("image/jpeg", MimeType.arraySetOf("jpg", "jpeg")),
    PNG("image/png", MimeType.arraySetOf("png")),
    GIF("image/gif", MimeType.arraySetOf("gif")),
    BMP("image/x-ms-bmp", MimeType.arraySetOf("bmp")),
    WEBP("image/webp", MimeType.arraySetOf("webp")),
    MPEG("video/mpeg", MimeType.arraySetOf("mpeg", "mpg")),
    MP4("video/mp4", MimeType.arraySetOf("mp4", "m4v")),
    QUICKTIME("video/quicktime", MimeType.arraySetOf("mov")),
    THREEGPP("video/3gpp", MimeType.arraySetOf("3gp", "3gpp")),
    THREEGPP2("video/3gpp2", MimeType.arraySetOf("3g2", "3gpp2")),
    MKV("video/x-matroska", MimeType.arraySetOf("mkv")),
    WEBM("video/webm", MimeType.arraySetOf("webm")),
    TS("video/mp2ts", MimeType.arraySetOf("ts")),
    AVI("video/avi", MimeType.arraySetOf("avi"));

    private final String mMimeTypeName;
    private final Set<String> mExtensions;

    private MimeType(String mimeTypeName, Set<String> extensions) {
        this.mMimeTypeName = mimeTypeName;
        this.mExtensions = extensions;
    }

    public static Set<MimeType> ofAll() {
        return EnumSet.allOf(MimeType.class);
    }

    public static Set<MimeType> of(MimeType type, MimeType ... rest) {
        return EnumSet.of(type, rest);
    }

    public static Set<MimeType> ofImage() {
        return EnumSet.of(JPEG, PNG, GIF, BMP, WEBP);
    }

    public static Set<MimeType> ofVideo() {
        return EnumSet.of(MPEG, new MimeType[]{MP4, QUICKTIME, THREEGPP, THREEGPP2, MKV, WEBM, TS, AVI});
    }

    public static boolean isImage(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("image");
    }

    public static boolean isVideo(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("video");
    }

    public static boolean isGif(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals(GIF.toString());
    }

    private static Set<String> arraySetOf(String ... suffixes) {
        return new ArraySet(Arrays.asList(suffixes));
    }

    public String toString() {
        return this.mMimeTypeName;
    }

    public boolean checkType(ContentResolver resolver, Uri uri) {
        MimeTypeMap map = MimeTypeMap.getSingleton();
        if (uri == null) {
            return false;
        }
        String type = map.getExtensionFromMimeType(resolver.getType(uri));
        String path = null;
        boolean pathParsed = false;
        for (String extension : this.mExtensions) {
            if (extension.equals(type)) {
                return true;
            }
            if (!pathParsed) {
                path = PhotoMetadataUtils.getPath(resolver, uri);
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    path = path.toLowerCase(Locale.US);
                }
                pathParsed = true;
            }
            if (path == null || !path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

