/*
 * Decompiled with CFR 0.152.
 */
package com.zhg.custom.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import com.zhg.custom.R;

public class LoopImageView
extends View {
    private Bitmap mSourceBitmap;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private boolean mRunningFlag = false;
    private Paint mPaint;
    private int offset = 0;
    private int mMoveUnit = 1;
    private Bitmap mRawBitmap;
    private Bitmap mClipBitmap;
    private Handler mHander = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                LoopImageView.this.invalidate();
            }
        }
    };

    public LoopImageView(Context context) {
        super(context);
        this.init();
    }

    public LoopImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoopImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = null;
        Drawable src = null;
        try {
            a = context.obtainStyledAttributes(attrs, R.styleable.LoopImageView);
            src = a.getDrawable(R.styleable.LoopImageView_src);
            this.mMoveUnit = a.getInt(R.styleable.LoopImageView_move_speed, 1);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        if (src != null) {
            if (src instanceof BitmapDrawable) {
                BitmapDrawable d = (BitmapDrawable)src;
                this.mSourceBitmap = d.getBitmap();
            } else {
                throw new IllegalArgumentException("src must be a Bitmap!");
            }
        }
        this.init();
    }

    public void setBitmap(Bitmap bitmap) {
        this.mSourceBitmap = bitmap;
        this.init();
        this.requestLayout();
    }

    public void setMoveSpeed(int speed) {
        this.mMoveUnit = speed;
    }

    private void init() {
        if (this.mSourceBitmap != null) {
            this.mBitmapWidth = this.mSourceBitmap.getWidth();
            this.mBitmapHeight = this.mSourceBitmap.getHeight();
            this.mRunningFlag = true;
            this.offset = 0;
            this.mPaint = new Paint();
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMeasureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMeasureMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (this.mBitmapWidth > 0 && this.mBitmapHeight > 0 && (widthMeasureMode != 0x40000000 || heightMeasureMode != 0x40000000)) {
            int width = this.mBitmapWidth;
            int height = this.mBitmapHeight;
            if (widthMeasureMode == Integer.MIN_VALUE) {
                width = Math.min(width, View.MeasureSpec.getSize((int)widthMeasureSpec));
            }
            if (heightMeasureMode == Integer.MIN_VALUE) {
                height = Math.min(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
            }
            this.setMeasuredDimension(width, height);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.recyclerTempBitmap();
        int left = this.getLeft();
        int right = this.getRight();
        int top = this.getTop();
        int bottom = this.getBottom();
        int tempWidth = right - left;
        if (this.offset >= this.mBitmapWidth) {
            this.offset = 0;
        }
        tempWidth = tempWidth + this.offset > this.mBitmapWidth ? this.mBitmapWidth - this.offset : tempWidth;
        this.mRawBitmap = Bitmap.createBitmap((Bitmap)this.mSourceBitmap, (int)this.offset, (int)0, (int)tempWidth, (int)Math.min(this.mBitmapHeight, bottom - top));
        canvas.drawBitmap(this.mRawBitmap, this.getMatrix(), this.mPaint);
        if (tempWidth < right - left) {
            Rect dst = new Rect(tempWidth, 0, right - left, Math.min(this.mBitmapHeight, bottom - top));
            this.mClipBitmap = Bitmap.createBitmap((Bitmap)this.mSourceBitmap, (int)0, (int)0, (int)(right - left - tempWidth), (int)Math.min(bottom - top, this.mBitmapHeight));
            canvas.drawBitmap(this.mClipBitmap, null, dst, this.mPaint);
        }
        this.offset += this.mMoveUnit;
        if (this.mRunningFlag) {
            this.mHander.sendEmptyMessageDelayed(0, 1L);
        }
    }

    public void onPause() {
        this.mRunningFlag = false;
    }

    public void onResume() {
        this.mRunningFlag = true;
        this.invalidate();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onPause();
        this.recyclerTempBitmap();
        this.mSourceBitmap.recycle();
    }

    private void recyclerTempBitmap() {
        if (this.mRawBitmap != null) {
            this.mRawBitmap.recycle();
            this.mRawBitmap = null;
        }
        if (this.mClipBitmap != null) {
            this.mClipBitmap.recycle();
            this.mClipBitmap = null;
        }
    }
}

