/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util.office;

import com.zhazhapan.util.Checker;
import com.zhazhapan.util.ReflectUtils;
import com.zhazhapan.util.office.MsUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;

public class MsWordUtils {
    private static Logger logger = Logger.getLogger(MsWordUtils.class);
    private static XWPFDocument xwpfDocument = null;

    private MsWordUtils() {
    }

    public static void createXwpfDocument() {
        xwpfDocument = new XWPFDocument();
    }

    public static void appendLine() {
        xwpfDocument.createParagraph().createRun();
    }

    public static void appendImage(String imagePath, int pictureType, int width, int height, ParagraphAlignment alignment) throws IOException, InvalidFormatException {
        MsWordUtils.appendImage(MsWordUtils.getNewRun(alignment), imagePath, pictureType, width, height);
    }

    public static void appendImage(XWPFRun run, String imagePath, int pictureType, int width, int height) throws IOException, InvalidFormatException {
        FileInputStream input = new FileInputStream(imagePath);
        run.addPicture((InputStream)input, pictureType, imagePath, Units.toEMU((double)width), Units.toEMU((double)height));
    }

    public static XWPFRun getNewRun(ParagraphAlignment alignment) {
        MsWordUtils.createXwpfDocumentIfNull();
        XWPFParagraph paragraph = xwpfDocument.createParagraph();
        paragraph.setAlignment(alignment);
        return paragraph.createRun();
    }

    public static XWPFRun getNewRunOfParagraph(int paragraphIndex) {
        return MsWordUtils.getParagraph(paragraphIndex).createRun();
    }

    public static XWPFRun getRun(int paragraphIndex, int runIndex) {
        MsWordUtils.createXwpfDocumentIfNull();
        return (XWPFRun)((XWPFParagraph)xwpfDocument.getParagraphs().get(paragraphIndex)).getRuns().get(runIndex);
    }

    public static int getRunSize(int paragraphIndex) {
        return MsWordUtils.getParagraph(paragraphIndex).getRuns().size();
    }

    public static XWPFParagraph getParagraph(int paragraphIndex) {
        MsWordUtils.createXwpfDocumentIfNull();
        return (XWPFParagraph)xwpfDocument.getParagraphs().get(paragraphIndex);
    }

    public static int getParagraphSize() {
        return xwpfDocument.getParagraphs().size();
    }

    public static void appendTable(ParagraphAlignment[] alignment, int rows, int cols, String[][] values, int[] rowHeight, int[] colWidth, Map<String, Integer> cellMargins, Map<String, Object> styles) {
        MsWordUtils.createXwpfDocumentIfNull();
        xwpfDocument.createParagraph();
        XWPFTable table = xwpfDocument.createTable(rows, cols);
        if (Checker.isNotEmpty(cellMargins)) {
            int top = MsUtils.checkInteger(cellMargins.get("top"));
            int left = MsUtils.checkInteger(cellMargins.get("left"));
            int bottom = MsUtils.checkInteger(cellMargins.get("bottom"));
            int right = MsUtils.checkInteger(cellMargins.get("right"));
            table.setCellMargins(top, left, bottom, right);
        }
        int minRow = Math.min(rows, values.length);
        for (int i = 0; i < minRow; ++i) {
            XWPFTableRow row = table.getRow(i);
            int height = i < rowHeight.length ? rowHeight[i] : rowHeight[rowHeight.length - 1];
            row.setHeight(height);
            String[] value = values[i];
            int minCol = Math.min(cols, value.length);
            for (int j = 0; j < minCol; ++j) {
                XWPFTableCell cell = row.getCell(j);
                CTTcPr cellPr = cell.getCTTc().addNewTcPr();
                int width = j < colWidth.length ? colWidth[j] : colWidth[colWidth.length - 1];
                cellPr.addNewTcW().setW(BigInteger.valueOf(width));
                XWPFParagraph paragraph = (XWPFParagraph)cell.getParagraphs().get(0);
                int idx = i * cols + j;
                ParagraphAlignment align = idx < alignment.length ? alignment[idx] : alignment[alignment.length - 1];
                paragraph.setAlignment(align);
                XWPFRun run = paragraph.createRun();
                run.setText(value[j]);
                MsWordUtils.setStyle(run, styles);
            }
        }
    }

    public static void appendTable(ParagraphAlignment alignment, int rows, int cols, String[][] values, int rowHeight, int colWidth, Map<String, Integer> cellMargins, Map<String, Object> styles) {
        MsWordUtils.appendTable(new ParagraphAlignment[]{alignment}, rows, cols, values, new int[]{rowHeight}, new int[]{colWidth}, cellMargins, styles);
    }

    public static void writeTo(String path) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        MsWordUtils.createXwpfDocumentIfNull();
        MsUtils.writeTo(xwpfDocument, path);
    }

    public static void writeAndClose(String path) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        MsWordUtils.createXwpfDocumentIfNull();
        MsWordUtils.writeTo(path);
        xwpfDocument.close();
        xwpfDocument = new XWPFDocument();
    }

    public static void setXwpfDocument(String path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        xwpfDocument = new XWPFDocument((InputStream)is);
        ((InputStream)is).close();
    }

    public static void setStyle(XWPFRun run, Map<String, Object> styles) {
        if (Checker.isNotEmpty(styles)) {
            styles.forEach((key, value) -> {
                String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
                try {
                    ReflectUtils.invokeMethodUseBasicType(run, methodName, new Object[]{value});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error((Object)("set property " + key + " failed use method " + methodName + ", " + e.getMessage()));
                }
            });
        }
    }

    public static XWPFDocument getXwpfDocument() {
        MsWordUtils.createXwpfDocumentIfNull();
        return xwpfDocument;
    }

    public static void setXwpfDocument(XWPFDocument xwpfDocument) {
        MsWordUtils.xwpfDocument = xwpfDocument;
    }

    private static void createXwpfDocumentIfNull() {
        if (Checker.isNull(xwpfDocument)) {
            xwpfDocument = new XWPFDocument();
        }
    }
}

