/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util.office;

import com.zhazhapan.util.Checker;
import com.zhazhapan.util.office.MsUtils;
import com.zhazhapan.util.office.MsWordUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MsExcelUtils {
    private static Logger logger = Logger.getLogger(MsWordUtils.class);
    private static XSSFWorkbook xssfWorkbook = null;
    private static XSSFSheet xssfSheet = null;

    private MsExcelUtils() {
    }

    public static void createXssfWorkbook() {
        xssfWorkbook = new XSSFWorkbook();
    }

    public static void createXssfSheet(String sheetName) {
        MsExcelUtils.createXssfWorkbookIfNull();
        xssfSheet = xssfWorkbook.createSheet(sheetName);
    }

    public static void appendTable(String[][] values, HSSFCellStyle[][] styles) {
        MsExcelUtils.createXssfSheetIfNull();
        if (Checker.isNotNull(values)) {
            for (int i = 0; i < values.length; ++i) {
                XSSFRow row = xssfSheet.createRow(i);
                for (int j = 0; j < values[i].length; ++j) {
                    XSSFCell cell = row.createCell(j);
                    cell.setCellValue(values[i][j]);
                    if (!Checker.isNotNull(styles)) continue;
                    int rowIndex = i < styles.length ? i : styles.length - 1;
                    int colIndex = j < styles[rowIndex].length ? j : styles[rowIndex].length - 1;
                    cell.setCellStyle((CellStyle)styles[rowIndex][colIndex]);
                }
            }
        }
    }

    public static List<List<String>> readTable(int sheetIndex) {
        MsExcelUtils.setXssfSheet(xssfWorkbook.getSheetAt(sheetIndex));
        return MsExcelUtils.readTable();
    }

    public static List<List<String>> readTable(String sheetName) {
        MsExcelUtils.setXssfSheet(xssfWorkbook.getSheet(sheetName));
        return MsExcelUtils.readTable();
    }

    public static List<List<String>> readTable() {
        ArrayList<List<String>> values = new ArrayList<List<String>>(32);
        for (int i = 0; i < xssfSheet.getLastRowNum() + 1; ++i) {
            XSSFRow row = xssfSheet.getRow(i);
            if (!Checker.isNotNull(row)) continue;
            ArrayList<String> value = new ArrayList<String>(32);
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                XSSFCell cell = row.getCell(j);
                if (!Checker.isNotNull(cell)) continue;
                value.add(cell.getStringCellValue());
            }
            if (!Checker.isNotEmpty(value)) continue;
            values.add(value);
        }
        return values;
    }

    public static void writeTo(String path) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        MsUtils.writeTo(xssfWorkbook, path);
    }

    public static void writeAndClose(String path) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        MsExcelUtils.writeTo(path);
        xssfWorkbook.close();
        MsExcelUtils.createXssfWorkbook();
    }

    public static XSSFWorkbook getXssfWorkbook() {
        return xssfWorkbook;
    }

    public static void setXssfWorkbook(XSSFWorkbook xssfWorkbook) {
        MsExcelUtils.xssfWorkbook = xssfWorkbook;
    }

    public static void setXssfWorkbook(String path) throws IOException {
        xssfWorkbook = new XSSFWorkbook(path);
    }

    public static XSSFSheet getXssfSheet() {
        return xssfSheet;
    }

    public static void setXssfSheet(XSSFSheet xssfSheet) {
        MsExcelUtils.xssfSheet = xssfSheet;
    }

    private static void createXssfWorkbookIfNull() {
        if (Checker.isNull(xssfWorkbook)) {
            xssfWorkbook = new XSSFWorkbook();
        }
    }

    private static void createXssfSheetIfNull() {
        if (Checker.isNull(xssfSheet)) {
            MsExcelUtils.createXssfWorkbookIfNull();
            xssfSheet = xssfWorkbook.createSheet();
        }
    }
}

