/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util.encryption;

import com.zhazhapan.util.CryptUtils;
import com.zhazhapan.util.encryption.JavaEncrypt;

public class SimpleEncrypt {
    private SimpleEncrypt() {
    }

    public static String mix(String string, int key) {
        return SimpleEncrypt.ascii(JavaEncrypt.base64(SimpleEncrypt.xor(string, key)), key);
    }

    public static String xor(String string, int key) {
        char[] encrypt = string.toCharArray();
        for (int i = 0; i < encrypt.length; ++i) {
            encrypt[i] = (char)(encrypt[i] ^ key);
        }
        return new String(encrypt);
    }

    public static String xor(String string, String key) {
        return SimpleEncrypt.xor(string, CryptUtils.stringToKey(string));
    }

    public static String ascii(String string, int key) {
        StringBuilder code = new StringBuilder();
        int[] keys = CryptUtils.getKeys(key);
        for (int i = 0; i < string.length(); ++i) {
            code.append((char)(string.charAt(i) + (i + keys[0]) % keys[1] % keys[2]));
        }
        return code.toString();
    }

    public static String ascii(String string, String key) {
        return SimpleEncrypt.ascii(string, CryptUtils.stringToKey(key));
    }
}

