/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util.encryption;

import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.sun.crypto.provider.SunJCE;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import sun.misc.BASE64Encoder;

public class JavaEncrypt {
    private static final String DES_CRYPT_WAY = "DES";
    private static final String DES3_CRYPT_WAY = "DESede";
    private static final String AES_CRYPT_WAY = "AES";
    private static short DES = 0;
    private static SecretKey secretKey;
    private static Cipher cipher;
    private static short DES3;
    private static SecretKey secretKey3;
    private static Cipher cipher3;
    private static short AES;
    private static SecretKey aesKey;
    private static Cipher aes;
    private static short RSA;
    private static KeyPair rsaKey;
    private static Cipher rsa;
    public static final Digester MD5;

    private JavaEncrypt() {
    }

    public static String hmac(String string) throws NoSuchAlgorithmException, InvalidKeyException {
        String code = "";
        KeyGenerator keyGenerator = KeyGenerator.getInstance("HmacMD5");
        SecretKey secretKey = keyGenerator.generateKey();
        SecretKeySpec secretKey2 = new SecretKeySpec(secretKey.getEncoded(), "HmacMD5");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey2);
        return code;
    }

    private static boolean initDES(String key) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Security.addProvider(new SunJCE());
        if (DES_CRYPT_WAY.equals(key)) {
            KeyGenerator keygen = KeyGenerator.getInstance(key);
            secretKey = keygen.generateKey();
            cipher = Cipher.getInstance(key);
            DES = 1;
        } else if (DES3_CRYPT_WAY.equals(key)) {
            KeyGenerator keygen = KeyGenerator.getInstance(key);
            secretKey3 = keygen.generateKey();
            cipher3 = Cipher.getInstance(key);
            DES3 = 1;
        } else if (AES_CRYPT_WAY.equals(key)) {
            KeyGenerator keygen = KeyGenerator.getInstance(key);
            aesKey = keygen.generateKey();
            aes = Cipher.getInstance(key);
            AES = 1;
        } else {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(key);
            keyPairGen.initialize(1024);
            rsaKey = keyPairGen.generateKeyPair();
            rsa = Cipher.getInstance(key);
            RSA = 1;
        }
        return true;
    }

    public static String decryptDES(String code, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        return JavaEncrypt.cryptDES(code, 2, key);
    }

    private static String cryptDES(String string, int opmode, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        short isInit;
        String result = "";
        short s = DES_CRYPT_WAY.equals(key) ? DES : (AES_CRYPT_WAY.equals(key) ? AES : (isInit = "RSA".equals(key) ? RSA : DES3));
        if (isInit == 1 || JavaEncrypt.initDES(key) || JavaEncrypt.initDES(key)) {
            if (DES_CRYPT_WAY.equals(key)) {
                cipher.init(opmode, secretKey);
                result = new String(cipher.doFinal(string.getBytes("ISO-8859-1")), "ISO-8859-1");
            } else if (DES3_CRYPT_WAY.equals(key)) {
                cipher3.init(opmode, secretKey3);
                result = new String(cipher3.doFinal(string.getBytes("ISO-8859-1")), "ISO-8859-1");
            } else if (AES_CRYPT_WAY.equals(key)) {
                aes.init(opmode, aesKey);
                result = new String(aes.doFinal(string.getBytes("ISO-8859-1")), "ISO-8859-1");
            } else {
                rsa.init(opmode, opmode == 1 ? (RSAPublicKey)rsaKey.getPublic() : (RSAPrivateKey)rsaKey.getPrivate());
                result = new String(rsa.doFinal(string.getBytes("ISO-8859-1")), "ISO-8859-1");
            }
        }
        return result;
    }

    public static String rsa(String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        return JavaEncrypt.cryptDES(string, 1, "RSA");
    }

    public static String des3(String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        return JavaEncrypt.cryptDES(string, 1, DES3_CRYPT_WAY);
    }

    public static String aes(String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        return JavaEncrypt.cryptDES(string, 1, AES_CRYPT_WAY);
    }

    public static String des(String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        return JavaEncrypt.cryptDES(string, 1, DES_CRYPT_WAY);
    }

    public static String base64(String string) {
        return new BASE64Encoder().encodeBuffer(string.getBytes());
    }

    public static String sha(String string, int scale) throws NoSuchAlgorithmException {
        return JavaEncrypt.messageDigest("SHA", string, scale);
    }

    public static String sha(String string) throws NoSuchAlgorithmException {
        return JavaEncrypt.messageDigest("SHA", string, 32);
    }

    public static String sha256(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] hash = messageDigest.digest(string.getBytes("UTF-8"));
        return String.valueOf(Hex.encodeHex((byte[])hash));
    }

    public static String md5(String string, int scale) throws NoSuchAlgorithmException {
        return JavaEncrypt.messageDigest("MD5", string, scale);
    }

    public static String md5(String string) throws NoSuchAlgorithmException {
        return JavaEncrypt.messageDigest("MD5", string, 16);
    }

    private static String messageDigest(String key, String string, int scale) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(key);
        md.update(string.getBytes());
        BigInteger bigInteger = new BigInteger(md.digest());
        return bigInteger.toString(scale);
    }

    static {
        DES3 = 0;
        AES = 0;
        RSA = 0;
        MD5 = new Digester(DigestAlgorithm.MD5);
    }
}

