/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util.dialog;

import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;

public class Dialogs {
    private static final String CANCEL_BUTTON_TEXT = "\u53d6\u6d88";

    private Dialogs() {
    }

    public static String showInputDialog(String title, String header, String content, String defaultValue) {
        TextInputDialog dialog = new TextInputDialog(defaultValue);
        dialog.setTitle(title);
        dialog.setHeaderText(header);
        dialog.setContentText(content);
        Optional result = dialog.showAndWait();
        return result.orElse(null);
    }

    public static GridPane getGridPane() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        return grid;
    }

    public static Dialog<String[]> getDialog(String title, ButtonType ok) {
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.setHeaderText(null);
        dialog.initModality(Modality.APPLICATION_MODAL);
        ButtonType cancel = new ButtonType(CANCEL_BUTTON_TEXT, ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok, cancel});
        return dialog;
    }
}

