/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class Alerts {
    private Alerts() {
    }

    public static Optional<ButtonType> showInformation(String title, String content) {
        return Alerts.showInformation(title, null, content);
    }

    public static Optional<ButtonType> showInformation(String title, String header, String content) {
        return Alerts.alert(title, header, content, Alert.AlertType.INFORMATION);
    }

    public static Optional<ButtonType> showWarning(String title, String content) {
        return Alerts.showWarning(title, null, content);
    }

    public static Optional<ButtonType> showWarning(String title, String header, String content) {
        return Alerts.alert(title, header, content, Alert.AlertType.WARNING);
    }

    public static Optional<ButtonType> showError(String title, String content) {
        return Alerts.showError(title, null, content);
    }

    public static Optional<ButtonType> showError(String title, String header, String content) {
        return Alerts.alert(title, header, content, Alert.AlertType.ERROR);
    }

    public static Optional<ButtonType> showConfirmation(String title, String content) {
        return Alerts.showConfirmation(title, null, content);
    }

    public static Optional<ButtonType> showConfirmation(String title, String header, String content) {
        return Alerts.alert(title, header, content, Alert.AlertType.CONFIRMATION);
    }

    public static Optional<ButtonType> showException(String title, Exception e) {
        return Alerts.showException(title, null, e);
    }

    public static void showFatalError(String title, String header, Exception e) {
        Alerts.showException(title, header, e);
        System.exit(0);
    }

    public static Optional<ButtonType> showException(String title, String header, Exception e) {
        Alert alert = Alerts.getAlert(title, header, "\u9519\u8bef\u4fe1\u606f\u8ffd\u8e2a\uff1a", Alert.AlertType.ERROR);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String exception = stringWriter.toString();
        TextArea textArea = new TextArea(exception);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.add((Node)textArea, 0, 0);
        alert.getDialogPane().setExpandableContent((Node)gridPane);
        return alert.showAndWait();
    }

    public static Optional<ButtonType> alert(String title, String content) {
        return Alerts.alert(title, null, content);
    }

    public static Optional<ButtonType> alert(String title, String content, Alert.AlertType alertType) {
        return Alerts.alert(title, null, content, alertType);
    }

    public static Optional<ButtonType> alert(String title, String header, String content) {
        return Alerts.alert(title, header, content, Alert.AlertType.INFORMATION);
    }

    public static Optional<ButtonType> alert(String title, String header, String content, Alert.AlertType alertType) {
        return Alerts.alert(title, header, content, alertType, Modality.NONE, null, StageStyle.DECORATED);
    }

    public static Optional<ButtonType> alert(String title, String header, String content, Alert.AlertType alertType, Modality modality, Window window, StageStyle style) {
        return Alerts.getAlert(title, header, content, alertType, modality, window, style).showAndWait();
    }

    public static Alert getAlert(String title, String header, String content, Alert.AlertType alertType) {
        return Alerts.getAlert(title, header, content, alertType, Modality.APPLICATION_MODAL, null, StageStyle.DECORATED);
    }

    public static Alert getAlert(String title, String header, String content, Alert.AlertType alertType, Modality modality, Window window, StageStyle style) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.initModality(modality);
        alert.initOwner(window);
        alert.initStyle(style);
        return alert;
    }
}

