/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zhazhapan.modules.constant.ValueConsts;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.FileExecutor;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Pattern;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.apache.log4j.Logger;

public class Utils {
    private static final Pattern HAS_DIGIT_PATTERN = Pattern.compile(".*[0-9]+.*");
    private static final char[] UID = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int UID_LENGTH = UID.length;
    private static Logger logger = Logger.getLogger(Utils.class);

    private Utils() {
    }

    public static String replaceSpace(String string) {
        return string.replace(" ", "");
    }

    public static int[] split(long value, int ... splitPoints) {
        int[] vars = null;
        if (Checker.isNotNull(splitPoints)) {
            String val = String.valueOf(value);
            int len = splitPoints.length;
            vars = new int[len + 1];
            for (int i = 0; i < len; ++i) {
                vars[i] = Integer.parseInt(val.substring(i, splitPoints[i]));
            }
            vars[len] = Integer.parseInt(val.substring(splitPoints[len - 1]));
        }
        return vars;
    }

    public static String toUidString(int number) {
        StringBuilder builder = new StringBuilder();
        while (number > 0) {
            builder.append(UID[number % UID_LENGTH]);
            number /= UID_LENGTH;
        }
        return builder.toString();
    }

    public static <T> T loadJsonToBean(String jsonPath, Class<T> clazz) throws IOException {
        return Utils.loadJsonToBean(jsonPath, ValueConsts.NULL_STRING, clazz);
    }

    public static <T> T loadJsonToBean(String jsonPath, String encoding, Class<T> clazz) throws IOException {
        JSONObject jsonObject = JSONObject.parseObject((String)FileExecutor.readFileToString((File)new File(jsonPath), (String)encoding));
        return (T)JSONObject.toJavaObject((JSON)jsonObject, clazz);
    }

    public static String trim(String value, String trim) {
        return Utils.leftTrim(Utils.rightTrim(value, trim), trim);
    }

    public static String leftTrim(String value, String leftTrim) {
        if (Checker.isEmpty(value) || Checker.isEmpty(leftTrim)) {
            return value;
        }
        return value.indexOf(leftTrim) == 0 ? Utils.leftTrim(value.substring(leftTrim.length()), leftTrim) : value;
    }

    public static String rightTrim(String value, String rightTrim) {
        if (Checker.isEmpty(value) || Checker.isEmpty(rightTrim)) {
            return value;
        }
        int idx = value.length() - rightTrim.length();
        return value.lastIndexOf(rightTrim) == idx ? Utils.rightTrim(value.substring(0, idx), rightTrim) : value;
    }

    public static String getCurrentOS() {
        return System.getProperties().getProperty("os.name").toLowerCase();
    }

    public static double extractDouble(String string) {
        return Double.parseDouble(Utils.extractDigit(string));
    }

    public static float extractFloat(String string) {
        return Float.parseFloat(Utils.extractDigit(string));
    }

    public static short extractShort(String string) {
        return Short.parseShort(Utils.extractDigit(string).replace(".", ""));
    }

    public static long extractLong(String string) {
        return Long.parseLong(Utils.extractDigit(string).replace(".", ""));
    }

    public static int extractInt(String string) {
        return Integer.parseInt(Utils.extractDigit(string).replace(".", ""));
    }

    public static String extractDigit(String string) {
        StringBuilder res = new StringBuilder();
        if (HAS_DIGIT_PATTERN.matcher(string).matches()) {
            res = new StringBuilder((string = string.replaceAll("(\\s|[a-zA-Z])+", "")).indexOf("-") == 0 ? "-" : "");
            int dotIdx = string.lastIndexOf(".");
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c) && i != dotIdx) continue;
                res.append(c);
            }
            if (res.indexOf(".") == 0) {
                res.insert(0, "0");
            } else if (res.indexOf("-.") == 0) {
                res = new StringBuilder("-0." + res.substring(2, res.length()));
            }
        }
        return res.toString();
    }

    public static String maxLengthString(String ... strings) {
        String res = "";
        for (String string : strings) {
            if (string.length() <= res.length()) continue;
            res = string;
        }
        return res;
    }

    public static void copyToClipboard(String string) {
        ClipboardContent content = new ClipboardContent();
        content.putString(string);
        Clipboard.getSystemClipboard().setContent((Map)content);
        logger.info((Object)("copy '" + string + "' to clipboard"));
    }

    public static void openLink(String url) throws IOException, URISyntaxException {
        Desktop.getDesktop().browse(new URI(url));
    }

    public static void openFile(String path) throws IOException {
        Utils.openFile(new File(path));
    }

    public static void openFile(File file) throws IOException {
        Desktop.getDesktop().open(file);
    }

    public static void run(String command) throws IOException {
        Runtime.getRuntime().exec(command);
    }

    public static String getCurrentWorkDir() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    }

    public static int getMaxValue(int ... nums) {
        int max = 0;
        int last = nums.length - 1;
        for (int i = 0; i < last; i += 2) {
            max = Integer.max(max, Integer.max(nums[i], nums[i + 1]));
        }
        return Integer.max(max, nums[last]);
    }
}

