/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.zhazhapan.util.Checker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.log4j.Logger;

public class ReflectUtils {
    private static Logger logger = Logger.getLogger(ReflectUtils.class);
    private static JexlEngine jexlEngine = new Engine();

    private ReflectUtils() {
    }

    public static Object executeExpression(String jexlExpression, Map<String, Object> map) {
        JexlExpression expression = jexlEngine.createExpression(jexlExpression);
        MapContext context = new MapContext();
        if (Checker.isNotEmpty(map)) {
            map.forEach((arg_0, arg_1) -> ((JexlContext)context).set(arg_0, arg_1));
        }
        return expression.evaluate((JexlContext)context);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] parameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectUtils.invokeMethod(object, methodName, ReflectUtils.getTypes(parameters), parameters);
    }

    public static Object invokeMethodUseBasicType(Object object, String methodName, Object[] parameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectUtils.invokeMethod(object, methodName, ReflectUtils.getBasicTypes(parameters), parameters);
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (Checker.isNull(parameters)) {
            return object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
        }
        return object.getClass().getMethod(methodName, parameterTypes).invoke(object, parameters);
    }

    public static Class<?>[] getBasicTypes(Object[] objects) {
        if (!Checker.isNull(objects)) {
            Class[] classes = new Class[objects.length];
            int i = 0;
            for (Object object : objects) {
                classes[i] = Checker.isNull(object) ? null : (object instanceof Integer ? Integer.TYPE : (object instanceof Long ? Long.TYPE : (object instanceof Short ? Short.TYPE : (object instanceof Byte ? Byte.TYPE : (object instanceof Float ? Float.TYPE : (object instanceof Double ? Double.TYPE : (object instanceof Boolean ? Boolean.TYPE : (object instanceof Character ? Character.TYPE : object.getClass()))))))));
                ++i;
            }
            return classes;
        }
        return null;
    }

    public static Class<?>[] getTypes(Object[] objects) {
        if (!Checker.isNull(objects)) {
            Class[] classes = new Class[objects.length];
            int i = 0;
            for (Object object : objects) {
                classes[i++] = Checker.isNull(object) ? null : object.getClass();
            }
            return classes;
        }
        return null;
    }

    public static List<Class<?>> scanPackage(String ... packages) throws IOException, ClassNotFoundException {
        ArrayList list = new ArrayList();
        for (String pkg : packages) {
            list.addAll(ReflectUtils.getClasses(pkg));
        }
        return list;
    }

    public static List<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                ReflectUtils.addClassesInPackageByFile(packageName, filePath, classes);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (!name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                classes.add(Class.forName(packageName + '.' + className));
            }
        }
        return classes;
    }

    public static void addClassesInPackageByFile(String packageName, String packagePath, List<Class<?>> classes) throws ClassNotFoundException {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles(file -> file.isDirectory() || file.getName().endsWith(".class"));
        if (Checker.isNotNull(files)) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    ReflectUtils.addClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), classes);
                    continue;
                }
                String className = file2.getName().substring(0, file2.getName().length() - 6);
                classes.add(Class.forName(packageName + '.' + className));
            }
        }
    }
}

