/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import cn.hutool.core.util.RandomUtil;
import com.zhazhapan.util.Utils;
import com.zhazhapan.util.model.SimpleColor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class RandomUtils
extends org.apache.commons.lang3.RandomUtils {
    private RandomUtils() {
    }

    public static String getRandomUid() {
        int[] val = Utils.split(System.currentTimeMillis(), 9);
        String uid = Utils.toUidString(val[0]) + Utils.toUidString(val[1]);
        return uid + RandomUtil.simpleUUID().substring(0, 16 - uid.length());
    }

    public static String getRandomEmail() {
        return RandomUtils.getRandomStringOnlyLowerCase(RandomUtils.getRandomInteger(3, 10)) + "@" + RandomUtils.getRandomStringOnlyLowerCase(RandomUtils.getRandomInteger(3, 5)) + "." + RandomUtils.getRandomStringOnlyLowerCase(RandomUtils.getRandomInteger(1, 5));
    }

    public static int getRandomInteger(int length) {
        return RandomUtils.getRandomInteger((int)Math.pow(10.0, length - 1), (int)Math.pow(10.0, length));
    }

    public static String getRandomString(int length) {
        return RandomUtils.getRandomText(32, 126, length);
    }

    public static String getRandomStringWithoutSymbol(int length) {
        return RandomUtils.getRandomTextIgnoreRange(48, 122, length, {58, 64}, {91, 96});
    }

    public static String getRandomStringOnlyLetter(int length) {
        return RandomUtils.getRandomTextIgnoreRange(65, 122, length, new int[][]{{91, 96}});
    }

    public static String getRandomStringOnlyLowerCase(int length) {
        return RandomUtils.getRandomText(97, 122, length);
    }

    public static String getRandomStringOnlyUpperCase(int length) {
        return RandomUtils.getRandomText(65, 90, length);
    }

    public static String getRandomTextIgnoreRange(int floor, int ceil, int length, int[] ... ranges) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)RandomUtils.getRandomIntegerIgnoreRange(floor, ceil, ranges));
        }
        return builder.toString();
    }

    public static String getRandomText(int floor, int ceil, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)RandomUtils.getRandomInteger(floor, ceil));
        }
        return builder.toString();
    }

    public static double getRandomDouble() {
        return RandomUtils.getRandomDouble(0.0, Double.MAX_VALUE);
    }

    public static double getRandomDouble(double floor, double ceil) {
        return RandomUtils.getRandomDouble(floor, ceil, 2);
    }

    public static double getRandomDouble(double floor, double ceil, int precision) {
        BigDecimal decimal = new BigDecimal(floor + new Random().nextDouble() * (ceil - floor));
        return decimal.setScale(precision, RoundingMode.HALF_UP).doubleValue();
    }

    public static int getRandomInteger() {
        return RandomUtils.getRandomInteger(0, Integer.MAX_VALUE);
    }

    public static int getRandomIntegerIgnoreRange(int floor, int ceil, int[] ... ranges) {
        int result = RandomUtils.getRandomInteger(floor, ceil);
        for (int[] range : ranges) {
            if (range[0] > result || result > range[1]) continue;
            if (range[0] > floor) {
                result = RandomUtils.getRandomIntegerIgnoreRange(floor, range[0], ranges);
                continue;
            }
            if (range[1] < ceil) {
                result = RandomUtils.getRandomIntegerIgnoreRange(range[1], ceil, ranges);
                continue;
            }
            return -1;
        }
        return result;
    }

    public static int getRandomInteger(int floor, int ceil) {
        return floor + new Random().nextInt(ceil - floor);
    }

    public static String getRandomNumber(int length) {
        return RandomUtils.getRandomText(48, 58, length);
    }

    public static SimpleColor getRandomColor(double opacity) {
        Random ran = new Random();
        int b = ran.nextInt(255);
        int r = 255 - b;
        return new SimpleColor(b + ran.nextInt(r), b + ran.nextInt(r), b + ran.nextInt(r), opacity);
    }

    public static SimpleColor getRandomColor() {
        return RandomUtils.getRandomColor(1.0);
    }
}

