/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.zhazhapan.modules.constant.ValueConsts;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.FileExecutor;
import com.zhazhapan.util.LoggerUtils;
import com.zhazhapan.util.encryption.JavaEncrypt;
import com.zhazhapan.util.interfaces.MultipartFileService;
import com.zhazhapan.util.model.CheckResult;
import com.zhazhapan.util.model.ResultObject;
import com.zhazhapan.util.model.SimpleMultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomSerializer;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class NetUtils {
    public static final String PROTOCOL_KEY = "$protocol";
    public static final String HOST_KEY = "$host";
    public static final String PATH_KEY = "$path";

    private NetUtils() {
    }

    public static <T> ResultObject<T> upload(byte[] bytes, SimpleMultipartFile simpleMultipartFile, MultipartFileService<T> multipartFileService) {
        ResultObject resultObject = new ResultObject();
        String md5 = JavaEncrypt.MD5.digestHex(bytes);
        String filename = md5 + FileExecutor.getSuffix(simpleMultipartFile.getOriginalFilename());
        String localPath = simpleMultipartFile.getStoragePath() + filename;
        simpleMultipartFile.setFilename(filename).setMd5(md5);
        Boolean exists = multipartFileService.existsMultipartFile(simpleMultipartFile);
        boolean shouldWrite = false;
        Object t = null;
        if (Checker.isNull(exists)) {
            t = multipartFileService.getBySimpleMultipartFile(simpleMultipartFile);
            if (Checker.isNull(t)) {
                shouldWrite = true;
            }
        } else if (!exists.booleanValue()) {
            shouldWrite = true;
        }
        if (shouldWrite) {
            try {
                FileExecutor.writeByteArrayToFile((File)new File(localPath), (byte[])bytes);
            }
            catch (IOException e) {
                LoggerUtils.error(e.getMessage(), new String[0]);
                return resultObject.copyFrom(CheckResult.getErrorResult("\u5185\u90e8\u9519\u8bef\uff1a\u6587\u4ef6\u5199\u5165\u5931\u8d25"));
            }
            t = multipartFileService.saveEntity(simpleMultipartFile);
        }
        return resultObject.setData(t);
    }

    public static String delete(String url, String body) {
        return NetUtils.request(HttpRequest.delete((String)NetUtils.replaceLocalHost(url)), body).body();
    }

    public static String delete(String url, Map<String, String> body) {
        return NetUtils.delete(url, JSONObject.toJSONString(body));
    }

    public static String delete(String url, JSONObject body) {
        return NetUtils.delete(url, body.toJSONString());
    }

    public static String put(String url, String body) {
        return NetUtils.request(HttpRequest.put((String)NetUtils.replaceLocalHost(url)), body).body();
    }

    public static String put(String url, Map<String, String> body) {
        return NetUtils.put(url, JSONObject.toJSONString(body));
    }

    public static String put(String url, JSONObject body) {
        return NetUtils.put(url, body.toJSONString());
    }

    public static String get(String url, String body) {
        return NetUtils.request(HttpRequest.get((String)NetUtils.replaceLocalHost(url)), body).body();
    }

    public static String get(String url, Map<String, String> body) {
        return NetUtils.get(url, JSONObject.toJSONString(body));
    }

    public static String get(String url, JSONObject body) {
        return NetUtils.get(url, body.toJSONString());
    }

    public static String post(String url, String body) {
        return NetUtils.request(HttpRequest.post((String)NetUtils.replaceLocalHost(url)), body).body();
    }

    public static String post(String url, Map<String, String> body) {
        return NetUtils.post(url, JSONObject.toJSONString(body));
    }

    public static String post(String url, JSONObject body) {
        return NetUtils.post(url, body.toJSONString());
    }

    public static HttpResponse request(HttpRequest request, String body) {
        return NetUtils.request(request, body, "application/json");
    }

    public static HttpResponse request(HttpRequest request, String body, String contentType) {
        return request.contentType(contentType).body(body).contentLength(body.length()).execute();
    }

    public static String replaceLocalHost(String domain) {
        return domain.replaceAll("localhost", "127.0.0.1");
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    public static Map<String, String> parseUrl(String url) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put(PROTOCOL_KEY, "");
        result.put(HOST_KEY, "");
        result.put(PATH_KEY, "");
        if (Checker.isNotEmpty(url)) {
            String protocolSplit = "://";
            String[] pros = url.contains("://") ? url.split("://") : new String[]{"", url};
            result.put(PROTOCOL_KEY, pros[0]);
            if (pros.length < 2) {
                pros = new String[]{pros[0], ""};
            }
            if (pros[1].contains("/")) {
                int lastIndex = pros[1].lastIndexOf("/");
                if (pros[1].startsWith("/")) {
                    result.put(PATH_KEY, pros[1].substring(1));
                } else if (pros[1].contains("/")) {
                    int index = pros[1].indexOf("/");
                    result.put(HOST_KEY, pros[1].substring(0, index));
                    if (pros[1].contains("?")) {
                        String[] params;
                        lastIndex = pros[1].indexOf("?");
                        for (String param : params = pros[1].split("\\?")[1].split("&")) {
                            String[] kv = param.split("=");
                            result.put(kv[0], kv[1]);
                        }
                    }
                    if (lastIndex > index) {
                        String path = pros[1].substring(index + 1, lastIndex);
                        path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                        result.put(PATH_KEY, path);
                    }
                } else {
                    result.put(HOST_KEY, pros[1]);
                }
            } else {
                result.put(HOST_KEY, pros[1]);
            }
        }
        return result;
    }

    public static String scriptFilter(String string) {
        return Checker.checkNull(string).replaceAll("<script.*?>.*?</script>", "");
    }

    public static boolean clearCookie(HttpServletRequest request, HttpServletResponse response) {
        return NetUtils.clearCookie(request.getCookies(), response);
    }

    public static boolean clearCookie(Cookie[] cookies, HttpServletResponse response) {
        if (Checker.isNotEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                NetUtils.removeCookie(cookie, response);
            }
            return true;
        }
        return false;
    }

    public static boolean removeCookie(String name, HttpServletRequest request, HttpServletResponse response) {
        return NetUtils.removeCookie(name, request.getCookies(), response);
    }

    public static boolean removeCookie(String name, Cookie[] cookies, HttpServletResponse response) {
        if (Checker.isNotEmpty(name) && Checker.isNotEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return NetUtils.removeCookie(cookie, response);
            }
        }
        return false;
    }

    public static boolean removeCookie(Cookie cookie, HttpServletResponse response) {
        if (Checker.isNotNull(cookie)) {
            cookie.setMaxAge(0);
            return NetUtils.addCookie(cookie, response);
        }
        return false;
    }

    public static boolean addCookie(Cookie cookie, HttpServletResponse response) {
        if (Checker.isNotNull(cookie) && Checker.isNotNull(response)) {
            response.addCookie(cookie);
            return true;
        }
        return false;
    }

    public static boolean addCookie(HttpServletResponse response, String name, String value) {
        return NetUtils.addCookie(new Cookie(name, value), response);
    }

    public static boolean addCookie(HttpServletResponse response, String name, String value, int expiry, String uri) {
        Cookie cookie = new Cookie(name, value);
        if (expiry > 0) {
            cookie.setMaxAge(expiry);
        }
        if (Checker.isNotEmpty(uri)) {
            cookie.setPath(uri);
        }
        return NetUtils.addCookie(cookie, response);
    }

    public static Cookie getCookie(String name, HttpServletRequest request) {
        return NetUtils.getCookie(name, request.getCookies());
    }

    public static Cookie getCookie(String name, Cookie[] cookies) {
        if (Checker.isNotEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String whois(String domain) throws IOException, XPathExpressionException, ParserConfigurationException {
        String whois = NetUtils.evaluate("//ul[@class='WhoisLeft fl']", NetUtils.getHtmlFromUrl("http://whois.chinaz.com/" + domain));
        return whois.replaceAll("\\[whois\\s?\u53cd\u67e5]", "").replaceAll("\\s{2,}", "\r\n");
    }

    public static String getLocationByIp(String ip) throws IOException, XPathExpressionException, ParserConfigurationException {
        return NetUtils.evaluate("//div[@class='WhoIpWrap jspu']/p[2]/span[4]", NetUtils.getHtmlFromUrl("http://ip.chinaz.com/" + ip));
    }

    public static String evaluate(String xpath, String html) throws XPathExpressionException, ParserConfigurationException {
        HtmlCleaner hc = new HtmlCleaner();
        TagNode tn = hc.clean(html);
        org.w3c.dom.Document document = new DomSerializer(new CleanerProperties()).createDOM(tn);
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.evaluate(xpath, document);
    }

    public static String getHtmlFromUrl(String url) throws IOException {
        return NetUtils.getDocumentFromUrl(url).html();
    }

    public static Document getDocumentFromUrl(String url) throws IOException {
        return Jsoup.connect((String)url).get();
    }

    public static String getComputerName() {
        return System.getenv().get("COMPUTERNAME");
    }

    public static String getSystemName() {
        return System.getProperty("os.name");
    }

    public static String getSystemArch() {
        return System.getProperty("os.arch");
    }

    public static String getSystemVersion() {
        return System.getProperty("os.version");
    }

    public static String getMacAddress() throws UnknownHostException, SocketException {
        byte[] mac = NetworkInterface.getByInetAddress(Inet4Address.getLocalHost()).getHardwareAddress();
        StringBuilder jointMac = new StringBuilder();
        for (byte aMac : mac) {
            String macPart = Integer.toHexString(aMac & 0xFF);
            jointMac.append(macPart.length() == 1 ? "0" + macPart : macPart).append("-");
        }
        String macFormat = jointMac.toString();
        return macFormat.substring(0, macFormat.length() - 1);
    }

    public static JSONObject getPublicIpAndLocation() throws IOException {
        return FileExecutor.parseJsonObject(new URL("http://ip.chinaz.com/getip.aspx"));
    }

    public static String getLocalIp() throws UnknownHostException {
        return Inet4Address.getLocalHost().getHostAddress();
    }

    public static String urlToString(URL url) {
        return Checker.isNull(url) ? "" : url.toString().replaceAll("file:" + (Checker.isWindows() ? "/?" : ""), "");
    }

    public static String getDataOfUrl(String url) throws IOException {
        return NetUtils.getDataOfUrl(new URL(url));
    }

    public static String getDataOfUrl(URL url) throws IOException {
        return FileExecutor.read(NetUtils.getInputStreamOfUrl(url));
    }

    public static InputStream getInputStreamOfUrl(String url) throws IOException {
        return NetUtils.getInputStreamOfUrl(new URL(url));
    }

    public static InputStream getInputStreamOfUrl(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return NetUtils.getInputStreamOfConnection(conn);
    }

    public static InputStream getInputStreamOfConnection(HttpURLConnection connection) throws IOException {
        return NetUtils.setDefaultValue(connection).getInputStream();
    }

    private static HttpURLConnection setDefaultValue(HttpURLConnection connection) {
        connection.setConnectTimeout(6000);
        connection.setRequestProperty("Charset", "UTF-8");
        connection.setRequestProperty("User-Agent", ValueConsts.USER_AGENT[0]);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Accept", "*/*");
        return connection;
    }
}

