/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.mail.util.MailSSLSocketFactory;
import com.zhazhapan.util.Checker;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailSender {
    private static String host = "smtp.qq.com";
    private static String personal = "personal";
    private static String from = "";
    private static String key = "";
    private static boolean sslEnable = true;
    private static int port = 0;

    private MailSender() {
    }

    public static void config(String jsonString) {
        MailSender.config(JSON.parseObject((String)jsonString));
    }

    public static void config(JSONObject jsonObject) {
        MailSender.config(jsonObject.getString("host"), jsonObject.getString("personal"), jsonObject.getString("from"), jsonObject.getString("key"), (int)jsonObject.getInteger("port"));
        MailSender.setSslEnable(jsonObject.getBoolean("ssl"));
    }

    public static void config(String host, String personal, String from, String key, int port) {
        MailSender.config(host, personal, from, key);
        MailSender.setPort(port);
    }

    public static void config(MailHost mailHost, String personal, String from, String key, int port) {
        MailSender.config(mailHost, personal, from, key);
        MailSender.setPort(port);
    }

    public static void config(MailHost mailHost, String personal, String from, String key) {
        MailSender.setHost(mailHost);
        MailSender.setPersonal(personal);
        MailSender.setFrom(from);
        MailSender.setKey(key);
    }

    public static void config(String host, String personal, String from, String key) {
        MailSender.setHost(host);
        MailSender.setPersonal(personal);
        MailSender.setFrom(from);
        MailSender.setKey(key);
    }

    public static void sendMail(MailHost mailHost, String personal, String to, String title, String content, String from, String key) throws Exception {
        MailSender.setHost(mailHost);
        MailSender.setPersonal(personal);
        MailSender.sendMail(to, title, content, from, key);
    }

    public static void sendMail(String host, String personal, String to, String title, String content, String from, String key) throws Exception {
        MailSender.setHost(host);
        MailSender.setPersonal(personal);
        MailSender.sendMail(to, title, content, from, key);
    }

    public static void sendMail(String to, String title, String content, String from, String key) throws Exception {
        MailSender.setFrom(from);
        MailSender.setKey(key);
        MailSender.sendMail(to, title, content);
    }

    public static void sendMail(String to, String title, String content) throws Exception {
        if (!Checker.isEmail(to)) {
            throw new Exception("this email address is not valid. please check it again");
        }
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", host);
        if (port > 0) {
            properties.setProperty("mail.smtp.port", String.valueOf(port));
        }
        properties.put("mail.smtp.auth", "true");
        MailSSLSocketFactory sf = new MailSSLSocketFactory();
        sf.setTrustAllHosts(true);
        properties.put("mail.smtp.ssl.enable", (Object)sslEnable);
        properties.put("mail.smtp.ssl.socketFactory", sf);
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(from, key);
            }
        });
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from, personal, "UTF-8"));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(title, "UTF-8");
        message.setContent((Object)content, "text/html;charset=UTF-8");
        message.setSentDate(new Date());
        Transport.send((Message)message);
    }

    public static String getHost() {
        return host;
    }

    public static void setHost(String host) {
        MailSender.host = host;
    }

    public static void setHost(MailHost mailHost) {
        switch (mailHost) {
            case NE163: {
                host = "smtp.163.com";
                break;
            }
            case GMAIL: {
                host = "smtp.gmail.com";
                break;
            }
            case SINA: {
                host = "smtp.sina.com";
                break;
            }
            case OUTLOOK: {
                host = "smtp-mail.outlook.com";
                break;
            }
            default: {
                host = "smtp.qq.com";
            }
        }
    }

    public static String getPersonal() {
        return personal;
    }

    public static void setPersonal(String personal) {
        MailSender.personal = personal;
    }

    public static String getFrom() {
        return from;
    }

    public static void setFrom(String from) {
        MailSender.from = from;
    }

    public static String getKey() {
        return key;
    }

    public static void setKey(String key) {
        MailSender.key = key;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        MailSender.port = port;
    }

    public static void setSslEnable(boolean sslEnable) {
        MailSender.sslEnable = sslEnable;
    }

    public static enum MailHost {
        QQ,
        NE163,
        GMAIL,
        SINA,
        OUTLOOK;

    }
}

