/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import cn.hutool.core.util.StrUtil;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.enums.LogLevel;
import org.apache.log4j.Logger;

public class LoggerUtils {
    private static final Class<?> LOCAL_CLASS = LoggerUtils.class;

    private LoggerUtils() {
    }

    public static Logger getLogger() {
        return LoggerUtils.getLogger(LOCAL_CLASS);
    }

    public static Logger getLogger(Object object) {
        return Checker.isNull(object) ? LoggerUtils.getLogger() : LoggerUtils.getLogger(object.getClass());
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(Checker.isNull(clazz) ? LOCAL_CLASS : clazz);
    }

    public static void info(String message, String ... values) {
        LoggerUtils.info(LOCAL_CLASS, message, values);
    }

    public static void info(Object object, String message, String ... values) {
        if (Checker.isNull(object)) {
            LoggerUtils.info(message, values);
        } else {
            LoggerUtils.info(object.getClass(), message, values);
        }
    }

    public static void info(Class<?> clazz, String message, String ... values) {
        LoggerUtils.getLogger(clazz).info((Object)LoggerUtils.formatString(message, values));
    }

    public static void warn(String message, String ... values) {
        LoggerUtils.warn(LOCAL_CLASS, message, values);
    }

    public static void warn(Object object, String message, String ... values) {
        if (Checker.isNull(object)) {
            LoggerUtils.warn(message, values);
        } else {
            LoggerUtils.warn(object.getClass(), message, values);
        }
    }

    public static void warn(Class<?> clazz, String message, String ... values) {
        LoggerUtils.getLogger(clazz).warn((Object)LoggerUtils.formatString(message, values));
    }

    public static void error(String message, String ... values) {
        LoggerUtils.error(LOCAL_CLASS, message, values);
    }

    public static void error(Object object, String message, String ... values) {
        if (Checker.isNull(object)) {
            LoggerUtils.error(message, values);
        } else {
            LoggerUtils.error(object.getClass(), message, values);
        }
    }

    public static void error(Class<?> clazz, String message, String ... values) {
        LoggerUtils.getLogger(clazz).error((Object)LoggerUtils.formatString(message, values));
    }

    public static void debug(String message, String ... values) {
        LoggerUtils.debug(LOCAL_CLASS, message, values);
    }

    public static void debug(Object object, String message, String ... values) {
        if (Checker.isNull(object)) {
            LoggerUtils.debug(message, values);
        } else {
            LoggerUtils.debug(object.getClass(), message, values);
        }
    }

    public static void debug(Class<?> clazz, String message, String ... values) {
        LoggerUtils.getLogger(clazz).debug((Object)LoggerUtils.formatString(message, values));
    }

    public static void fatal(String message, String ... values) {
        LoggerUtils.fatal(LOCAL_CLASS, message, values);
    }

    public static void fatal(Object object, String message, String ... values) {
        if (Checker.isNull(object)) {
            LoggerUtils.fatal(message, values);
        } else {
            LoggerUtils.fatal(object.getClass(), message, values);
        }
    }

    public static void fatal(Class<?> clazz, String message, String ... values) {
        LoggerUtils.getLogger(clazz).fatal((Object)LoggerUtils.formatString(message, values));
    }

    public static void log(String message, String ... values) {
        LoggerUtils.log(LogLevel.INFO, message, values);
    }

    public static void log(LogLevel logLevel, String message, String ... values) {
        LoggerUtils.log(logLevel, LOCAL_CLASS, message, values);
    }

    public static void log(LogLevel logLevel, Object object, String message, String ... values) {
        if (Checker.isNull(object)) {
            LoggerUtils.log(logLevel, message, values);
        } else {
            LoggerUtils.log(logLevel, object.getClass(), message, values);
        }
    }

    public static void log(LogLevel logLevel, Class<?> clazz, String message, String ... values) {
        switch (logLevel) {
            case WARN: {
                LoggerUtils.warn(clazz, message, values);
                break;
            }
            case ERROR: {
                LoggerUtils.error(clazz, message, values);
                break;
            }
            case FATAL: {
                LoggerUtils.fatal(clazz, message, values);
                break;
            }
            default: {
                LoggerUtils.info(clazz, message, values);
            }
        }
    }

    private static String formatString(String message, Object[] values) {
        if (Checker.isNotEmpty(message)) {
            if (Checker.isNotEmpty(values)) {
                return StrUtil.format((CharSequence)String.format(message, values), (Object[])values);
            }
            return message;
        }
        return "";
    }
}

