/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class ListUtils {
    public static final int DEFAULT_LIST_CAPACITY = 10;

    private ListUtils() {
    }

    @SafeVarargs
    public static <T> ArrayList<T> getArrayList(int capacity, final T ... values) {
        return new ArrayList<T>(capacity){
            {
                super(x0);
                this.addAll(Arrays.asList(values));
            }
        };
    }

    public static <T> ArrayList<T> getArrayList(T ... values) {
        return ListUtils.getArrayList(10, values);
    }

    @SafeVarargs
    public static <T> LinkedList<T> getLinkedList(final T ... values) {
        return new LinkedList<T>(){
            {
                this.addAll(Arrays.asList(values));
            }
        };
    }

    public static <T> Vector<T> getVector(int capacity, final T ... values) {
        return new Vector<T>(){
            {
                this.addAll(Arrays.asList(values));
            }
        };
    }

    public static <T> Vector<T> getVector(T ... values) {
        return ListUtils.getVector(10, values);
    }
}

