/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Formatter {
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("([^/\\\\:*\"<>|?]+\\.)*[^/\\\\:*\"<>|?]+(\\?.*)?$", 2);
    private static final char[] RMB_CHARACTERS = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".toCharArray();
    private static final String[] RMB_INTEGER_UNIT = new String[]{"\u5143", "\u4e07", "\u4ebf", "\u5146"};
    private static final String[] RMB_DECIMAL_UNIT = new String[]{"\u89d2", "\u5206"};
    private static final String[] RMB_UNIT = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String SIZE_KB = "KB";
    private static final String SIZE_MB = "MB";
    private static final String SIZE_GB = "GB";
    private static final String SIZE_TB = "TB";
    private static final SimpleDateFormat DATE_WITH_LONG_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat DATE_WITHOUT_TIME = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat LONG_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat SHORT_TIME = new SimpleDateFormat("HH:mm");
    private static final String STANDARD_FORMAT = "#0.00";

    private Formatter() {
    }

    public static String toFinancialCharacter(double number) {
        String zero = String.valueOf(0);
        String[] array = Formatter.formatDecimal(number).split("\\.");
        int len = Math.min(array[0].length(), 16);
        StringBuilder leftUpper = new StringBuilder();
        StringBuilder rightUpper = new StringBuilder();
        for (int i = len - 1; i >= 0; --i) {
            int reverseIndex = len - i - 1;
            int idx = array[0].charAt(i) - 48;
            int remainder = reverseIndex % 4;
            int res = reverseIndex / 4;
            if (remainder == 0 && res > 0) {
                leftUpper.insert(0, RMB_INTEGER_UNIT[res]);
            }
            leftUpper.insert(0, idx > 0 ? RMB_CHARACTERS[idx] + RMB_UNIT[remainder] : Integer.valueOf(idx));
        }
        array[1] = Utils.rightTrim(array[1], zero);
        String left = Utils.rightTrim(leftUpper.toString(), zero);
        if (Checker.isEmpty(array[1])) {
            rightUpper.append("\u6574");
        } else {
            for (int i = 0; i < array[1].length(); ++i) {
                int idx = array[1].charAt(i) - 48;
                if (i == 0) {
                    rightUpper.append(idx > 0 ? RMB_CHARACTERS[idx] + RMB_DECIMAL_UNIT[i] : zero);
                    continue;
                }
                rightUpper.append(RMB_CHARACTERS[idx]).append(RMB_DECIMAL_UNIT[i]);
            }
        }
        String upper = Utils.leftTrim((Checker.isEmpty(left) ? (Checker.isEmpty(rightUpper.toString()) ? zero + RMB_INTEGER_UNIT[0] : "") : left + RMB_INTEGER_UNIT[0]) + rightUpper, zero).replaceAll("0+", "\u96f6");
        int unitLen = len / RMB_INTEGER_UNIT.length + 1;
        for (int i = 1; i < unitLen; ++i) {
            for (int j = i + 1; j < unitLen; ++j) {
                upper = upper.replace(RMB_INTEGER_UNIT[j] + RMB_CHARACTERS[0] + RMB_INTEGER_UNIT[i], RMB_INTEGER_UNIT[j]);
            }
            upper = upper.replace(RMB_CHARACTERS[0] + RMB_INTEGER_UNIT[i], RMB_INTEGER_UNIT[i] + RMB_CHARACTERS[0]);
            upper = upper.replace(RMB_INTEGER_UNIT[i] + RMB_CHARACTERS[0] + RMB_INTEGER_UNIT[0], RMB_INTEGER_UNIT[i] + RMB_INTEGER_UNIT[0]);
        }
        return upper.replaceAll("\u96f6\u96f6", "\u96f6");
    }

    public static String toCurrency(Locale locale, double number) {
        return NumberFormat.getCurrencyInstance(locale).format(number);
    }

    public static String toCurrency(double number) {
        return Formatter.toCurrency(Locale.CHINA, number);
    }

    public static int stringToInt(String string) {
        return Formatter.stringToInteger(string);
    }

    public static String formatSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return Formatter.formatDecimal((double)size / 1024.0) + " KB";
        }
        if (size < 0x40000000L) {
            return Formatter.formatDecimal((double)size / 1048576.0) + " MB";
        }
        if (size < 0x10000000000L) {
            return Formatter.formatDecimal((double)size / 1.073741824E9) + " GB";
        }
        return Formatter.formatDecimal((double)size / 1.099511627776E12) + " TB";
    }

    public static long sizeToLong(String size) {
        if (Checker.isNotEmpty(size = size.trim())) {
            String num = size.contains(" ") ? size.split(" ")[0] : Utils.extractDigit(size);
            double result = size.contains(SIZE_TB) ? Formatter.stringToDouble(num) * 1.099511627776E12 : (size.contains(SIZE_GB) ? Formatter.stringToDouble(num) * 1.073741824E9 : (size.contains(SIZE_MB) ? Formatter.stringToDouble(num) * 1048576.0 : (size.contains(SIZE_KB) ? Formatter.stringToDouble(num) * 1024.0 : Formatter.stringToDouble(num))));
            return (long)result;
        }
        return -1L;
    }

    public static double stringToDouble(String string) {
        if (Checker.isDecimal(string = string.trim())) {
            return Double.parseDouble(string);
        }
        return -1.0;
    }

    public static long stringToLong(String string) {
        if (Checker.isNumber(string = string.trim())) {
            return Long.parseLong(string);
        }
        return -1L;
    }

    public static String customFormatDecimal(double number, String format) {
        return new DecimalFormat(format).format(number);
    }

    public static String formatDecimal(double number) {
        return Formatter.formatDecimal(number, STANDARD_FORMAT);
    }

    public static String formatDecimal(double number, String format) {
        return Formatter.customFormatDecimal(number, format);
    }

    public static synchronized String timeStampToString(long time) {
        return DATE_WITH_LONG_TIME.format(time);
    }

    public static String mapToJson(Map<?, ?> map) {
        return Formatter.formatJson(JSONObject.toJSON(map).toString());
    }

    public static String mapToJsonArray(Map<?, ?> map) {
        JSONArray array = new JSONArray();
        if (Checker.isNotEmpty(map)) {
            map.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("key", key);
                object.put("value", value);
                array.add((Object)object);
            });
        }
        return Formatter.formatJson(array.toString());
    }

    public static String listToJson(List<?> list) {
        JSONArray array = new JSONArray();
        if (Checker.isNotEmpty(list)) {
            array.addAll(list);
        }
        return Formatter.formatJson(array.toString());
    }

    public static String formatJson(String string) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(string);
        String json = gson.toJson(je);
        return json;
    }

    public static synchronized String dateToString(Date date) {
        return DATE_WITHOUT_TIME.format(Checker.checkNull(date));
    }

    public static synchronized String datetimeToString(Date date) {
        return DATE_WITH_LONG_TIME.format(Checker.checkNull(date));
    }

    public static String getFileName(String string) throws UnsupportedEncodingException {
        String name;
        Matcher matcher;
        if (Checker.isNotEmpty(string) && (matcher = FILE_NAME_PATTERN.matcher(string = URLDecoder.decode(string, "UTF-8"))).find() && Checker.isNotEmpty(matcher.group(0)) && Checker.isNotEmpty(name = matcher.group(0).split("\\?")[0])) {
            return name;
        }
        return "undefined";
    }

    public static float stringToFloat(String string) {
        if (Checker.isDecimal(string = string.trim())) {
            return Float.parseFloat(string);
        }
        return -1.0f;
    }

    public static int stringToInteger(String string) {
        if (Checker.isNumber(string = string.trim())) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public static short stringToShort(String string) {
        if (Checker.isNumber(string = string.trim())) {
            return Short.parseShort(string);
        }
        return -1;
    }

    public static synchronized Date stringToDate(String date) throws ParseException {
        return Formatter.stringToCustomDateTime(DATE_WITHOUT_TIME, date);
    }

    public static synchronized Date stringToLongTime(String time) throws ParseException {
        return Formatter.stringToCustomDateTime(LONG_TIME, time);
    }

    public static synchronized Date stringToShortTime(String time) throws ParseException {
        return Formatter.stringToCustomDateTime(SHORT_TIME, time);
    }

    public static Date stringToCustomDateTime(String datetime, String formatWay) throws ParseException {
        return Formatter.stringToCustomDateTime(new SimpleDateFormat(formatWay), datetime);
    }

    public static synchronized Date stringToDatetime(String datetime) throws ParseException {
        return Formatter.stringToCustomDateTime(DATE_WITH_LONG_TIME, datetime);
    }

    public static Date stringToCustomDateTime(SimpleDateFormat sdf, String datetime) throws ParseException {
        return sdf.parse(datetime.trim());
    }

    public static String toLocalDate(Date date) {
        return Formatter.datetimeToCustomString(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5"), date);
    }

    public static synchronized String longTimeToString(Date time) {
        return Formatter.datetimeToCustomString(LONG_TIME, time);
    }

    public static synchronized String shortTimeToString(Date time) {
        return Formatter.datetimeToCustomString(SHORT_TIME, time);
    }

    public static String datetimeToCustomString(Date datetime, String formatWay) {
        return Formatter.datetimeToCustomString(new SimpleDateFormat(formatWay), datetime);
    }

    public static String datetimeToCustomString(SimpleDateFormat sdf, Date datetime) {
        return Checker.isNull(datetime) ? "" : sdf.format(datetime);
    }

    public static String numberFormat(long data, int length) {
        return String.format("%0" + length + "d", data);
    }

    public static Date localDateToDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static LocalDate dateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone).toLocalDate();
    }
}

