/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zhazhapan.modules.constant.ValueConsts;
import com.zhazhapan.util.ArrayUtils;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.NetUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileExecutor
extends FileUtils {
    private static Logger logger = Logger.getLogger(FileExecutor.class);

    private FileExecutor() {
    }

    public static JSONArray parseJsonArray(URL url) throws IOException {
        String path = url.toString();
        if (path.startsWith("file:")) {
            return FileExecutor.parseJsonArray(NetUtils.urlToString(url));
        }
        return JSONArray.parseArray((String)FileExecutor.read(url));
    }

    public static JSONArray parseJsonArray(String file) throws IOException {
        return FileExecutor.parseJsonArray(new File(file));
    }

    public static JSONArray parseJsonArray(File file) throws IOException {
        return JSONArray.parseArray((String)FileExecutor.readFile(file));
    }

    public static JSONObject parseJsonObject(URL url) throws IOException {
        String path = url.toString();
        if (path.startsWith("file:")) {
            return FileExecutor.parseJsonObject(NetUtils.urlToString(url));
        }
        return JSONObject.parseObject((String)FileExecutor.read(url));
    }

    public static JSONObject parseJsonObject(String file) throws IOException {
        return FileExecutor.parseJsonObject(new File(file));
    }

    public static JSONObject parseJsonObject(File file) throws IOException {
        return JSONObject.parseObject((String)FileExecutor.readFile(file));
    }

    public static void renameTo(String sourceFile, String destFile) {
        FileExecutor.renameTo(new File(sourceFile), new File(destFile));
    }

    public static void renameTo(File sourceFile, File destFile) {
        if (sourceFile.exists() && !destFile.exists()) {
            FileExecutor.createFolder(destFile.getParent());
            sourceFile.renameTo(destFile);
        }
    }

    public static File[] listFile(String director) {
        return FileExecutor.listFile(new File(director));
    }

    public static File[] listFile(File director) {
        String basePath = director.getAbsolutePath() + ValueConsts.SEPARATOR;
        String[] filePath = director.list();
        File[] files = null;
        if (Checker.isNotNull(filePath)) {
            files = new File[filePath.length];
            int i = 0;
            for (String s : filePath) {
                files[i++] = new File(basePath + s);
            }
        }
        return files;
    }

    public static String getSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String getSuffix(File file) {
        return FileExecutor.getSuffix(file.getName());
    }

    public static String getFileSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getFileSuffix(File file) {
        return FileExecutor.getFileSuffix(file.getName());
    }

    public static String[] scanFolderAsArray(String folder) {
        List<String> list = FileExecutor.scanFolder(folder);
        String[] arrays = new String[list.size()];
        int i = 0;
        for (String item : list) {
            arrays[i++] = item;
        }
        return arrays;
    }

    public static List<String> scanFolder(String folder) {
        return FileExecutor.scanFolder(new File(folder));
    }

    public static List<String> scanFolder(File folder) {
        String[] children;
        String parent = folder.getAbsolutePath() + ValueConsts.SEPARATOR;
        ArrayList<String> list = new ArrayList<String>(16);
        if (folder.isDirectory() && Checker.isNotNull(children = folder.list())) {
            for (String child : children) {
                File file = new File(parent + child);
                if (file.isDirectory()) {
                    list.addAll(FileExecutor.scanFolder(file));
                    continue;
                }
                list.add(file.getAbsolutePath());
            }
        }
        return list;
    }

    public static String read(String url) throws IOException {
        return FileExecutor.read(new URL(url));
    }

    public static String read(URL url) throws IOException {
        return NetUtils.getDataOfUrl(url);
    }

    public static String read(InputStream is, int off, int len) throws IOException {
        byte[] bs = new byte[len];
        is.read(bs, off, len);
        return new String(bs);
    }

    public static String read(InputStream is) throws IOException {
        return FileExecutor.read(is, 0, is.available());
    }

    public static void copyDirectories(String[] directories, String storageFolder) throws IOException {
        FileExecutor.copyDirectories(FileExecutor.getFiles(directories), storageFolder);
    }

    public static void copyDirectories(File[] directories, String storageFolder) throws IOException {
        storageFolder = FileExecutor.checkFolder(storageFolder) + ValueConsts.SEPARATOR;
        for (File directory : directories) {
            FileExecutor.copyDirectory((File)directory, (File)new File(storageFolder + directory.getName()));
        }
    }

    public static void copyDirectories(String[] directories, String[] destinationDirectories) throws IOException {
        FileExecutor.copyDirectories(FileExecutor.getFiles(directories), FileExecutor.getFiles(destinationDirectories));
    }

    public static void copyDirectories(File[] directories, File[] destinationDirectories) throws IOException {
        int length = Integer.min(directories.length, destinationDirectories.length);
        for (int i = 0; i < length; ++i) {
            FileExecutor.copyDirectory((File)directories[i], (File)destinationDirectories[i]);
        }
    }

    public static void copyFiles(String[] files, String storageFolder) throws IOException {
        FileExecutor.copyFiles(FileExecutor.getFiles(files), storageFolder);
    }

    public static void copyFiles(String[] files, String[] destinationFiles) throws IOException {
        FileExecutor.copyFiles(FileExecutor.getFiles(files), FileExecutor.getFiles(destinationFiles));
    }

    public static boolean createFolder(String directory) {
        return FileExecutor.createFolder(new File(directory));
    }

    public static boolean createFolder(File director) {
        return director.exists() || FileExecutor.createFolder(director.getParent()) && director.mkdir();
    }

    private static String checkFolder(String directory) {
        File dir = new File(directory);
        if (dir.isFile()) {
            directory = dir.getParent();
        }
        FileExecutor.createFolder(directory);
        return directory;
    }

    public static void copyFiles(File[] files, String storageFolder) throws IOException {
        storageFolder = FileExecutor.checkFolder(storageFolder) + ValueConsts.SEPARATOR;
        for (File file : files) {
            FileExecutor.copyFile((File)file, (File)new File(storageFolder + file.getName()));
        }
    }

    public static void copyFiles(File[] files, File[] destinationFiles) throws IOException {
        int length = Integer.min(files.length, destinationFiles.length);
        for (int i = 0; i < length; ++i) {
            FileExecutor.copyFile((File)files[i], (File)destinationFiles[i]);
        }
    }

    public static void splitFile(String filePath, long[] splitPoints) throws IOException {
        FileExecutor.splitFile(new File(filePath), splitPoints);
    }

    public static void splitFile(File file, long[] splitPoints) throws IOException {
        FileExecutor.splitFile(file, splitPoints, file.getParent());
    }

    public static void splitFile(String filePath, long[] splitPoints, String storageFolder) throws IOException {
        FileExecutor.splitFile(new File(filePath), splitPoints, storageFolder);
    }

    public static void splitFile(File file, long[] splitPoints, String storageFolder) throws IOException {
        splitPoints = ArrayUtils.concatArrays(new long[]{0L}, splitPoints, {file.length()});
        String[] fileName = file.getName().split("\\.", 2);
        storageFolder = storageFolder + ValueConsts.SEPARATOR;
        logger.info((Object)("start to split file '" + file.getAbsolutePath() + "'"));
        for (int i = 0; i < splitPoints.length - 1; ++i) {
            long length;
            long start = splitPoints[i];
            long end = splitPoints[i + 1];
            String filePath = storageFolder + fileName[0] + "_" + (i + 1) + "." + fileName[1];
            FileExecutor.createNewFile(filePath);
            for (length = end - start; length > Integer.MAX_VALUE; length -= Integer.MAX_VALUE) {
                FileExecutor.saveFile(filePath, FileExecutor.readFile(file, start, Integer.MAX_VALUE), true);
                start += Integer.MAX_VALUE;
            }
            if (length <= 0L) continue;
            FileExecutor.saveFile(filePath, FileExecutor.readFile(file, start, (int)length), true);
        }
    }

    public static void renameFiles(String folder, String prefix, String suffix, int start) {
        FileExecutor.renameFiles(FileExecutor.scanFolderAsArray(folder), prefix, suffix, start);
    }

    public static void renameFiles(String[] filePath, String prefix, String suffix, int start) {
        FileExecutor.renameFiles(FileExecutor.getFiles(filePath), prefix, suffix, start);
    }

    public static void renameFiles(File[] filePath, String prefix, String suffix, int start) {
        String[] fileNames = new String[filePath.length];
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = prefix + start++ + suffix;
        }
        FileExecutor.renameFiles(filePath, fileNames);
    }

    public static void renameFiles(String folder, String[] fileNames) {
        FileExecutor.renameFiles(FileExecutor.scanFolderAsArray(folder), fileNames);
    }

    public static void renameFiles(String[] filePath, String[] fileNames) {
        FileExecutor.renameFiles(FileExecutor.getFiles(filePath), fileNames);
    }

    public static void renameFiles(File[] files, String[] fileNames) {
        int length = Integer.min(files.length, fileNames.length);
        for (int i = 0; i < length; ++i) {
            String fileName = files[i].getParent() + ValueConsts.SEPARATOR + fileNames[i];
            if (!fileName.contains(".")) {
                fileName = fileName + files[i].getName().substring(files[i].getName().lastIndexOf("."));
            }
            if (files[i].renameTo(new File(fileName))) {
                logger.info((Object)("rename file '" + files[i].getAbsolutePath() + "' to '" + fileName + "'"));
                continue;
            }
            logger.info((Object)("rename file '" + files[i].getAbsolutePath() + "' error"));
        }
    }

    public static void mergeFiles(String[] filePath, String destinationFilePath, String filterRegex) throws IOException {
        FileExecutor.mergeFiles(FileExecutor.getFiles(filePath), new File(destinationFilePath), filterRegex);
    }

    public static void mergeFiles(File[] files, File destinationFile, String filterRegex) throws IOException {
        FileExecutor.createNewFile(destinationFile);
        for (File file : files) {
            FileExecutor.mergeFiles(file, destinationFile, filterRegex);
        }
    }

    public static void mergeFiles(String[] filePath, String destinationFilePath, String[] filterRegex) throws IOException {
        FileExecutor.mergeFiles(FileExecutor.getFiles(filePath), new File(destinationFilePath), filterRegex);
    }

    public static void mergeFiles(File[] files, File destinationFile, String[] filterRegex) throws IOException {
        if (filterRegex.length < files.length) {
            filterRegex = ArrayUtils.concatArrays(filterRegex, new String[][]{new String[files.length - filterRegex.length]});
        }
        FileExecutor.createNewFile(destinationFile);
        int i = 0;
        for (File file : files) {
            FileExecutor.mergeFiles(file, destinationFile, filterRegex[i++]);
        }
    }

    public static File[] getFiles(String[] filePath) {
        return FileExecutor.getFiles(Arrays.asList(filePath));
    }

    public static File[] getFiles(List<String> paths) {
        File[] files = new File[paths.size()];
        int i = 0;
        for (String file : paths) {
            files[i++] = new File(file);
        }
        return files;
    }

    private static void mergeFiles(File file, File destinationFile, String filter) throws IOException {
        String content = FileExecutor.readFile(file);
        if (Checker.isNotEmpty(filter)) {
            content = content.replaceAll(filter, "");
        }
        FileExecutor.saveFile(destinationFile, content, true);
    }

    public static boolean createFile(String filePath) throws IOException {
        return FileExecutor.createFile(new File(filePath));
    }

    public static boolean createFile(File file) throws IOException {
        return file.exists() || file.createNewFile();
    }

    public static boolean createNewFile(String filePath) throws IOException {
        return FileExecutor.createNewFile(new File(filePath));
    }

    public static boolean createNewFile(File file) throws IOException {
        FileExecutor.createFolder(file.getParent());
        return (!file.exists() || file.delete()) && file.createNewFile();
    }

    public static boolean deleteFile(String filePath) {
        return FileExecutor.deleteFile(new File(filePath));
    }

    public static boolean deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                try {
                    FileExecutor.deleteDirectory((File)file);
                    return true;
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                    return false;
                }
            }
            return file.delete();
        }
        return false;
    }

    public static void saveFile(String path, String content) throws IOException {
        FileExecutor.saveFile(path, content, false);
    }

    public static void saveFile(String path, String content, boolean append) throws IOException {
        FileExecutor.saveFile(new File(path), content, append);
    }

    public static void saveFile(File file, String content) throws IOException {
        FileExecutor.saveFile(file, content, false);
    }

    public static String readFile(String path) throws IOException {
        return FileExecutor.readFile(new File(path));
    }

    public static String readFile(File file) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\r\n");
            }
        }
        return content.toString();
    }

    public static String readFile(File file, long start, int length) throws IOException {
        byte[] bs = new byte[length];
        try (FileInputStream fis = new FileInputStream(file);){
            fis.skip(start);
            fis.read(bs);
        }
        return new String(bs);
    }

    public static void saveLogFile(String logPath, String content) throws IOException {
        File file = new File(logPath);
        if (file.exists()) {
            content = content + FileExecutor.readFile(file);
        }
        FileExecutor.saveFile(file, content);
    }

    public static synchronized void saveFile(File file, String content, boolean append) throws IOException {
        if (Checker.isNotNull(file)) {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (BufferedWriter out = new BufferedWriter(new FileWriter(file, append));){
                out.write(content);
            }
            logger.info((Object)("save file '" + file.getAbsolutePath() + "' success"));
        }
    }
}

