/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.zhazhapan.modules.constant.ValueConsts;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.Formatter;
import com.zhazhapan.util.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class Downloader {
    private static Logger logger = Logger.getLogger(Downloader.class);
    private static String storageFolder = ValueConsts.USER_HOME + ValueConsts.SEPARATOR + "util";

    private Downloader() {
    }

    public static boolean download(String storageFolder, String downloadURL) {
        Downloader.storageFolder = storageFolder;
        return Downloader.download(downloadURL);
    }

    public static boolean download(String downloadURL) {
        if (!Checker.isHyperLink(downloadURL) || !Downloader.checkDownloadPath()) {
            logger.info((Object)"url or storage path are invalidated, can't download");
            return false;
        }
        logger.info((Object)("ready for download url: " + downloadURL + " storage in " + storageFolder));
        String log = "download success from url '" + downloadURL + "' to local '";
        try {
            int byteRead;
            String fileName = Downloader.checkPath(storageFolder + ValueConsts.SEPARATOR + Formatter.getFileName(downloadURL));
            String tmp = fileName + ".tmp";
            File file = new File(tmp);
            log = log + file.getAbsolutePath() + "'";
            URL url = new URL(downloadURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream inStream = NetUtils.getInputStreamOfConnection(conn);
            if (conn.getResponseCode() != 200 || conn.getContentLength() <= 0) {
                return false;
            }
            FileOutputStream fs = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] buffer = new byte[1024];
            while ((byteRead = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteRead);
            }
            fs.flush();
            inStream.close();
            fs.close();
            file.renameTo(new File(fileName));
            logger.info((Object)log);
            return true;
        }
        catch (IOException e) {
            log = log.replace("success", "error") + ", message: " + e.getMessage();
            logger.error((Object)log);
            return false;
        }
    }

    private static String checkPath(String path) {
        File file = new File(path);
        int idx = path.lastIndexOf(".");
        String post = "";
        if (idx > -1) {
            post = path.substring(idx);
            path = path.substring(0, idx);
        }
        int i = 0;
        while (file.exists()) {
            file = new File(path + "_" + ++i + post);
        }
        return file.getAbsolutePath();
    }

    private static boolean checkDownloadPath() {
        if (Checker.isNotEmpty(storageFolder)) {
            File file = new File(storageFolder);
            if (!file.exists() && file.mkdirs()) {
                logger.info((Object)("mkdir '" + storageFolder + "' success"));
            }
            return true;
        }
        return false;
    }

    public static String getStorageFolder() {
        return storageFolder;
    }

    public static void setStorageFolder(String storageFolder) {
        Downloader.storageFolder = storageFolder;
    }
}

