/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.zhazhapan.util.Formatter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static Calendar calendar = Calendar.getInstance();

    private DateUtils() {
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrentMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static String getDay(String date) {
        return date.split(" ")[0].substring(8);
    }

    public static String getDay(Date date) {
        return DateUtils.getDay(Formatter.dateToString(date));
    }

    public static String getMonth(String date) {
        return date.substring(5, 7);
    }

    public static String getMonth(Date date) {
        return DateUtils.getMonth(Formatter.dateToString(date));
    }

    public static String getYear(String date) {
        return date.substring(0, 4);
    }

    public static String getYear(Date date) {
        return DateUtils.getYear(Formatter.dateToString(date));
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getWeekAsChinese(String date) throws ParseException, Exception {
        return DateUtils.getWeekAsChinese(Formatter.stringToDate(date));
    }

    public static String getWeekAsChinese(Date date) throws Exception {
        String result;
        switch (DateUtils.getWeek(date)) {
            case 1: {
                result = "\u65e5";
                break;
            }
            case 2: {
                result = "\u4e00";
                break;
            }
            case 3: {
                result = "\u4e8c";
                break;
            }
            case 4: {
                result = "\u4e09";
                break;
            }
            case 5: {
                result = "\u56db";
                break;
            }
            case 6: {
                result = "\u4e94";
                break;
            }
            case 7: {
                result = "\u516d";
                break;
            }
            default: {
                throw new Exception("something error, get week failed");
            }
        }
        return "\u661f\u671f" + result;
    }

    public static int getWeek(String date) throws ParseException {
        return DateUtils.getWeek(Formatter.stringToDate(date));
    }

    public static int getWeek(Date date) {
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static Date addHour(String date, int amount) throws ParseException {
        return DateUtils.add(date, 10, amount);
    }

    public static Date addMinute(String date, int amount) throws ParseException {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSecond(String date, int amount) throws ParseException {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addYear(String date, int amount) throws ParseException {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonth(String date, int amount) throws ParseException {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addDay(String date, int amount) throws ParseException {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHour(Date date, int amount) {
        return DateUtils.add(date, 10, amount);
    }

    public static Date addMinute(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSecond(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addYear(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonth(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addDay(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date add(String date, int field, int amount) throws ParseException {
        return DateUtils.add(Formatter.stringToDatetime(date), field, amount);
    }

    public static Date add(Date date, int field, int amount) {
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }
}

