/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import cn.hutool.core.util.StrUtil;
import com.zhazhapan.util.LoggerUtils;
import com.zhazhapan.util.NetUtils;
import com.zhazhapan.util.ReflectUtils;
import com.zhazhapan.util.Utils;
import com.zhazhapan.util.annotation.FieldChecking;
import com.zhazhapan.util.interfaces.IChecker;
import com.zhazhapan.util.model.CheckResult;
import com.zhazhapan.util.model.ResultObject;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class Checker {
    public static final Pattern HYPER_LINK_PATTERN = Pattern.compile("^(https*://)?([^\\s&;\"':<>]+\\.)+[a-z0-9]+(/[^\\s]*)*$", 2);
    public static final Pattern DATE_PATTERN = Pattern.compile("^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$");
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]+$");
    public static final Pattern DECIMAL_PATTERN = Pattern.compile("^[0-9]+(\\.[0-9]+)?$");
    public static final Pattern EMAIL_PATTERN = Pattern.compile("^[0-9a-z\\-]+([0-9a-z\\-]|(\\.[0-9a-z\\-]+))*@[0-9a-z\\-]+(\\.[0-9a-z\\-]+)+$", 2);
    public static final Pattern IMAGES_PATTERN = Pattern.compile(".*\\.(bmp|gif|jpe?g|png|tiff?|pcx|tga|svg|pic)$", 2);

    private Checker() {
    }

    public static boolean endsWith(String value, String ... suffixes) {
        if (Checker.isNotEmpty(value) && Checker.isNotEmpty(suffixes)) {
            for (String suffix : suffixes) {
                if (!value.endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWith(String value, String ... prefixes) {
        if (Checker.isNotEmpty(value) && Checker.isNotEmpty(prefixes)) {
            for (String prefix : prefixes) {
                if (!value.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSpace(String string) {
        return string.contains(" ");
    }

    public static boolean isNotEmptyOr(String ... strings) {
        return !Checker.isEmptyAnd(strings);
    }

    public static boolean isNotEmptyAnd(String ... strings) {
        return !Checker.isEmptyOr(strings);
    }

    public static boolean isEmptyOr(String ... strings) {
        if (Checker.isNotNull(strings)) {
            for (String string : strings) {
                if (!Checker.isEmpty(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isEmptyAnd(String ... strings) {
        if (Checker.isNotNull(strings)) {
            for (String string : strings) {
                if (!Checker.isNotEmpty(string)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEnded(Date date) {
        return date.before(new Date());
    }

    public static boolean isEnded(long timestamp) {
        return timestamp < System.currentTimeMillis();
    }

    public static boolean isStarted(Date date) {
        return date.after(new Date());
    }

    public static boolean isStarted(long timestamp) {
        return timestamp > System.currentTimeMillis();
    }

    public static CheckResult checkBean(Object bean) {
        return Checker.checkBean(bean, new HashMap<String, Object>(2));
    }

    public static CheckResult checkBean(Object bean, Map<String, Object> map) {
        FieldChecking checking;
        CheckResult result = new CheckResult();
        if (Checker.isNull(bean)) {
            result.passed = false;
            result.resultObject = CheckResult.getErrorResult();
            return result;
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        ResultObject object = new ResultObject();
        for (Field field : fields) {
            Object value;
            FieldChecking checking2 = field.getAnnotation(FieldChecking.class);
            if (!Checker.isNotNull(checking2)) continue;
            field.setAccessible(true);
            String expression = checking2.expression();
            try {
                value = field.get(bean);
            }
            catch (IllegalAccessException e) {
                LoggerUtils.error("get value from field[{}] error: " + e.getMessage(), field.getName());
                object.status = "error";
                object.message = "\u83b7\u53d6\u53c2\u6570\u503c\u5931\u8d25";
                object.code = 501;
                result.passed = false;
                break;
            }
            if (Checker.isNull(value) && Checker.isNotEmpty(checking2.defaultValue())) {
                try {
                    field.set(bean, checking2.defaultValue());
                    continue;
                }
                catch (IllegalAccessException e) {
                    LoggerUtils.error("set default to field[{}] error: " + e.getMessage(), field.getName());
                }
            }
            if (Checker.isEmpty(expression)) {
                result.passed = Checker.isNotNull(value);
                if (result.passed) {
                    result.passed = field.getType() == Number.class ? (Double)value >= 0.0 : Checker.isNotEmpty(value.toString());
                }
            } else if (expression.startsWith(":")) {
                result.passed = Checker.isNotNull(value);
                if (result.passed) {
                    result.passed = Pattern.compile(expression.substring(1)).matcher(value.toString()).matches();
                }
            } else {
                result.passed = true;
                if (!expression.contains("null")) {
                    result.passed = Checker.isNotNull(value);
                }
                if (result.passed) {
                    map.put("val", value);
                    Object res = ReflectUtils.executeExpression(expression, map);
                    boolean bl = result.passed = res instanceof Boolean && (Boolean)res != false;
                }
            }
            if (result.passed) continue;
            object.code = checking2.code();
            object.message = StrUtil.format((CharSequence)checking2.message(), (Object[])new Object[]{field.getName()});
            object.status = checking2.status();
            break;
        }
        if (result.passed && Checker.isNotNull(checking = bean.getClass().getAnnotation(FieldChecking.class))) {
            object.code = checking.code();
            object.message = checking.message();
            object.status = checking.status();
        }
        result.resultObject = object;
        return result;
    }

    public static boolean isLetterAndNumber(String string) {
        boolean result = Checker.isNotEmpty(string);
        int len = string.length();
        for (int idx = 0; result && idx < len; ++idx) {
            char c = string.charAt(idx);
            result = Checker.isLetter(c) || Checker.isNumber(c);
        }
        return result;
    }

    public static boolean isNumber(char c) {
        return Checker.isNotNull(Character.valueOf(c)) && c >= '0' && c <= '9';
    }

    public static boolean isLetter(String string) {
        boolean result = Checker.isNotEmpty(string);
        int len = string.length();
        for (int idx = 0; result && idx < len; ++idx) {
            result = Checker.isLetter(string.charAt(idx));
        }
        return result;
    }

    public static boolean isLetter(char c) {
        return Checker.isLowerCase(c) || Checker.isUpperCase(c);
    }

    public static boolean isLowerCase(String string) {
        return Checker.isNotEmpty(string) && string.equals(string.toLowerCase());
    }

    public static boolean isOnlyLowerCase(String string) {
        boolean result = Checker.isNotEmpty(string);
        int len = string.length();
        for (int idx = 0; result && idx < len; ++idx) {
            result = Checker.isLowerCase(string.charAt(idx));
        }
        return result;
    }

    public static boolean isLowerCase(char c) {
        return Checker.isNotNull(Character.valueOf(c)) && c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(String string) {
        return Checker.isNotEmpty(string) && string.equals(string.toUpperCase());
    }

    public static boolean isOnlyUpperCase(String string) {
        boolean result = Checker.isNotEmpty(string);
        int len = string.length();
        for (int idx = 0; result && idx < len; ++idx) {
            result = Checker.isUpperCase(string.charAt(idx));
        }
        return result;
    }

    public static boolean isUpperCase(char c) {
        return Checker.isNotNull(Character.valueOf(c)) && c >= 'A' && c <= 'Z';
    }

    public static boolean isAjax(HttpServletRequest request) {
        return NetUtils.isAjax(request);
    }

    public static <T> boolean isNotEmpty(T[] ts) {
        return Checker.isNotNull(ts) && ts.length > 0;
    }

    public static <T> boolean isEmpty(T[] ts) {
        return Checker.isNull(ts) || Checker.isNotNullButEmpty(ts);
    }

    public static <T> boolean isNotNullButEmpty(T[] ts) {
        return Checker.isNotNull(ts) && ts.length < 1;
    }

    public static <T> T getNotNull(T ... ts) {
        if (Checker.isNotEmpty(ts)) {
            for (T t : ts) {
                if (!Checker.isNotNull(t)) continue;
                return t;
            }
        }
        return null;
    }

    public static <T> T getNotNullWithException(T ... ts) throws Exception {
        if (Checker.isNotNull(ts)) {
            for (T t : ts) {
                if (!Checker.isNotNull(t)) continue;
                return t;
            }
        }
        throw new Exception("ops, no value found while value is not null.");
    }

    public static <T> boolean isIn(T t, List<T> ts) {
        return Checker.isIn(t, ts.toArray());
    }

    public static <T> boolean isIn(T t, T ... ts) {
        if (Checker.isNotNull(t) && Checker.isNotNull(ts)) {
            for (T object : ts) {
                if (!t.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isNotIn(T t, T ... ts) {
        return !Checker.isIn(t, ts);
    }

    public static <T> boolean isNotIn(T t, List<T> ts) {
        return Checker.isNotIn(t, ts.toArray());
    }

    public static boolean isImage(File file) {
        return Checker.isNotNull(file) && Checker.isImage(file.getName());
    }

    public static boolean isImage(String file) {
        return Checker.isNotEmpty(file) && IMAGES_PATTERN.matcher(file).matches();
    }

    public static boolean isNotExists(String file) {
        return !Checker.isExists(file);
    }

    public static boolean isExists(String file) {
        return new File(Checker.checkNull(file)).exists();
    }

    public static boolean isLimited(String string, int min, int max) {
        return Checker.isNotEmpty(string) && string.length() >= min && string.length() <= max;
    }

    public static boolean isWindows() {
        return Utils.getCurrentOS().startsWith("windows");
    }

    public static boolean isMacOS() {
        return Utils.getCurrentOS().startsWith("mac");
    }

    public static boolean isLinux() {
        return Utils.getCurrentOS().startsWith("linux");
    }

    public static boolean isSorted(int[] nums) {
        boolean desc = nums[0] - nums[nums.length - 1] >= 0;
        for (int i = 0; i < nums.length - 1; ++i) {
            if (!desc && nums[i] > nums[i + 1]) {
                return false;
            }
            if (!desc || nums[i] >= nums[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isDate(String date) {
        return Checker.isNotNull(date) && DATE_PATTERN.matcher(date).matches();
    }

    public static String replace(String string, char oldChar, char newChar) {
        return Checker.checkNull(string).replace(oldChar, newChar);
    }

    public static String replace(String string, String oldString, String newString) {
        return Checker.checkNull(string).replace(oldString, newString);
    }

    public static boolean isEmail(String email) {
        return Checker.isNotEmpty(email) && EMAIL_PATTERN.matcher(email).matches();
    }

    public static boolean isDecimal(String decimal) {
        return Checker.isNotEmpty(decimal) && DECIMAL_PATTERN.matcher(decimal).matches();
    }

    public static boolean isNumber(String number) {
        return Checker.isNotEmpty(number) && NUMBER_PATTERN.matcher(number).matches();
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return !Checker.isNull(object);
    }

    public static boolean isEmpty(int[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(int[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(byte[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(short[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(short[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(long[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(long[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(float[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(float[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(double[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(double[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(boolean[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isEmpty(char[] array) {
        return Checker.isNull(array) || array.length == 0;
    }

    public static boolean isNotEmpty(char[] array) {
        return !Checker.isEmpty(array);
    }

    public static boolean isNullOrEmpty(String string) {
        return Checker.isEmpty(string);
    }

    public static boolean isEmpty(String string) {
        return Checker.isNull(string) || string.isEmpty();
    }

    public static boolean isNotEmpty(String string) {
        return !Checker.isEmpty(string);
    }

    public static String checkNull(String value) {
        return Checker.checkNull(value, "");
    }

    public static String checkNull(String value, String elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Double checkNull(Double value, Double elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Double checkNull(Double value, double elseValue) {
        return Checker.checkNull(value, (Double)elseValue);
    }

    public static Double checkNull(Double value) {
        return Checker.checkNull(value, 0.0);
    }

    public static Integer checkNull(Integer value, Integer elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Integer checkNull(Integer value, int elseValue) {
        return Checker.checkNull(value, (Integer)elseValue);
    }

    public static Integer checkNull(Integer value) {
        return Checker.checkNull(value, 0);
    }

    public static Long checkNull(Long value, Long elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Long checkNull(Long value, long elseValue) {
        return Checker.checkNull(value, (Long)elseValue);
    }

    public static Long checkNull(Long value) {
        return Checker.checkNull(value, 0L);
    }

    public static Float checkNull(Float value, Float elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Float checkNull(Float value, float elseValue) {
        return Checker.checkNull(value, Float.valueOf(elseValue));
    }

    public static Float checkNull(Float value) {
        return Checker.checkNull(value, 0.0f);
    }

    public static Short checkNull(Short value, Short elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Short checkNull(Short value, short elseValue) {
        return Checker.checkNull(value, (Short)elseValue);
    }

    public static Short checkNull(Short value) {
        short s = 0;
        return Checker.checkNull(value, s);
    }

    public static Character checkNull(Character value, Character elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }

    public static Character checkNull(Character value, char elseValue) {
        return Checker.checkNull(value, Character.valueOf(elseValue));
    }

    public static Character checkNull(Character value) {
        return Checker.checkNull(value, '0');
    }

    public static <T> T check(T value, T elseValue, boolean res) {
        return res ? value : elseValue;
    }

    public static <T> T check(T value, T elseValue, IChecker checker) {
        return Checker.check(value, elseValue, checker.check());
    }

    public static long checkNull(long longNum) {
        return longNum;
    }

    public static boolean isNotEmpty(List<?> list) {
        return !Checker.isEmpty(list);
    }

    public static boolean isEmpty(List<?> list) {
        return Checker.isNull(list) || list.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !Checker.isEmpty(map);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Checker.isNull(map) || map.isEmpty();
    }

    public static boolean isHyperLink(String hyperLink) {
        return Checker.isNotEmpty(hyperLink) && HYPER_LINK_PATTERN.matcher(hyperLink).matches();
    }

    public static Date checkDate(Date date) {
        return Checker.checkNull(date);
    }

    public static Date checkNull(Date value) {
        return Checker.checkNull(value, new Date());
    }

    public static Date checkNull(Date value, Date elseValue) {
        return Checker.isNull(value) ? elseValue : value;
    }
}

