/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import java.math.BigDecimal;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Calculator {
    private static final String CALCULATION_FORMULA_PATTERN_STRING = "\\((\\d+(\\.\\d+)?([+\\-*/]))*\\d+(\\.\\d+)?\\)";
    private static final Pattern FORMULA_REPLACE_PATTERN = Pattern.compile("\\((\\d+(\\.\\d+)?([+\\-*/]))*\\d+(\\.\\d+)?\\)");
    private static final Pattern CALCULATION_FORMULA_PATTERN = Pattern.compile("\\((\\d+(\\.\\d+)?([+\\-*/]))*\\d+(\\.\\d+)?\\)".substring(2, "\\((\\d+(\\.\\d+)?([+\\-*/]))*\\d+(\\.\\d+)?\\)".length() - 2) + "=?");
    private static int precision = 100;

    private Calculator() {
    }

    public static BigDecimal calculate(String formula) throws Exception {
        if (Calculator.isFormula(formula = formula.replaceAll("\\s", ""))) {
            return Calculator.doCalculate(formula);
        }
        throw new Exception("calculation formula is not valid, please check up on it carefully.");
    }

    public static boolean isFormula(String formula) {
        while (FORMULA_REPLACE_PATTERN.matcher(formula).find()) {
            formula = formula.replaceAll(CALCULATION_FORMULA_PATTERN_STRING, "0");
        }
        return CALCULATION_FORMULA_PATTERN.matcher(formula).matches();
    }

    private static BigDecimal doCalculate(String formula) throws Exception {
        Stack<BigDecimal> stack = new Stack<BigDecimal>();
        BigDecimal result = BigDecimal.valueOf(0L);
        BigDecimal number = BigDecimal.valueOf(0L);
        int sign = 43;
        boolean isDecimal = false;
        BigDecimal decimalSign = new BigDecimal(0.1);
        for (int i = 0; i < formula.length(); ++i) {
            boolean isNotDigit;
            char c = formula.charAt(i);
            if (Character.isDigit(c)) {
                BigDecimal num = new BigDecimal(c - 48);
                number = isDecimal ? number.add(num.multiply(decimalSign)) : num.add(number.multiply(BigDecimal.valueOf(10L)));
                decimalSign = decimalSign.multiply(BigDecimal.valueOf(0.1));
            } else if (c == '.') {
                isDecimal = true;
                decimalSign = BigDecimal.valueOf(0.1);
            } else if (c == '(') {
                BigDecimal[] res = Calculator.calculateInlineFormula(i + 1, formula);
                number = number.compareTo(BigDecimal.valueOf(0L)) == 0 ? res[0] : number.multiply(res[0]);
                i = res[1].intValue();
            }
            boolean bl = isNotDigit = !Character.isDigit(c) && c != '.' && c != '(' || i == formula.length() - 1;
            if (!isNotDigit) continue;
            if (sign == 43) {
                stack.push(number);
            } else if (sign == 45) {
                stack.push(number.multiply(BigDecimal.valueOf(-1L)));
            } else if (sign == 42) {
                stack.push(number.multiply((BigDecimal)stack.pop()));
            } else if (sign == 47) {
                stack.push(((BigDecimal)stack.pop()).divide(number, Calculator.getPrecision(), 4));
            }
            sign = c;
            isDecimal = false;
            number = BigDecimal.valueOf(0L);
        }
        for (BigDecimal i : stack) {
            result = result.add(i);
        }
        return result.setScale(Calculator.getPrecision(), 4);
    }

    private static BigDecimal[] calculateInlineFormula(int start, String formula) throws Exception {
        BigDecimal[] result = new BigDecimal[2];
        StringBuilder inlineFormula = new StringBuilder();
        while (start < formula.length()) {
            char c = formula.charAt(start);
            if (c == '(') {
                BigDecimal[] res = Calculator.calculateInlineFormula(start + 1, formula);
                inlineFormula.append(res[0]);
                start = res[1].intValue();
            } else {
                if (c == ')') break;
                inlineFormula.append(c);
            }
            ++start;
        }
        result[0] = Calculator.calculate(inlineFormula.toString());
        result[1] = BigDecimal.valueOf(start);
        return result;
    }

    public static Object calculateUseEval(String formula) throws ScriptException {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine jsEngine = mgr.getEngineByName("JavaScript");
        return jsEngine.eval(formula);
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int precision) {
        Calculator.precision = precision;
    }
}

