/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.Formatter;
import com.zhazhapan.util.annotation.ToJsonString;
import com.zhazhapan.util.enums.FieldModifier;
import com.zhazhapan.util.enums.JsonMethod;
import com.zhazhapan.util.enums.JsonType;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BeanUtils {
    private static final JsonMethod[] METHODS = new JsonMethod[]{JsonMethod.MANUAL, JsonMethod.HANDLE};

    private BeanUtils() {
    }

    public static <T> T deserialize(String file, Class<T> clazz) throws IOException, ClassNotFoundException {
        return (T)TypeUtils.castToJavaBean((Object)BeanUtils.deserialize(file), clazz);
    }

    public static Object deserialize(String file) throws IOException, ClassNotFoundException {
        FileInputStream fileIn = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fileIn);
        Object object = in.readObject();
        in.close();
        fileIn.close();
        return object;
    }

    public static void serialize(Object object, String file) throws Exception {
        if (!(object instanceof Serializable)) {
            throw new Exception(object.getClass().getName() + " doesn't implements serializable interface");
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fileOut);
        out.writeObject(object);
        out.close();
        fileOut.close();
    }

    public static JSONObject toJsonObject(Object object) {
        return (JSONObject)JSONObject.toJSON((Object)object);
    }

    public static JSONObject beanToJson(Object object) throws IllegalAccessException, InvocationTargetException {
        Method[] methods = object.getClass().getMethods();
        JSONObject jsonObject = new JSONObject();
        for (Method method : methods) {
            String name = method.getName();
            if (name.startsWith("get") && !"getClass".equals(name)) {
                name = name.substring(3);
                jsonObject.put(name.substring(0, 1).toLowerCase() + name.substring(1), method.invoke(object, new Object[0]));
                continue;
            }
            if (!name.startsWith("is")) continue;
            jsonObject.put(name, method.invoke(object, new Object[0]));
        }
        return jsonObject;
    }

    public static void jsonPutIn(JSONObject jsonObject, Object object) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            field.set(object, TypeUtils.castToJavaBean((Object)jsonObject.get((Object)field.getName()), field.getType()));
        }
    }

    public static String toPrettyJson(Object object) throws IllegalAccessException {
        return BeanUtils.toPrettyJson(object, FieldModifier.ALL);
    }

    public static String toPrettyJson(Object object, FieldModifier modifier) throws IllegalAccessException {
        return Formatter.formatJson(BeanUtils.toJsonString(object, modifier));
    }

    public static String toJsonString(Object object) throws IllegalAccessException {
        return BeanUtils.toJsonString(object, FieldModifier.ALL);
    }

    public static String toJsonString(Object object, FieldModifier modifier) throws IllegalAccessException {
        return BeanUtils.toJsonString(object, modifier, JsonMethod.AUTO);
    }

    public static String toJsonString(Object object, FieldModifier modifier, JsonMethod method) throws IllegalAccessException {
        JSONObject jsonObject = new JSONObject();
        StringBuilder builder = new StringBuilder("{");
        boolean isManual = false;
        if (Checker.isNotNull(object)) {
            Field[] fields;
            Class<?> bean = object.getClass();
            for (Field field : fields = bean.getDeclaredFields()) {
                boolean addable;
                int mod = field.getModifiers();
                boolean bl = addable = modifier == FieldModifier.ALL || modifier == FieldModifier.PRIVATE && Modifier.isPrivate(mod) || modifier == FieldModifier.PUBLIC && Modifier.isPublic(mod);
                if (!addable) continue;
                field.setAccessible(true);
                isManual = Checker.isIn(method, METHODS);
                if (isManual) {
                    Object f = field.get(object);
                    if (!Checker.isNotNull(f)) continue;
                    builder.append(BeanUtils.converter(field.getName(), f));
                    continue;
                }
                jsonObject.put(field.getName(), field.get(object));
            }
        }
        return isManual ? builder.substring(0, builder.length() - 1) + "}" : jsonObject.toString();
    }

    public static String toJsonStringByAnnotation(Object object) throws IllegalAccessException {
        Class<?> bean;
        JsonType jsonType = JsonType.CONDENSED;
        FieldModifier modifier = FieldModifier.ALL;
        JsonMethod method = JsonMethod.AUTO;
        if (Checker.isNotNull(object) && (bean = object.getClass()).isAnnotationPresent(ToJsonString.class)) {
            ToJsonString annotation = bean.getAnnotation(ToJsonString.class);
            jsonType = annotation.type();
            modifier = annotation.modifier();
            method = annotation.method();
        }
        String json = BeanUtils.toJsonString(object, modifier, method);
        return jsonType == JsonType.PRETTY ? Formatter.formatJson(json) : json;
    }

    private static String converter(String fieldName, Object object) {
        StringBuilder builder = new StringBuilder();
        if (Checker.isNotEmpty(fieldName)) {
            builder.append("\"").append(fieldName).append("\":");
        }
        if (object instanceof Collection) {
            List list = (List)object;
            builder.append("[");
            list.forEach(obj -> builder.append(BeanUtils.converter("", obj)));
            return builder.substring(0, builder.length() - 1) + "],";
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            builder.append("{");
            map.forEach((k, v) -> builder.append(BeanUtils.converter(k.toString(), v)));
            return builder.substring(0, builder.length() - 1) + "},";
        }
        if (Checker.isEmpty(fieldName)) {
            builder.append("\"").append(object).append("\",");
        } else {
            builder.append("\"").append(object).append("\",");
        }
        return builder.toString();
    }
}

