/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.zhazhapan.util.Checker;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] copyOf(T[] array, int length) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, newArray, 0, Math.min(length, array.length));
        return newArray;
    }

    public static <K, V> V[] mapToArray(Map<K, V> map, Class<V> clazz) {
        if (Checker.isNotEmpty(map)) {
            Object[] array = (Object[])Array.newInstance(clazz, map.size());
            int i = 0;
            for (V v : map.values()) {
                array[i++] = v;
            }
            return array;
        }
        return null;
    }

    public static <K, V> K[] mapKeyToArray(Map<K, V> map, Class<K> clazz) {
        if (Checker.isNotEmpty(map)) {
            Object[] array = (Object[])Array.newInstance(clazz, map.size());
            int i = 0;
            for (K k : map.keySet()) {
                array[i++] = k;
            }
            return array;
        }
        return null;
    }

    public static short[] concatArrays(short[] array, short[] ... arrays) {
        short[] res = array;
        for (short[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((short[])res, (short[])ele);
        }
        return res;
    }

    public static long[] concatArrays(long[] array, long[] ... arrays) {
        long[] res = array;
        for (long[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((long[])res, (long[])ele);
        }
        return res;
    }

    public static float[] concatArrays(float[] array, float[] ... arrays) {
        float[] res = array;
        for (float[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((float[])res, (float[])ele);
        }
        return res;
    }

    public static double[] concatArrays(double[] array, double[] ... arrays) {
        double[] res = array;
        for (double[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((double[])res, (double[])ele);
        }
        return res;
    }

    public static char[] concatArrays(char[] array, char[] ... arrays) {
        char[] res = array;
        for (char[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((char[])res, (char[])ele);
        }
        return res;
    }

    public static byte[] concatArrays(byte[] array, byte[] ... arrays) {
        byte[] res = array;
        for (byte[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((byte[])res, (byte[])ele);
        }
        return res;
    }

    public static boolean[] concatArrays(boolean[] array, boolean[] ... arrays) {
        boolean[] res = array;
        for (boolean[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((boolean[])res, (boolean[])ele);
        }
        return res;
    }

    public static String[] concatArrays(String[] array, String[] ... arrays) {
        Object[] res = array;
        for (Object[] objectArray : arrays) {
            res = (String[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])res, (Object[])objectArray);
        }
        return res;
    }

    public static int[] concatArrays(int[] array, int[] ... arrays) {
        int[] res = array;
        for (int[] ele : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((int[])res, (int[])ele);
        }
        return res;
    }

    @SafeVarargs
    public static <T> T[] concatArrays(T[] array, T[] ... arrays) {
        Object[] res = array;
        for (Object[] objectArray : arrays) {
            res = org.apache.commons.lang3.ArrayUtils.addAll((Object[])res, (Object[])objectArray);
        }
        return res;
    }

    public static int[] mergeSortedArrays(int[] nums1, int[] nums2, boolean ignoreEquals) {
        return ArrayUtils.mergeSortedArrays(nums1, nums2, ignoreEquals, false);
    }

    public static int[] mergeSortedArrays(int[] nums1, int[] nums2, boolean ignoreEquals, boolean desc) {
        int len = nums1.length + nums2.length;
        int[] nums = new int[len];
        int m = 0;
        int n = 0;
        for (int i = 0; i < len; ++i) {
            if (ignoreEquals && m < nums1.length && n < nums2.length && nums1[m] == nums2[n]) {
                if (m < nums1.length - 1) {
                    ++m;
                } else if (n < nums2.length - 1) {
                    ++n;
                }
                --len;
                --i;
                continue;
            }
            boolean inNums1 = n == nums2.length || m != nums1.length && nums1[m] < nums2[n] ^ desc;
            nums[i] = inNums1 ? nums1[m++] : nums2[n++];
        }
        if (nums1.length + nums2.length == len) {
            return nums;
        }
        int[] newNums = new int[len];
        System.arraycopy(nums, 0, newNums, 0, len);
        return newNums;
    }

    public static String[] unique(String[] arrays) {
        ArrayList<String> list = new ArrayList<String>(arrays.length);
        for (String arr : arrays) {
            if (list.contains(arr)) continue;
            list.add(arr);
        }
        String[] res = new String[list.size()];
        int i = 0;
        for (String arr : list) {
            res[i++] = arr;
        }
        return res;
    }

    public static int[] unique(int[] arrays) {
        return ArrayUtils.unique(arrays, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int[] unique(int[] arrays, int min, int max) {
        ArrayList<Integer> list = new ArrayList<Integer>(arrays.length);
        for (int arr : arrays) {
            if (list.contains(arr) || arr < min || arr > max) continue;
            list.add(arr);
        }
        int[] res = new int[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int arr;
            arr = (Integer)iterator.next();
            res[i++] = arr;
        }
        return res;
    }

    public static long[] unique(long[] arrays) {
        return ArrayUtils.unique(arrays, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static long[] unique(long[] arrays, long min, long max) {
        ArrayList<Long> list = new ArrayList<Long>(arrays.length);
        for (long arr : arrays) {
            if (list.contains(arr) || arr < min || arr > max) continue;
            list.add(arr);
        }
        long[] res = new long[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            long arr;
            arr = (Long)iterator.next();
            res[i++] = arr;
        }
        return res;
    }

    public static void heapSort(int[] arrays) {
        int i;
        for (i = arrays.length / 2; i >= 0; --i) {
            ArrayUtils.heapAdjust(arrays, i, arrays.length);
        }
        for (i = arrays.length - 1; i > 0; --i) {
            ArrayUtils.switchNumber(arrays, 0, i);
            ArrayUtils.heapAdjust(arrays, 0, i);
        }
    }

    private static void heapAdjust(int[] arrays, int i, int n) {
        int father = arrays[i];
        while (2 * i + 1 < n) {
            int child = 2 * i + 1;
            if (child != n - 1 && arrays[child] < arrays[child + 1]) {
                ++child;
            }
            if (father >= arrays[child]) break;
            arrays[i] = arrays[child];
            i = child;
        }
        arrays[i] = father;
    }

    public static void mergeSort(int[] arrays) {
        ArrayUtils.mergeSort(arrays, 0, arrays.length - 1);
    }

    private static void mergeSort(int[] arrays, int low, int high) {
        int mid = (low + high) / 2;
        if (low < high) {
            ArrayUtils.mergeSort(arrays, low, mid);
            ArrayUtils.mergeSort(arrays, mid + 1, high);
            ArrayUtils.mergeSort(arrays, low, mid, high);
        }
    }

    private static void mergeSort(int[] arrays, int low, int mid, int high) {
        int[] temp = new int[high - low + 1];
        int i = low;
        int j = mid + 1;
        int k = 0;
        while (i <= mid && j <= high) {
            if (arrays[i] < arrays[j]) {
                temp[k++] = arrays[i++];
                continue;
            }
            temp[k++] = arrays[j++];
        }
        while (i <= mid) {
            temp[k++] = arrays[i++];
        }
        while (j <= high) {
            temp[k++] = arrays[j++];
        }
        System.arraycopy(temp, 0, arrays, low, temp.length);
    }

    public static void shellSort(int[] arrays) {
        int h = 1;
        while (h <= arrays.length / 3) {
            h = h * 3 + 1;
        }
        while (h > 0) {
            for (int i = h; i < arrays.length; i += h) {
                if (arrays[i] >= arrays[i - h]) continue;
                int tmp = arrays[i];
                for (int j = i - h; j >= 0 && arrays[j] > tmp; j -= h) {
                    arrays[j + h] = arrays[j];
                }
                arrays[j + h] = tmp;
            }
            h = (h - 1) / 3;
        }
    }

    public static void selectSort(int[] arrays) {
        for (int i = 0; i < arrays.length; ++i) {
            int lowIndex = i;
            for (int j = i + 1; j < arrays.length; ++j) {
                if (arrays[j] >= arrays[lowIndex]) continue;
                lowIndex = j;
            }
            if (lowIndex == i) continue;
            ArrayUtils.switchNumber(arrays, i, lowIndex);
        }
    }

    public static void quickSort(int[] arrays) {
        ArrayUtils.quickSort(arrays, 0, arrays.length - 1);
    }

    private static void quickSort(int[] arrays, int start, int end) {
        int i = start;
        int j = end;
        if (start >= end) {
            return;
        }
        if (end - start == 1 && arrays[start] > arrays[end]) {
            ArrayUtils.switchNumber(arrays, start, end);
        }
        while (i < j) {
            while (i < j && arrays[j] >= arrays[i]) {
                --j;
            }
            if (i < j) {
                ArrayUtils.switchNumber(arrays, i, j);
            }
            while (i < j && arrays[i] < arrays[j]) {
                ++i;
            }
            if (i < j) {
                ArrayUtils.switchNumber(arrays, i, j);
            }
            if (i - start > 1) {
                ArrayUtils.quickSort(arrays, start, i - 1);
            }
            if (end - i <= 1) continue;
            ArrayUtils.quickSort(arrays, i + 1, end);
        }
    }

    public static void insertSort(int[] arrays) {
        for (int i = 1; i < arrays.length; ++i) {
            int currentNumber = arrays[i];
            int j = i - 1;
            while (j >= 0 && arrays[j] > currentNumber) {
                arrays[j + 1] = arrays[j--];
            }
            arrays[j + 1] = currentNumber;
        }
    }

    public static void bubbleSort(int[] arrays) {
        for (int i = 0; i < arrays.length - 1; ++i) {
            for (int j = 0; j < arrays.length - 1 - i; ++j) {
                if (arrays[j] <= arrays[j + 1]) continue;
                ArrayUtils.switchNumber(arrays, j, j + 1);
            }
        }
    }

    private static void switchNumber(int[] arrays, int i, int j) {
        int temp = arrays[j];
        arrays[j] = arrays[i];
        arrays[i] = temp;
    }
}

