/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.util;

import com.zhazhapan.util.LoggerUtils;
import com.zhazhapan.util.annotation.AopLog;
import java.lang.reflect.Method;

public class AopLogUtils {
    public static String getDescription(String className, String methodName, Object[] args) throws ClassNotFoundException {
        Method[] methods;
        Class<?> targetClass = Class.forName(className);
        for (Method method : methods = targetClass.getMethods()) {
            Class<?>[] clazz;
            if (!method.getName().equals(methodName) || (clazz = method.getParameterTypes()).length != args.length) continue;
            return method.getAnnotation(AopLog.class).value();
        }
        return "";
    }

    public static String getDescriptionNoThrow(String className, String methodName, Object[] args) {
        try {
            return AopLogUtils.getDescription(className, methodName, args);
        }
        catch (ClassNotFoundException e) {
            LoggerUtils.error("get description from {}#{} error: {}", className, methodName, e.getMessage());
            return "";
        }
    }
}

