/*
 * Decompiled with CFR 0.152.
 */
package com.zhazhapan.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.zhazhapan.util.Checker;
import com.zhazhapan.util.FileExecutor;
import com.zhazhapan.util.Formatter;
import com.zhazhapan.util.NetUtils;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

@Deprecated
public class JsonParser {
    private int maxCache = 1024;
    private String jsonPath;
    private JSONObject jsonObject;
    private volatile HashMap<String, JSONObject> jsonStore = new HashMap(16);

    public JsonParser() {
    }

    public JsonParser(JSONObject jsonObject) {
        this.setJsonObject(jsonObject);
    }

    public JsonParser(String jsonPath) throws IOException {
        this.setJsonPath(jsonPath);
    }

    public JsonParser(URL url) throws IOException {
        this.setJsonPath(url);
    }

    public JsonParser(String json, boolean isPretty) {
        if (!isPretty) {
            json = Formatter.formatJson(json);
        }
        this.setJsonObject(json);
    }

    public boolean hasJsonObject() {
        return Checker.isNotNull(this.jsonObject);
    }

    public boolean set(String path, Object value) {
        this.jsonStore.clear();
        return JSONPath.set((Object)this.jsonObject, (String)this.checkPath(path), (Object)value);
    }

    public Object eval(String path) {
        String key = this.pathToKey(path);
        return this.jsonStore.containsKey(key) ? this.jsonStore.get(key) : JSONPath.eval((Object)this.jsonObject, (String)this.checkPath(path));
    }

    public boolean getBooleanUseEval(String key) {
        Object object = this.eval(key);
        return Checker.isNull(object) ? null : Boolean.valueOf((Boolean)object);
    }

    public int size(String path) {
        return JSONPath.size((Object)this.jsonObject, (String)this.checkPath(path));
    }

    public boolean contains(String path) {
        return JSONPath.contains((Object)this.jsonObject, (String)this.checkPath(path));
    }

    public boolean containsValue(String path, Object value) {
        return JSONPath.containsValue((Object)this.jsonObject, (String)this.checkPath(path), (Object)value);
    }

    public void arrayAdd(String path, Object ... values) {
        this.jsonStore.clear();
        JSONPath.arrayAdd((Object)this.jsonObject, (String)this.checkPath(path), (Object[])values);
    }

    public boolean remove(String path) {
        this.jsonStore.clear();
        return JSONPath.remove((Object)this.jsonObject, (String)this.checkPath(path));
    }

    private String checkPath(String key) {
        if (!key.startsWith("$")) {
            if (!key.startsWith(".")) {
                key = "." + key;
            }
            key = "$" + key;
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    public JSONObject getObject(String key) {
        return (JSONObject)this.get(key, JSONObject.class);
    }

    public JSONObject getObjectUseEval(String key) {
        Object object = this.eval(key);
        return Checker.isNull(object) ? null : (JSONObject)object;
    }

    public JSONArray getArray(String key) {
        return (JSONArray)this.get(key, JSONArray.class);
    }

    public JSONArray getArrayUseEval(String key) {
        Object object = this.eval(key);
        return Checker.isNull(object) ? null : (JSONArray)object;
    }

    public String getString(String key) {
        return (String)this.get(key, String.class);
    }

    public String getStringUseEval(String key) {
        Object object = this.eval(key);
        return Checker.isNull(object) ? null : object.toString();
    }

    public int getInteger(String key) throws Exception {
        return Formatter.stringToInt(this.getString(key));
    }

    public int getIntegerUseEval(String key) {
        String string = this.getStringUseEval(key);
        return Checker.isNull(string) ? null : Integer.valueOf(Formatter.stringToInt(string));
    }

    public double getDouble(String key) throws Exception {
        return Formatter.stringToDouble(this.getString(key));
    }

    public double getDoubleUseEval(String key) {
        String string = this.getStringUseEval(key);
        return Checker.isNull(string) ? null : Double.valueOf(Formatter.stringToDouble(string));
    }

    private void put(String key, JSONObject jsonObject) {
        if (this.jsonStore.size() > this.maxCache || this.jsonStore.size() == Integer.MAX_VALUE) {
            this.jsonStore.clear();
        }
        this.jsonStore.put(key, jsonObject);
    }

    private <T> Object get(String key, Class<T> classT) {
        if (Checker.isNotEmpty(key)) {
            JSONObject object = this.jsonObject;
            String[] keys = key.split("\\.");
            String prefixKey = ".";
            if (this.jsonStore.containsKey(key = this.pathToKey(key))) {
                object = this.jsonStore.get(key);
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    String tempKey = keys[i];
                    prefixKey = prefixKey + tempKey + ".";
                    if (this.jsonStore.containsKey(tempKey)) {
                        object = this.jsonStore.get(tempKey);
                        continue;
                    }
                    if (i < keys.length - 1) {
                        if (tempKey.matches(".*\\[\\d+]$")) {
                            JSONArray array = object.getJSONArray(tempKey.split("\\[")[0]);
                            String idx = tempKey.substring(tempKey.indexOf("[") + 1, tempKey.length() - 1);
                            object = array.getJSONObject(Formatter.stringToInt(idx));
                        } else {
                            object = object.getJSONObject(tempKey);
                        }
                        this.put(prefixKey, object);
                        continue;
                    }
                    key = keys[keys.length - 1];
                    if (key.matches(".*\\[\\d+]$")) {
                        int leftIdx = key.lastIndexOf("[");
                        JSONArray array = object.getJSONArray(key.substring(0, leftIdx));
                        int idx = Formatter.stringToInt(key.substring(leftIdx + 1, key.length() - 1));
                        return this.getObject(classT, null, array, String.valueOf(idx));
                    }
                    return this.getObject(classT, object, null, key);
                }
            }
            return object;
        }
        return null;
    }

    private <T> Object getObject(Class<T> classT, JSONObject jsonObject, JSONArray jsonArray, String key) {
        int idx;
        boolean isObj = Checker.isNull(jsonArray);
        int n = idx = isObj ? 0 : Formatter.stringToInt(key);
        if (classT == JSONObject.class) {
            return isObj ? jsonObject.getJSONObject(key) : jsonArray.getJSONObject(idx);
        }
        if (classT == JSONArray.class) {
            return isObj ? jsonObject.getJSONArray(key) : jsonArray.getJSONArray(idx);
        }
        return isObj ? jsonObject.getString(key) : jsonArray.getString(idx);
    }

    private void load() throws IOException {
        this.setJsonObject(FileExecutor.readFile(this.jsonPath));
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(URL url) throws IOException {
        String path = url.toString();
        if (path.startsWith("file:")) {
            this.setJsonPath(NetUtils.urlToString(url));
        } else {
            this.setJsonObject(FileExecutor.read(url));
        }
    }

    public void setJsonPath(String jsonPath) throws IOException {
        this.jsonPath = jsonPath;
        this.load();
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(String json) {
        this.setJsonObject(JSON.parseObject((String)json));
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonStore.put(".", jsonObject);
        this.jsonObject = jsonObject;
    }

    public String toString() {
        return Formatter.formatJson(this.jsonObject.toString());
    }

    public int getMaxCache() {
        return this.maxCache;
    }

    public void setMaxCache(int maxCache) {
        this.maxCache = maxCache;
    }

    public int getCacheSize() {
        return this.jsonStore.size();
    }

    public void clearCache() {
        this.jsonStore.clear();
    }

    private String pathToKey(String path) {
        if (path.startsWith("$")) {
            path = path.substring(1);
        }
        if (!path.startsWith(".")) {
            path = "." + path;
        }
        if (!path.endsWith(".")) {
            path = path + ".";
        }
        return path;
    }
}

