/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.we.x2c;

import android.app.Activity;
import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zhangyue.we.x2c.IViewCreator;

public class X2C {
    private static final SparseArray<IViewCreator> sSparseArray = new SparseArray();

    public static void setContentView(Activity activity, int layoutId) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity must not be null");
        }
        View view = X2C.getView((Context)activity, layoutId);
        if (view != null) {
            activity.setContentView(view);
        } else {
            activity.setContentView(layoutId);
        }
    }

    public static View inflate(Context context, int layoutId, ViewGroup parent) {
        return X2C.inflate(context, layoutId, parent, true);
    }

    public static View inflate(Context context, int layoutId, ViewGroup parent, boolean attach) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        View view = X2C.getView(context, layoutId);
        if (view != null) {
            if (parent != null) {
                parent.addView(view);
            }
            return view;
        }
        return LayoutInflater.from((Context)context).inflate(layoutId, parent, attach);
    }

    public static View getView(Context context, int layoutId) {
        IViewCreator creator = (IViewCreator)sSparseArray.get(layoutId);
        if (creator == null) {
            try {
                int group = X2C.generateGroupId(layoutId);
                String layoutName = context.getResources().getResourceName(layoutId);
                layoutName = layoutName.substring(layoutName.lastIndexOf("/") + 1);
                String clzName = "com.zhangyue.we.x2c.X2C" + group + "_" + layoutName;
                creator = (IViewCreator)context.getClassLoader().loadClass(clzName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (creator == null) {
                creator = new DefaultCreator();
            }
            sSparseArray.put(layoutId, (Object)creator);
        }
        return creator.createView(context);
    }

    private static int generateGroupId(int layoutId) {
        return layoutId >> 24;
    }

    private static class DefaultCreator
    implements IViewCreator {
        private DefaultCreator() {
        }

        @Override
        public View createView(Context context) {
            return null;
        }
    }
}

