/*
 * Decompiled with CFR 0.152.
 */
package android.databinding;

import android.app.Activity;
import android.content.Context;
import android.databinding.DataBinderMapper;
import android.databinding.DataBinderMapperImpl;
import android.databinding.DataBindingComponent;
import android.databinding.ViewDataBinding;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.zhangyue.we.x2c.X2C;

public class DataBindingX2C {
    private static DataBinderMapper sMapper = new DataBinderMapperImpl();
    private static DataBindingComponent sDefaultComponent = null;

    private DataBindingX2C() {
    }

    public static void setDefaultComponent(DataBindingComponent bindingComponent) {
        sDefaultComponent = bindingComponent;
    }

    public static DataBindingComponent getDefaultComponent() {
        return sDefaultComponent;
    }

    public static <T extends ViewDataBinding> T inflate(LayoutInflater inflater, int layoutId, ViewGroup parent, boolean attachToParent) {
        return DataBindingX2C.inflate(inflater, layoutId, parent, attachToParent, sDefaultComponent);
    }

    public static <T extends ViewDataBinding> T inflate(LayoutInflater inflater, int layoutId, ViewGroup parent, boolean attachToParent, DataBindingComponent bindingComponent) {
        boolean useChildren = parent != null && attachToParent;
        int startChildren = useChildren ? parent.getChildCount() : 0;
        View view = X2C.inflate((Context)inflater.getContext(), (int)layoutId, (ViewGroup)parent, (boolean)attachToParent);
        if (useChildren) {
            return DataBindingX2C.bindToAddedViews(bindingComponent, parent, startChildren, layoutId);
        }
        return DataBindingX2C.bind(bindingComponent, view, layoutId);
    }

    public static <T extends ViewDataBinding> T bind(View root) {
        return DataBindingX2C.bind(root, sDefaultComponent);
    }

    public static <T extends ViewDataBinding> T bind(View root, DataBindingComponent bindingComponent) {
        T binding = DataBindingX2C.getBinding(root);
        if (binding != null) {
            return binding;
        }
        Object tagObj = root.getTag();
        if (!(tagObj instanceof String)) {
            throw new IllegalArgumentException("View is not a binding layout");
        }
        String tag = (String)tagObj;
        int layoutId = sMapper.getLayoutId(tag);
        if (layoutId == 0) {
            throw new IllegalArgumentException("View is not a binding layout. Tag: " + tagObj);
        }
        return (T)sMapper.getDataBinder(bindingComponent, root, layoutId);
    }

    static <T extends ViewDataBinding> T bind(DataBindingComponent bindingComponent, View[] roots, int layoutId) {
        return (T)sMapper.getDataBinder(bindingComponent, roots, layoutId);
    }

    static <T extends ViewDataBinding> T bind(DataBindingComponent bindingComponent, View root, int layoutId) {
        return (T)sMapper.getDataBinder(bindingComponent, root, layoutId);
    }

    public static <T extends ViewDataBinding> T findBinding(View view) {
        while (view != null) {
            ViewParent viewParent;
            String tagString;
            ViewDataBinding binding = ViewDataBinding.getBinding((View)view);
            if (binding != null) {
                return (T)binding;
            }
            Object tag = view.getTag();
            if (tag instanceof String && (tagString = (String)tag).startsWith("layout") && tagString.endsWith("_0")) {
                char nextChar = tagString.charAt(6);
                int slashIndex = tagString.indexOf(47, 7);
                boolean isUnboundRoot = false;
                if (nextChar == '/') {
                    isUnboundRoot = slashIndex == -1;
                } else if (nextChar == '-' && slashIndex != -1) {
                    int nextSlashIndex = tagString.indexOf(47, slashIndex + 1);
                    boolean bl = isUnboundRoot = nextSlashIndex == -1;
                }
                if (isUnboundRoot) {
                    return null;
                }
            }
            if ((viewParent = view.getParent()) instanceof View) {
                view = (View)viewParent;
                continue;
            }
            view = null;
        }
        return null;
    }

    public static <T extends ViewDataBinding> T getBinding(View view) {
        return (T)ViewDataBinding.getBinding((View)view);
    }

    public static <T extends ViewDataBinding> T setContentView(Activity activity, int layoutId) {
        return DataBindingX2C.setContentView(activity, layoutId, sDefaultComponent);
    }

    public static <T extends ViewDataBinding> T setContentView(Activity activity, int layoutId, DataBindingComponent bindingComponent) {
        X2C.setContentView((Activity)activity, (int)layoutId);
        View decorView = activity.getWindow().getDecorView();
        ViewGroup contentView = (ViewGroup)decorView.findViewById(0x1020002);
        return DataBindingX2C.bindToAddedViews(bindingComponent, contentView, 0, layoutId);
    }

    public static String convertBrIdToString(int id2) {
        return sMapper.convertBrIdToString(id2);
    }

    private static <T extends ViewDataBinding> T bindToAddedViews(DataBindingComponent component, ViewGroup parent, int startChildren, int layoutId) {
        int endChildren = parent.getChildCount();
        int childrenAdded = endChildren - startChildren;
        if (childrenAdded == 1) {
            View childView = parent.getChildAt(endChildren - 1);
            return DataBindingX2C.bind(component, childView, layoutId);
        }
        View[] children = new View[childrenAdded];
        for (int i = 0; i < childrenAdded; ++i) {
            children[i] = parent.getChildAt(i + startChildren);
        }
        return DataBindingX2C.bind(component, children, layoutId);
    }
}

